/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.jquantify;

import com.berryworks.jquantify.Clock;
import com.berryworks.jquantify.EventCounterInterval;
import com.berryworks.jquantify.Interval;
import com.berryworks.jquantify.Metric;
import com.berryworks.jquantify.MetricRepository;

public class EventCounter
extends Metric {
    private static final long serialVersionUID = 1L;
    protected EventCounterInterval mCurrentInterval;
    protected EventCounterInterval mPriorInterval;
    protected EventCounterInterval mPeakEvents;
    protected long mNow;

    public EventCounter() {
    }

    public EventCounter(String inLabel, int inIntervalSeconds) {
        super(inLabel, inIntervalSeconds);
        this.createIntervals();
    }

    public EventCounter(String inLabel) {
        this(inLabel, 1);
    }

    public static synchronized EventCounter getEventCounter(String inLabel) {
        EventCounter metric = (EventCounter)MetricRepository.get(inLabel);
        if (metric == null) {
            metric = new EventCounter(inLabel);
            MetricRepository.put(metric);
        }
        return metric;
    }

    public Interval getCurrentInterval() {
        return this.mCurrentInterval;
    }

    public EventCounterInterval getPeakEventsInterval() {
        return this.mPeakEvents;
    }

    public long getPeakEvents() {
        return this.getPeakEventsInterval().getEvents();
    }

    @Override
    public long getCount() {
        return this.getCumulativeEvents();
    }

    public long getCumulativeEvents() {
        return this.mCurrentInterval.getCumulativeEvents();
    }

    public float getCumulativeFreq() {
        float age = this.getAge();
        return (double)age < 0.001 ? 0.0f : (float)this.getCumulativeEvents() / age;
    }

    public float getCurrentFreq() {
        long events = this.mCurrentInterval.getEvents();
        long elapsedMillis = Clock.now() - this.mCurrentInterval.getStartTime();
        if (elapsedMillis <= 0L) {
            return 0.0f;
        }
        if (this.isPriorIntervalRelevant()) {
            events += this.mPriorInterval.getEvents();
            elapsedMillis += this.mPriorInterval.getDuration();
        }
        return (float)(events * 1000L) / (float)elapsedMillis;
    }

    @Override
    public synchronized void add(int inCount) {
        this.normalize();
        this.mCurrentInterval.add(inCount);
    }

    public void normalize() {
        this.mNow = Clock.now();
        long i = this.mCurrentInterval.intervalsBefore(this.mNow);
        if (i <= 0L) {
            return;
        }
        if (this.mCurrentInterval.getEvents() > this.mPeakEvents.getEvents()) {
            this.mPeakEvents.copy(this.mCurrentInterval);
        }
        if (i == 1L) {
            this.normalizePrior_ScenarioA();
            this.normalizeCurrent_ScenarioA();
            ++this.totalIntervals;
        } else if (i > 1L) {
            this.normalizePrior_ScenarioB(i - 1L);
            this.normalizeCurrent_ScenarioB();
            this.totalIntervals += i;
        }
    }

    protected void normalizeCurrent_ScenarioA() {
        this.mCurrentInterval.setClosed(false);
        this.mCurrentInterval.setStartTime(this.mCurrentInterval.getStartTime() + this.mCurrentInterval.getDuration());
        this.mCurrentInterval.setPriorEvents(this.mCurrentInterval.getPriorEvents() + this.mCurrentInterval.getEvents());
        this.mCurrentInterval.setEvents(0L);
    }

    protected void normalizePrior_ScenarioA() {
        this.mPriorInterval.setClosed(true);
        this.mPriorInterval.setStartTime(this.mCurrentInterval.getStartTime());
        this.mPriorInterval.setEvents(this.mCurrentInterval.getEvents());
        this.mPriorInterval.setPriorEvents(this.mCurrentInterval.getPriorEvents());
    }

    protected void normalizeCurrent_ScenarioB() {
        this.mCurrentInterval.setClosed(false);
        this.mCurrentInterval.setStartTime(this.mPriorInterval.getStartTime() + this.mCurrentInterval.getDuration());
        this.mCurrentInterval.setPriorEvents(this.mPriorInterval.getPriorEvents());
        this.mCurrentInterval.setEvents(0L);
    }

    protected void normalizePrior_ScenarioB(long nEmptyIntervals) {
        this.mPriorInterval.setClosed(true);
        this.mPriorInterval.setStartTime(this.mCurrentInterval.getStartTime() + this.mCurrentInterval.getDuration() * nEmptyIntervals);
        this.mPriorInterval.setPriorEvents(this.mCurrentInterval.getPriorEvents() + this.mCurrentInterval.getEvents());
        this.mPriorInterval.setEvents(0L);
    }

    @Override
    public void reset() {
        super.reset();
        this.createIntervals();
    }

    protected void createIntervals() {
        this.mCurrentInterval = new EventCounterInterval(this.intervalSeconds * 1000, this.startTime);
        this.mPriorInterval = new EventCounterInterval(this.intervalSeconds * 1000, this.startTime);
        this.mPeakEvents = new EventCounterInterval(this.intervalSeconds * 1000, this.startTime);
    }

    private boolean isPriorIntervalRelevant() {
        return this.mPriorInterval == null ? false : this.mPriorInterval.getStartTime() != this.mCurrentInterval.getStartTime();
    }
}

