/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.jquantify;

import com.berryworks.jquantify.Clock;
import java.io.Serializable;

public abstract class Metric
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final long LOAD_TIMESTAMP = Clock.now();
    protected long startTime;
    protected int intervalSeconds;
    protected long totalIntervals;
    private String label;

    public Metric(String label, int intervalDurationInSeconds) {
        this.label = label;
        this.startTime = Clock.now();
        this.intervalSeconds = intervalDurationInSeconds;
        this.totalIntervals = 1L;
    }

    public Metric(String label) {
        this(label, 1);
    }

    public Metric() {
    }

    public int getIntervalSeconds() {
        return this.intervalSeconds;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public long getAgeMillis() {
        return Clock.now() - this.startTime;
    }

    public float getAge() {
        return (float)this.getAgeMillis() / 1000.0f;
    }

    public void add() {
        this.add(1);
    }

    public abstract void add(int var1);

    public abstract long getCount();

    public long getTotalIntervals() {
        return this.totalIntervals;
    }

    public void reset() {
        this.startTime = Clock.now();
    }

    public static float uptime() {
        long ageInMillis = Clock.now() - LOAD_TIMESTAMP;
        return (float)ageInMillis / 3600000.0f;
    }
}

