/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.jquantify;

import com.berryworks.jquantify.EventCounter;
import com.berryworks.jquantify.EventCounterInterval;
import com.berryworks.jquantify.MetricRepository;
import com.berryworks.jquantify.SessionCounterInterval;
import java.util.LinkedList;

public class SessionCounter
extends EventCounter {
    private static final long serialVersionUID = 1L;
    private LinkedList<Long> startTimes;
    private SessionCounterInterval peakConcurrency;
    private long recentSessionTime;
    private long maxSessionTime;
    private long maxSessionStartTime;
    private float cumulativeSessionTime;

    public SessionCounter() {
    }

    public SessionCounter(String inLabel, int inIntervalSeconds) {
        super(inLabel, inIntervalSeconds);
        this.reset();
    }

    public SessionCounter(String inLabel) {
        this(inLabel, 1);
    }

    public static synchronized SessionCounter getSessionCounter(String inLabel) {
        SessionCounter metric = (SessionCounter)MetricRepository.get(inLabel);
        if (metric == null) {
            metric = new SessionCounter(inLabel);
            MetricRepository.put(metric);
        }
        return metric;
    }

    public static synchronized SessionCounter getSessionCounter(String inLabel, int inIntervalSeconds) {
        SessionCounter metric = (SessionCounter)MetricRepository.get(inLabel);
        if (metric == null) {
            metric = new SessionCounter(inLabel, inIntervalSeconds);
            MetricRepository.put(metric);
        }
        return metric;
    }

    @Override
    public void reset() {
        super.reset();
        this.maxSessionTime = 0L;
        this.recentSessionTime = 0L;
        this.cumulativeSessionTime = 0L;
        this.startTimes = new LinkedList();
    }

    public long getConcurrency() {
        return ((SessionCounterInterval)this.mCurrentInterval).getConcurrency();
    }

    public long getPeakConcurrency() {
        return this.getPeakConcurrencyInterval().getPeakConcurrency();
    }

    public SessionCounterInterval getPeakConcurrencyInterval() {
        return this.peakConcurrency;
    }

    public float getSessionTime() {
        return this.cumulativeSessionTime;
    }

    public long getRecentSessionTime() {
        return this.recentSessionTime;
    }

    public long getMaximumSessionTime() {
        return this.maxSessionTime;
    }

    public long getMaximumSessionStartTime() {
        return this.maxSessionStartTime;
    }

    public float getSessionTimeMean() {
        long i = this.getCount() - (long)this.startTimes.size();
        return i == 0L ? 0.0f : this.getSessionTime() / (float)i;
    }

    @Override
    public void add(int inIgnored) {
        this.start();
    }

    public synchronized void start() {
        super.add(1);
        this.checkPeakConcurrency();
        this.startTimes.add(this.mNow);
    }

    private void checkPeakConcurrency() {
        SessionCounterInterval currentInterval = (SessionCounterInterval)this.mCurrentInterval;
        if (currentInterval.getPeakConcurrency() > this.peakConcurrency.getPeakConcurrency()) {
            this.peakConcurrency.copy(currentInterval);
        }
    }

    public void stop() {
        this.remove(1);
    }

    public synchronized void remove(int inCount) {
        if (this.startTimes.size() == 0) {
            return;
        }
        this.normalize();
        ((SessionCounterInterval)this.mCurrentInterval).remove(1);
        long duration = this.mNow - this.startTimes.remove();
        this.cumulativeSessionTime += (float)duration;
        this.recentSessionTime = duration;
        if (this.recentSessionTime > this.maxSessionTime) {
            this.maxSessionTime = this.recentSessionTime;
            this.maxSessionStartTime = this.mNow - this.maxSessionTime;
        }
    }

    public void remove() {
        this.remove(1);
    }

    @Override
    protected void createIntervals() {
        this.mPeakEvents = new EventCounterInterval(this.intervalSeconds * 1000, this.startTime);
        this.mCurrentInterval = new SessionCounterInterval(this.intervalSeconds * 1000, this.startTime);
        this.mPriorInterval = new SessionCounterInterval(this.intervalSeconds * 1000, this.startTime);
        this.peakConcurrency = new SessionCounterInterval(this.intervalSeconds * 1000, this.startTime);
    }

    @Override
    protected void normalizeCurrent_ScenarioA() {
        SessionCounterInterval currentInterval = (SessionCounterInterval)this.mCurrentInterval;
        currentInterval.setPriorConcurrency(currentInterval.getConcurrency());
        currentInterval.setEventStops(0L);
        currentInterval.setPeakConcurrency(currentInterval.getPriorConcurrency());
        super.normalizeCurrent_ScenarioA();
    }

    @Override
    protected void normalizePrior_ScenarioA() {
        SessionCounterInterval priorInterval = (SessionCounterInterval)this.mPriorInterval;
        SessionCounterInterval currentInterval = (SessionCounterInterval)this.mCurrentInterval;
        priorInterval.setPriorConcurrency(currentInterval.getPriorConcurrency());
        priorInterval.setEventStops(currentInterval.getEventStops());
        priorInterval.setPeakConcurrency(0L);
        super.normalizePrior_ScenarioA();
    }

    @Override
    protected void normalizeCurrent_ScenarioB() {
        SessionCounterInterval currentInterval = (SessionCounterInterval)this.mCurrentInterval;
        currentInterval.setPriorConcurrency(currentInterval.getConcurrency());
        currentInterval.setEventStops(0L);
        currentInterval.setPeakConcurrency(currentInterval.getPriorConcurrency());
        super.normalizeCurrent_ScenarioB();
    }

    @Override
    protected void normalizePrior_ScenarioB(long nEmptyIntervals) {
        SessionCounterInterval priorInterval = (SessionCounterInterval)this.mPriorInterval;
        SessionCounterInterval currentInterval = (SessionCounterInterval)this.mCurrentInterval;
        priorInterval.setPriorConcurrency(currentInterval.getConcurrency());
        priorInterval.setEventStops(0L);
        priorInterval.setPeakConcurrency(0L);
        super.normalizePrior_ScenarioB(nEmptyIntervals);
    }
}

