/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.jquantify;

import com.berryworks.jquantify.EventCounterInterval;

public class SessionCounterInterval
extends EventCounterInterval {
    private static final long serialVersionUID = 1L;
    private long eventStops;
    private long priorConcurrency;
    private long peakConcurrency;

    public SessionCounterInterval() {
    }

    SessionCounterInterval(long inDuration, long inStartTime) {
        super(inDuration, inStartTime);
        this.priorConcurrency = 0L;
        this.peakConcurrency = 0L;
    }

    long getEventStops() {
        return this.eventStops;
    }

    void setEventStops(long eventStops) {
        this.eventStops = eventStops;
    }

    long getPriorConcurrency() {
        return this.priorConcurrency;
    }

    void setPriorConcurrency(long priorConcurrency) {
        this.priorConcurrency = priorConcurrency;
    }

    public long getPeakConcurrency() {
        return this.peakConcurrency;
    }

    void setPeakConcurrency(long peakConcurrency) {
        this.peakConcurrency = peakConcurrency;
    }

    public SessionCounterInterval copy(SessionCounterInterval inFrom) {
        super.copy(inFrom);
        this.eventStops = inFrom.eventStops;
        this.priorConcurrency = inFrom.priorConcurrency;
        this.peakConcurrency = inFrom.peakConcurrency;
        return this;
    }

    public long getConcurrency() {
        return this.priorConcurrency - this.eventStops + this.events;
    }

    @Override
    public void add(int inCount) {
        super.add(inCount);
        long c = this.getConcurrency();
        if (c > this.peakConcurrency) {
            this.peakConcurrency = c;
        }
    }

    public void remove(int inCount) {
        this.eventStops += (long)inCount;
    }

    @Override
    public String toString() {
        return super.toString() + "\nstops=" + this.eventStops + " priorConcurrency=" + this.priorConcurrency + " peakConcurrency=" + this.peakConcurrency;
    }
}

