/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.jquantify.util;

import com.berryworks.jquantify.EventCounter;
import com.berryworks.jquantify.EventCounterInterval;
import com.berryworks.jquantify.Metric;
import com.berryworks.jquantify.SessionCounter;
import com.berryworks.jquantify.SessionCounterInterval;

public abstract class Format {
    public static String asCSV(EventCounter inEventCounter) {
        StringBuilder sb = new StringBuilder(1000);
        sb.append(Format.metricAsCSV(inEventCounter));
        sb.append(", ").append(inEventCounter.getCount());
        sb.append(", ").append(Format.toDecimalFormat(inEventCounter.getCumulativeFreq()));
        sb.append(", ").append(Format.toDecimalFormat(inEventCounter.getCurrentFreq()));
        EventCounterInterval i = inEventCounter.getPeakEventsInterval();
        sb.append(", ").append(Format.toDecimalFormat(i.getEventRatePerSecond()));
        sb.append(", ").append(i.getStartTime());
        return sb.toString();
    }

    public static String asCSV(SessionCounter inSessionCounter) {
        StringBuilder sb = new StringBuilder(1000);
        sb.append(Format.asCSV((EventCounter)inSessionCounter));
        sb.append(", ").append(inSessionCounter.getConcurrency());
        SessionCounterInterval p = inSessionCounter.getPeakConcurrencyInterval();
        sb.append(", ").append(p.getPeakConcurrency());
        sb.append(", ").append(p.getStartTime());
        sb.append(", ").append(inSessionCounter.getSessionTime());
        sb.append(", ").append(Format.toDecimalFormat(inSessionCounter.getSessionTimeMean()));
        sb.append(", ").append(inSessionCounter.getMaximumSessionTime());
        sb.append(", ").append(inSessionCounter.getMaximumSessionStartTime());
        sb.append(", ").append(inSessionCounter.getRecentSessionTime());
        return sb.toString();
    }

    public static String metricAsCSV(Metric inMetric) {
        return inMetric.getLabel() + ", " + Format.toDecimalFormat(inMetric.getAge());
    }

    public static String percent(double inValue, double inBase) {
        double ratio = 100.0 * inValue / inBase;
        return String.valueOf(ratio) + '%';
    }

    public static String toDecimalFormat(double inValue) {
        long integerPortion = (long)(inValue += 0.05);
        String beforeTheDecimal = String.valueOf(integerPortion);
        String afterTheDecimal = String.valueOf((long)(10.0 * inValue) - integerPortion * 10L);
        return beforeTheDecimal + '.' + afterTheDecimal;
    }
}

