/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.jquantify;

import com.berryworks.jquantify.Clock;
import com.berryworks.jquantify.Interval;

public class EventCounterInterval
implements Interval {
    private static final long serialVersionUID = 1L;
    protected volatile long events;
    private boolean closed;
    private long startTime;
    private long duration;
    private long priorEvents;

    public EventCounterInterval() {
    }

    public EventCounterInterval(long inDuration, long inStartTime) {
        this.priorEvents = 0L;
        this.startTime = inStartTime;
        this.duration = inDuration;
    }

    public EventCounterInterval copy(EventCounterInterval inFrom) {
        this.startTime = inFrom.startTime;
        this.duration = inFrom.duration;
        this.events = inFrom.events;
        this.priorEvents = inFrom.priorEvents;
        this.closed = inFrom.closed;
        return this;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Override
    public float getEventRatePerSecond() {
        float denominator = this.duration;
        if (!this.isPast()) {
            long elapsedMilliseconds = Clock.now() - this.startTime;
            denominator = elapsedMilliseconds <= 0L ? 1.0f : (float)elapsedMilliseconds;
        }
        return (float)(this.events * 1000L) / denominator;
    }

    @Override
    public long getEvents() {
        return this.events;
    }

    void setEvents(long events) {
        this.events = events;
    }

    long getPriorEvents() {
        return this.priorEvents;
    }

    void setPriorEvents(long priorEvents) {
        this.priorEvents = priorEvents;
    }

    @Override
    public long getCumulativeEvents() {
        return this.priorEvents + this.events;
    }

    @Override
    public void add(int inCount) {
        this.events += (long)inCount;
    }

    @Override
    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    @Override
    public boolean isPast() {
        if (this.closed) {
            return true;
        }
        boolean b = Clock.now() > this.startTime + this.duration;
        this.setClosed(b);
        return b;
    }

    @Override
    public long intervalsBefore(long inTime) {
        long n = inTime - this.startTime;
        if (n < this.duration) {
            return 0L;
        }
        this.setClosed(true);
        return n / this.duration;
    }

    public String toString() {
        return "Interval \nclosed=" + this.closed + " events=" + this.events + " priorEvents=" + this.priorEvents;
    }
}

