/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.jquantify.util;

import com.berryworks.jquantify.Metric;

public class VMUsage
extends Metric {
    private static final long serialVersionUID = 1L;
    private int activeThreads = 0;
    private int activeThreadsMinimum;
    private int activeThreadsMaximum = 0;
    private float activeThreadsSum = 0.0f;
    private long freeMemory = 0L;
    private long freeMemoryMinimum;
    private long freeMemoryMaximum = 0L;
    private double freeMemorySum = 0.0;
    private long totalMemory = 0L;
    private long totalMemoryMinimum;
    private long totalMemoryMaximum = 0L;
    private double totalMemorySum = 0.0;
    private int samples = 0;

    public VMUsage(String inLabel) {
        super(inLabel);
        this.add();
        this.activeThreadsMinimum = this.activeThreads;
        this.freeMemoryMinimum = this.freeMemory;
        this.totalMemoryMinimum = this.totalMemory;
    }

    @Override
    public void reset() {
    }

    public int getSampleCount() {
        return this.samples;
    }

    public int getActiveThreads() {
        return this.activeThreads;
    }

    public int getActiveThreadsMinimum() {
        return this.activeThreadsMinimum;
    }

    public int getActiveThreadsMaximum() {
        return this.activeThreadsMaximum;
    }

    public float getActiveThreadsMean() {
        return this.activeThreadsSum / (float)this.samples;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public long getFreeMemoryMinimum() {
        return this.freeMemoryMinimum;
    }

    public long getFreeMemoryMaximum() {
        return this.freeMemoryMaximum;
    }

    public double getFreeMemoryMean() {
        return this.freeMemorySum / (double)this.samples;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public long getTotalMemoryMinimum() {
        return this.totalMemoryMinimum;
    }

    public long getTotalMemoryMaximum() {
        return this.totalMemoryMaximum;
    }

    public double getTotalMemoryMean() {
        return this.totalMemorySum / (double)this.samples;
    }

    @Override
    public long getTotalIntervals() {
        return 0L;
    }

    @Override
    public void add(int inCount) {
        ++this.samples;
        this.activeThreads = Thread.activeCount();
        this.activeThreadsSum += (float)this.activeThreads;
        if (this.activeThreads > this.activeThreadsMaximum) {
            this.activeThreadsMaximum = this.activeThreads;
        }
        if (this.activeThreads < this.activeThreadsMinimum) {
            this.activeThreadsMinimum = this.activeThreads;
        }
        this.freeMemory = Runtime.getRuntime().freeMemory();
        this.freeMemorySum += (double)this.freeMemory / 1000000.0;
        if (this.freeMemory > this.freeMemoryMaximum) {
            this.freeMemoryMaximum = this.freeMemory;
        }
        if (this.freeMemory < this.freeMemoryMinimum) {
            this.freeMemoryMinimum = this.freeMemory;
        }
        this.totalMemory = Runtime.getRuntime().totalMemory();
        this.totalMemorySum += (double)this.totalMemory / 1000000.0;
        if (this.totalMemory > this.totalMemoryMaximum) {
            this.totalMemoryMaximum = this.totalMemory;
        }
        if (this.totalMemory < this.totalMemoryMinimum) {
            this.totalMemoryMinimum = this.totalMemory;
        }
    }

    @Override
    public long getCount() {
        return this.samples;
    }
}

