/*
 * Decompiled with CFR 0.152.
 */
package com.bertoncelj.shirocdi.authz;

import com.bertoncelj.shirocdi.authz.SecuredAction;
import com.bertoncelj.shirocdi.authz.SecuredResource;
import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import java.lang.reflect.Method;
import javax.interceptor.InvocationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionExtractor {
    private static final Logger log = LoggerFactory.getLogger(PermissionExtractor.class);

    public String extract(InvocationContext invocationContext) {
        Method method = invocationContext.getMethod();
        Class<?> clazz = method.getDeclaringClass();
        return this.extract(clazz, method);
    }

    protected String extract(Class<?> clazz, Method method) {
        String actionName;
        SecuredAction securedAction = method.getAnnotation(SecuredAction.class);
        String string = actionName = securedAction != null ? securedAction.value() : null;
        if (Strings.isNullOrEmpty((String)actionName)) {
            actionName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, method.getName());
            log.debug("Generated action name '{}' for method {}", (Object)actionName, (Object)method);
        }
        if (securedAction != null && securedAction.absolute()) {
            return actionName;
        }
        SecuredResource securedResource = clazz.getAnnotation(SecuredResource.class);
        if (!securedResource.securedByDefault() && securedAction == null) {
            return null;
        }
        String resourceName = securedResource.value();
        if (Strings.isNullOrEmpty((String)resourceName)) {
            resourceName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, clazz.getSimpleName());
            log.debug("Generated resource name '{}' for class {}", (Object)resourceName, clazz);
        }
        return resourceName + ":" + actionName;
    }
}

