/*
 * Decompiled with CFR 0.152.
 */
package com.bertoncelj.shirocdi.authz;

import com.bertoncelj.shirocdi.authz.PermissionExtractor;
import com.bertoncelj.shirocdi.authz.SecuredResource;
import com.bertoncelj.shirocdi.authz.ShiroCdi;
import javax.annotation.Priority;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
@SecuredResource
@Interceptor
@Priority(value=2000)
public class SecuredResourceInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SecuredResourceInterceptor.class);
    private PermissionExtractor permissionExtractor;
    private Instance<Subject> subjectInstance;

    @Inject
    public SecuredResourceInterceptor(PermissionExtractor permissionExtractor, @ShiroCdi Instance<Subject> subjectInstance) {
        this.permissionExtractor = permissionExtractor;
        this.subjectInstance = subjectInstance;
    }

    @AroundInvoke
    public Object authorize(InvocationContext invocationContext) throws Exception {
        Subject subject = (Subject)this.subjectInstance.get();
        if (subject == null) {
            throw new AuthorizationException("No subject is present!");
        }
        if (!subject.isAuthenticated()) {
            throw new AuthorizationException("Subject is not authenticated!");
        }
        String permission = this.permissionExtractor.extract(invocationContext);
        if (permission != null) {
            subject.checkPermission(permission);
        }
        return invocationContext.proceed();
    }

    public SecuredResourceInterceptor() {
    }
}

