/*
 * Decompiled with CFR 0.152.
 */
package asset.pipeline.gradle;

import asset.pipeline.AssetCompiler;
import asset.pipeline.AssetPipelineConfigHolder;
import asset.pipeline.AssetSpecLoader;
import asset.pipeline.fs.AssetResolver;
import asset.pipeline.fs.FileSystemAssetResolver;
import asset.pipeline.fs.JarAssetResolver;
import asset.pipeline.gradle.AssetPipelineExtension;
import asset.pipeline.gradle.AssetPipelineExtensionImpl;
import asset.pipeline.gradle.AssetPipelinePlugin;
import asset.pipeline.gradle.GradleEventListener;
import groovy.lang.Closure;
import groovy.lang.Delegate;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class AssetCompile
extends DefaultTask
implements AssetPipelineExtension,
GroovyObject {
    @Delegate
    private AssetPipelineExtension pipelineExtension;
    @Input
    private boolean flattenResolvers;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public AssetCompile() {
        MetaClass metaClass;
        boolean bl;
        AssetPipelineExtensionImpl assetPipelineExtensionImpl = new AssetPipelineExtensionImpl();
        this.pipelineExtension = assetPipelineExtensionImpl;
        this.flattenResolvers = bl = false;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @OutputDirectory
    public File getDestinationDir() {
        return (File)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)this.pipelineExtension.getCompileDir()) ? new File(this.pipelineExtension.getCompileDir()) : null), File.class);
    }

    public void setDestinationDir(File dir) {
        String string = dir.getAbsolutePath();
        this.pipelineExtension.setCompileDir(string);
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getAssetsDir() {
        String path = this.pipelineExtension.getAssetsPath();
        return (File)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)path) ? new File(path) : null), File.class);
    }

    public void setAssetsDir(File assetsDir) {
        String string = assetsDir.getAbsolutePath();
        this.pipelineExtension.setAssetsPath(string);
    }

    @Classpath
    @Optional
    public FileCollection getClasspath() {
        FileCollection runtimeFiles = (FileCollection)this.getProject().getConfigurations().getByName("runtimeClasspath");
        FileCollection totalFiles = runtimeFiles;
        try {
            FileCollection providedFiles = (FileCollection)this.getProject().getConfigurations().getByName("provided");
            if (DefaultTypeTransformation.booleanUnbox((Object)providedFiles)) {
                FileCollection fileCollection;
                totalFiles = fileCollection = totalFiles.plus(providedFiles);
            }
        }
        catch (Exception ex) {
        }
        try {
            FileCollection assetsFiles = (FileCollection)this.getProject().getConfigurations().getByName("assets");
            if (DefaultTypeTransformation.booleanUnbox((Object)assetsFiles)) {
                FileCollection fileCollection;
                totalFiles = fileCollection = totalFiles.plus(assetsFiles);
            }
        }
        catch (Exception ex2) {
        }
        FileCollection fileCollection = totalFiles;
        try {
            return fileCollection;
        }
        catch (Exception e) {
            FileCollection fileCollection2 = (FileCollection)ScriptBytecodeAdapter.asType(null, FileCollection.class);
            return fileCollection2;
        }
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        Reference src = new Reference((Object)this.getProject().files(new Object[]{this.getAssetsDir()}).getAsFileTree());
        public final class _getSource_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference src;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getSource_closure1(Object _outerInstance, Object _thisObject, Reference src) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.src = reference = src;
            }

            public FileTree doCall(String path) {
                File resolverFile = ((AssetCompile)((DefaultTask)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), DefaultTask.class))).getProject().file((Object)path);
                if (resolverFile.exists() && resolverFile.isDirectory()) {
                    FileTree fileTree = ((FileTree)this.src.get()).plus(((AssetCompile)((DefaultTask)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), DefaultTask.class))).getProject().files(new Object[]{path}).getAsFileTree());
                    this.src.set((Object)fileTree);
                    return fileTree;
                }
                return (FileTree)ScriptBytecodeAdapter.castToType(null, FileTree.class);
            }

            @Generated
            public FileTree call(String path) {
                return this.doCall(path);
            }

            @Generated
            public FileTree getSrc() {
                return (FileTree)ScriptBytecodeAdapter.castToType((Object)this.src.get(), FileTree.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getSource_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(this.pipelineExtension.getResolvers(), (Closure)new _getSource_closure1(this, this, src));
        return (FileTree)src.get();
    }

    @TaskAction
    public void compile() {
        CallSite[] callSiteArray = AssetCompile.$getCallSiteArray();
        Object object = callSiteArray[0].callGetProperty(AssetPipelineConfigHolder.class);
        Object object2 = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        ScriptBytecodeAdapter.setProperty((Object)object2, null, AssetPipelineConfigHolder.class, (String)"config");
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].callGroovyObjectGetProperty((Object)this))) {
            Object object3 = callSiteArray[2].call(callSiteArray[3].callGetProperty(AssetPipelineConfigHolder.class), callSiteArray[4].callGroovyObjectGetProperty((Object)this));
            ScriptBytecodeAdapter.setProperty((Object)object3, null, AssetPipelineConfigHolder.class, (String)"config");
        }
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        ScriptBytecodeAdapter.setProperty((Object)list, null, AssetPipelineConfigHolder.class, (String)"resolvers");
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[5].callCurrent((GroovyObject)this);
        } else {
            this.registerResolvers();
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[6].callCurrent((GroovyObject)this);
        } else {
            this.loadAssetSpecifications();
        }
        Object listener = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].callGroovyObjectGetProperty((Object)this)) ? callSiteArray[8].callConstructor(GradleEventListener.class) : null;
        Object assetCompiler = callSiteArray[9].callConstructor(AssetCompiler.class, callSiteArray[10].call((Object)this.pipelineExtension), listener);
        Object object4 = callSiteArray[11].callGetProperty((Object)this.pipelineExtension);
        ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)callSiteArray[12].callGetProperty(assetCompiler), (String)"default");
        Object object5 = callSiteArray[13].callGetProperty((Object)this.pipelineExtension);
        ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)callSiteArray[14].callGetProperty(assetCompiler), (String)"default");
        callSiteArray[15].call(assetCompiler);
    }

    public void registerResolvers() {
        FileSystemAssetResolver mainFileResolver = new FileSystemAssetResolver("application", this.getAssetsDir().getCanonicalPath());
        AssetPipelineConfigHolder.registerResolver((AssetResolver)mainFileResolver);
        public final class _registerResolvers_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _registerResolvers_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String path) {
                File resolverFile = ((AssetCompile)((DefaultTask)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), DefaultTask.class))).getProject().file((Object)path);
                boolean isJarFile = resolverFile.exists() && resolverFile.isFile() && resolverFile.getName().endsWith(".jar");
                boolean isAssetFolder = resolverFile.exists() && resolverFile.isDirectory();
                if (isJarFile) {
                    ((AssetCompile)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AssetCompile.class)).registerJarResolvers(resolverFile);
                    return null;
                }
                if (isAssetFolder) {
                    FileSystemAssetResolver fileResolver = new FileSystemAssetResolver(path, resolverFile.getCanonicalPath(), ((AssetCompile)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AssetCompile.class)).getFlattenResolvers());
                    return AssetPipelineConfigHolder.registerResolver((AssetResolver)fileResolver);
                }
                return null;
            }

            @Generated
            public Object call(String path) {
                return this.doCall(path);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _registerResolvers_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(this.pipelineExtension.getResolvers(), (Closure)new _registerResolvers_closure2(this, this));
        FileCollection fileCollection = this.getClasspath();
        Set set = fileCollection != null ? fileCollection.getFiles() : null;
        public final class _registerResolvers_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _registerResolvers_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                ((AssetCompile)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AssetCompile.class)).registerJarResolvers((File)ScriptBytecodeAdapter.castToType((Object)it, File.class));
                return null;
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _registerResolvers_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Set set2 = set != null ? DefaultGroovyMethods.each((Set)set, (Closure)new _registerResolvers_closure3(this, this)) : null;
    }

    public void registerJarResolvers(File jarFile) {
        boolean isJarFile = jarFile.getName().endsWith(".jar") || jarFile.getName().endsWith(".zip");
        if (jarFile.exists() && isJarFile) {
            AssetPipelineConfigHolder.registerResolver((AssetResolver)new JarAssetResolver(jarFile.getName(), jarFile.getCanonicalPath(), "META-INF/assets"));
            AssetPipelineConfigHolder.registerResolver((AssetResolver)new JarAssetResolver(jarFile.getName(), jarFile.getCanonicalPath(), "META-INF/static"));
            AssetPipelineConfigHolder.registerResolver((AssetResolver)new JarAssetResolver(jarFile.getName(), jarFile.getCanonicalPath(), "META-INF/resources"));
        }
    }

    public void loadAssetSpecifications() {
        Configuration configuration = this.getProject().getConfigurations().getByName(AssetPipelinePlugin.getASSET_CONFIGURATION_NAME());
        Set processorFiles = configuration != null ? configuration.getFiles() : null;
        if (DefaultTypeTransformation.booleanUnbox((Object)processorFiles)) {
            public final class _loadAssetSpecifications_closure4
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _loadAssetSpecifications_closure4(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public URL doCall(Object it) {
                    return ((File)it).toURI().toURL();
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public URL doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _loadAssetSpecifications_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            URL[] urls = (URL[])ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.collect((Iterable)processorFiles, (Closure)new _loadAssetSpecifications_closure4(this, this)), URL[].class);
            URLClassLoader classLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
            AssetSpecLoader.loadSpecifications((ClassLoader)classLoader);
        } else {
            AssetSpecLoader.loadSpecifications();
        }
    }

    @Override
    @Generated
    public boolean getMinifyJs() {
        return this.pipelineExtension.getMinifyJs();
    }

    @Override
    @Generated
    public void setMinifyJs(boolean value) {
        this.pipelineExtension.setMinifyJs(value);
    }

    @Override
    @Generated
    public boolean getEnableSourceMaps() {
        return this.pipelineExtension.getEnableSourceMaps();
    }

    @Override
    @Generated
    public void setEnableSourceMaps(boolean value) {
        this.pipelineExtension.setEnableSourceMaps(value);
    }

    @Override
    @Generated
    public boolean getMinifyCss() {
        return this.pipelineExtension.getMinifyCss();
    }

    @Override
    @Generated
    public void setMinifyCss(boolean value) {
        this.pipelineExtension.setMinifyCss(value);
    }

    @Override
    @Generated
    public boolean getEnableDigests() {
        return this.pipelineExtension.getEnableDigests();
    }

    @Override
    @Generated
    public void setEnableDigests(boolean value) {
        this.pipelineExtension.setEnableDigests(value);
    }

    @Override
    @Generated
    public boolean getSkipNonDigests() {
        return this.pipelineExtension.getSkipNonDigests();
    }

    @Override
    @Generated
    public void setSkipNonDigests(boolean value) {
        this.pipelineExtension.setSkipNonDigests(value);
    }

    @Override
    @Generated
    public boolean getEnableGzip() {
        return this.pipelineExtension.getEnableGzip();
    }

    @Override
    @Generated
    public void setEnableGzip(boolean value) {
        this.pipelineExtension.setEnableGzip(value);
    }

    @Override
    @Generated
    public boolean getPackagePlugin() {
        return this.pipelineExtension.getPackagePlugin();
    }

    @Override
    @Generated
    public void setPackagePlugin(boolean value) {
        this.pipelineExtension.setPackagePlugin(value);
    }

    @Override
    @Generated
    public boolean getDevelopmentRuntime() {
        return this.pipelineExtension.getDevelopmentRuntime();
    }

    @Override
    @Generated
    public void setDevelopmentRuntime(boolean value) {
        this.pipelineExtension.setDevelopmentRuntime(value);
    }

    @Override
    @Generated
    public boolean getVerbose() {
        return this.pipelineExtension.getVerbose();
    }

    @Override
    @Generated
    public void setVerbose(boolean value) {
        this.pipelineExtension.setVerbose(value);
    }

    @Override
    @Generated
    public Integer getMaxThreads() {
        return this.pipelineExtension.getMaxThreads();
    }

    @Override
    @Generated
    public void setMaxThreads(Integer value) {
        this.pipelineExtension.setMaxThreads(value);
    }

    @Override
    @Generated
    public String getCompileDir() {
        return this.pipelineExtension.getCompileDir();
    }

    @Override
    @Generated
    public void setCompileDir(String value) {
        this.pipelineExtension.setCompileDir(value);
    }

    @Override
    @Generated
    public String getAssetsPath() {
        return this.pipelineExtension.getAssetsPath();
    }

    @Override
    @Generated
    public void setAssetsPath(String value) {
        this.pipelineExtension.setAssetsPath(value);
    }

    @Override
    @Generated
    public String getJarTaskName() {
        return this.pipelineExtension.getJarTaskName();
    }

    @Override
    @Generated
    public void setJarTaskName(String value) {
        this.pipelineExtension.setJarTaskName(value);
    }

    @Override
    @Generated
    public Map getMinifyOptions() {
        return this.pipelineExtension.getMinifyOptions();
    }

    @Override
    @Generated
    public void setMinifyOptions(Map value) {
        this.pipelineExtension.setMinifyOptions(value);
    }

    @Override
    @Generated
    public Map getConfigOptions() {
        return this.pipelineExtension.getConfigOptions();
    }

    @Override
    @Generated
    public void setConfigOptions(Map value) {
        this.pipelineExtension.setConfigOptions(value);
    }

    @Override
    @Generated
    public List getExcludesGzip() {
        return this.pipelineExtension.getExcludesGzip();
    }

    @Override
    @Generated
    public void setExcludesGzip(List value) {
        this.pipelineExtension.setExcludesGzip(value);
    }

    @Override
    @Generated
    public List getExcludes() {
        return this.pipelineExtension.getExcludes();
    }

    @Override
    @Generated
    public void setExcludes(List value) {
        this.pipelineExtension.setExcludes(value);
    }

    @Override
    @Generated
    public List getIncludes() {
        return this.pipelineExtension.getIncludes();
    }

    @Override
    @Generated
    public void setIncludes(List value) {
        this.pipelineExtension.setIncludes(value);
    }

    @Override
    @Generated
    public List<String> getResolvers() {
        return this.pipelineExtension.getResolvers();
    }

    @Override
    @Generated
    public void setResolvers(List<String> value) {
        this.pipelineExtension.setResolvers(value);
    }

    public static /* synthetic */ boolean pfaccess$0(AssetCompile $that) {
        return $that.flattenResolvers;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AssetCompile.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public boolean getFlattenResolvers() {
        return this.flattenResolvers;
    }

    @Generated
    public boolean isFlattenResolvers() {
        return this.flattenResolvers;
    }

    @Generated
    public void setFlattenResolvers(boolean bl) {
        this.flattenResolvers = bl;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "config";
        stringArray[1] = "configOptions";
        stringArray[2] = "plus";
        stringArray[3] = "config";
        stringArray[4] = "configOptions";
        stringArray[5] = "registerResolvers";
        stringArray[6] = "loadAssetSpecifications";
        stringArray[7] = "verbose";
        stringArray[8] = "<$constructor$>";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "toMap";
        stringArray[11] = "excludes";
        stringArray[12] = "excludeRules";
        stringArray[13] = "includes";
        stringArray[14] = "includeRules";
        stringArray[15] = "compile";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[16];
        AssetCompile.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(AssetCompile.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AssetCompile.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

