/*
 * Decompiled with CFR 0.152.
 */
package asset.pipeline.grails;

import asset.pipeline.grails.AssetProcessorService;
import asset.pipeline.grails.AssetSupportingCachingLinkGenerator;
import asset.pipeline.grails.AssetSupportingLinkGenerator;
import grails.util.Environment;
import grails.web.mapping.LinkGenerator;
import org.grails.plugins.web.mapping.UrlMappingsAutoConfiguration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={UrlMappingsAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
class AssetPipelineAutoConfiguration {
    @Value(value="${grails.web.linkGenerator.useCache:#{null}}")
    private Boolean cacheUrls;
    @Value(value="${grails.serverURL:#{null}}")
    private String serverURL;

    AssetPipelineAutoConfiguration() {
    }

    @Bean
    LinkGenerator grailsLinkGenerator(AssetProcessorService assetProcessorService) {
        if (this.cacheUrls == null) {
            this.cacheUrls = !Environment.isDevelopmentMode() && !Environment.getCurrent().isReloadEnabled();
        }
        return this.cacheUrls != false ? new AssetSupportingCachingLinkGenerator(this.serverURL, assetProcessorService) : new AssetSupportingLinkGenerator(this.serverURL, assetProcessorService);
    }

    @Bean
    AssetProcessorService assetProcessorService() {
        return new AssetProcessorService();
    }
}

