/* The following code was generated by JFlex 1.6.1 */

/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.bertramlabs.plugins.hcl4j;
import com.bertramlabs.plugins.hcl4j.symbols.*;
import com.bertramlabs.plugins.hcl4j.RuntimeSymbols.*;
import java.util.ArrayList;
import java.util.List;
import java.io.*;

/**
 * This class is a HCL lexer Generated from jflex.
 * @author David Estes
 */


class HCLLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int STRINGDOUBLE = 2;
  public static final int STRINGSINGLE = 4;
  public static final int HCLINBLOCK = 6;
  public static final int HCLBLOCKHEADER = 8;
  public static final int HCLBLOCKATTRIBUTES = 10;
  public static final int HCLATTRIBUTE = 12;
  public static final int HCLATTRIBUTEVALUE = 14;
  public static final int HCLARRAY = 16;
  public static final int HCLMAP = 18;
  public static final int HCLMAPKEY = 20;
  public static final int HCLMAPKEYDEF = 22;
  public static final int HCLMAPVALUE = 24;
  public static final int STRINGINTERPOLATED = 26;
  public static final int MULTILINESTRING = 28;
  public static final int EVALUATEDEXPRESSION = 30;
  public static final int FORLOOPEXPRESSION = 32;
  public static final int FORTUPLEEXPRESSION = 34;
  public static final int FOROBJECTEXPRESSION = 36;
  public static final int SUBTYPEPRIMITIVETYPE = 38;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 
    16, 16, 17, 17, 18, 18, 19, 19
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\53\1\2\1\0\1\3\1\1\22\0\1\50\1\0\1\36"+
    "\1\6\1\44\2\0\1\41\1\13\1\15\1\5\1\0\1\14\1\47"+
    "\1\12\1\4\12\10\1\43\1\0\1\45\1\42\1\0\2\0\32\11"+
    "\1\16\1\51\1\52\1\0\1\11\1\0\1\24\1\33\2\11\1\22"+
    "\1\23\1\31\1\11\1\30\2\11\1\25\1\32\1\27\1\34\1\35"+
    "\1\11\1\20\1\26\1\17\1\21\5\11\1\37\1\0\1\40\1\46"+
    "\43\0\4\7\4\0\1\7\12\0\1\7\4\0\1\7\5\0\27\7"+
    "\1\0\37\7\1\0\u01ca\7\4\0\14\7\16\0\5\7\7\0\1\7"+
    "\1\0\1\7\201\0\5\7\1\0\2\7\2\0\4\7\10\0\1\7"+
    "\1\0\3\7\1\0\1\7\1\0\24\7\1\0\123\7\1\0\213\7"+
    "\10\0\236\7\11\0\46\7\2\0\1\7\7\0\47\7\7\0\1\7"+
    "\100\0\33\7\5\0\3\7\30\0\1\7\24\0\53\7\43\0\2\7"+
    "\1\0\143\7\1\0\1\7\17\0\2\7\7\0\2\7\12\0\3\7"+
    "\2\0\1\7\20\0\1\7\1\0\36\7\35\0\131\7\13\0\1\7"+
    "\30\0\41\7\11\0\2\7\4\0\1\7\5\0\26\7\4\0\1\7"+
    "\11\0\1\7\3\0\1\7\27\0\31\7\107\0\1\7\1\0\13\7"+
    "\127\0\66\7\3\0\1\7\22\0\1\7\7\0\12\7\17\0\7\7"+
    "\1\0\7\7\5\0\10\7\2\0\2\7\2\0\26\7\1\0\7\7"+
    "\1\0\1\7\3\0\4\7\3\0\1\7\20\0\1\7\15\0\2\7"+
    "\1\0\3\7\16\0\4\7\7\0\1\7\11\0\6\7\4\0\2\7"+
    "\2\0\26\7\1\0\7\7\1\0\2\7\1\0\2\7\1\0\2\7"+
    "\37\0\4\7\1\0\1\7\23\0\3\7\20\0\11\7\1\0\3\7"+
    "\1\0\26\7\1\0\7\7\1\0\2\7\1\0\5\7\3\0\1\7"+
    "\22\0\1\7\17\0\2\7\17\0\1\7\23\0\10\7\2\0\2\7"+
    "\2\0\26\7\1\0\7\7\1\0\2\7\1\0\5\7\3\0\1\7"+
    "\36\0\2\7\1\0\3\7\17\0\1\7\21\0\1\7\1\0\6\7"+
    "\3\0\3\7\1\0\4\7\3\0\2\7\1\0\1\7\1\0\2\7"+
    "\3\0\2\7\3\0\3\7\3\0\14\7\26\0\1\7\50\0\1\7"+
    "\13\0\10\7\1\0\3\7\1\0\27\7\1\0\12\7\1\0\5\7"+
    "\3\0\1\7\32\0\2\7\6\0\2\7\43\0\10\7\1\0\3\7"+
    "\1\0\27\7\1\0\12\7\1\0\5\7\3\0\1\7\40\0\1\7"+
    "\1\0\2\7\17\0\2\7\22\0\10\7\1\0\3\7\1\0\51\7"+
    "\2\0\1\7\20\0\1\7\21\0\2\7\30\0\6\7\5\0\22\7"+
    "\3\0\30\7\1\0\11\7\1\0\1\7\2\0\7\7\72\0\60\7"+
    "\1\0\2\7\13\0\10\7\72\0\2\7\1\0\1\7\2\0\2\7"+
    "\1\0\1\7\2\0\1\7\6\0\4\7\1\0\7\7\1\0\3\7"+
    "\1\0\1\7\1\0\1\7\2\0\2\7\1\0\4\7\1\0\2\7"+
    "\11\0\1\7\2\0\5\7\1\0\1\7\25\0\4\7\40\0\1\7"+
    "\77\0\10\7\1\0\44\7\33\0\5\7\163\0\53\7\24\0\1\7"+
    "\20\0\6\7\4\0\4\7\3\0\1\7\3\0\2\7\7\0\3\7"+
    "\4\0\15\7\14\0\1\7\21\0\46\7\1\0\1\7\5\0\1\7"+
    "\2\0\53\7\1\0\u014d\7\1\0\4\7\2\0\7\7\1\0\1\7"+
    "\1\0\4\7\2\0\51\7\1\0\4\7\2\0\41\7\1\0\4\7"+
    "\2\0\7\7\1\0\1\7\1\0\4\7\2\0\17\7\1\0\71\7"+
    "\1\0\4\7\2\0\103\7\45\0\20\7\20\0\125\7\14\0\u026c\7"+
    "\2\0\21\7\1\0\32\7\5\0\113\7\3\0\3\7\17\0\15\7"+
    "\1\0\4\7\16\0\22\7\16\0\22\7\16\0\15\7\1\0\3\7"+
    "\17\0\64\7\43\0\1\7\3\0\2\7\103\0\130\7\10\0\51\7"+
    "\1\0\1\7\5\0\106\7\12\0\35\7\63\0\36\7\2\0\5\7"+
    "\13\0\54\7\25\0\7\7\70\0\27\7\11\0\65\7\122\0\1\7"+
    "\135\0\57\7\21\0\7\7\67\0\36\7\15\0\2\7\12\0\54\7"+
    "\32\0\44\7\51\0\3\7\12\0\44\7\153\0\4\7\1\0\4\7"+
    "\3\0\2\7\11\0\300\7\100\0\u0116\7\2\0\6\7\2\0\46\7"+
    "\2\0\6\7\2\0\10\7\1\0\1\7\1\0\1\7\1\0\1\7"+
    "\1\0\37\7\2\0\65\7\1\0\7\7\1\0\1\7\3\0\3\7"+
    "\1\0\7\7\3\0\4\7\2\0\6\7\4\0\15\7\5\0\3\7"+
    "\1\0\7\7\102\0\2\7\23\0\1\7\34\0\1\7\15\0\1\7"+
    "\20\0\15\7\3\0\33\7\107\0\1\7\4\0\1\7\2\0\12\7"+
    "\1\0\1\7\3\0\5\7\6\0\1\7\1\0\1\7\1\0\1\7"+
    "\1\0\4\7\1\0\13\7\2\0\4\7\5\0\5\7\4\0\1\7"+
    "\21\0\51\7\u0a77\0\57\7\1\0\57\7\1\0\205\7\6\0\4\7"+
    "\3\0\2\7\14\0\46\7\1\0\1\7\5\0\1\7\2\0\70\7"+
    "\7\0\1\7\20\0\27\7\11\0\7\7\1\0\7\7\1\0\7\7"+
    "\1\0\7\7\1\0\7\7\1\0\7\7\1\0\7\7\1\0\7\7"+
    "\120\0\1\7\u01d5\0\3\7\31\0\11\7\7\0\5\7\2\0\5\7"+
    "\4\0\126\7\6\0\3\7\1\0\132\7\1\0\4\7\5\0\51\7"+
    "\3\0\136\7\21\0\33\7\65\0\20\7\u0200\0\u19b6\7\112\0\u51cd\7"+
    "\63\0\u048d\7\103\0\56\7\2\0\u010d\7\3\0\20\7\12\0\2\7"+
    "\24\0\57\7\20\0\31\7\10\0\120\7\47\0\11\7\2\0\147\7"+
    "\2\0\4\7\1\0\4\7\14\0\13\7\115\0\12\7\1\0\3\7"+
    "\1\0\4\7\1\0\27\7\25\0\1\7\7\0\64\7\16\0\62\7"+
    "\76\0\6\7\3\0\1\7\16\0\34\7\12\0\27\7\31\0\35\7"+
    "\7\0\57\7\34\0\1\7\60\0\51\7\27\0\3\7\1\0\10\7"+
    "\24\0\27\7\3\0\1\7\5\0\60\7\1\0\1\7\3\0\2\7"+
    "\2\0\5\7\2\0\1\7\1\0\1\7\30\0\3\7\2\0\13\7"+
    "\7\0\3\7\14\0\6\7\2\0\6\7\2\0\6\7\11\0\7\7"+
    "\1\0\7\7\221\0\43\7\35\0\u2ba4\7\14\0\27\7\4\0\61\7"+
    "\u2104\0\u016e\7\2\0\152\7\46\0\7\7\14\0\5\7\5\0\1\7"+
    "\1\0\12\7\1\0\15\7\1\0\5\7\1\0\1\7\1\0\2\7"+
    "\1\0\2\7\1\0\154\7\41\0\u016b\7\22\0\100\7\2\0\66\7"+
    "\50\0\15\7\66\0\2\7\30\0\3\7\31\0\1\7\6\0\5\7"+
    "\1\0\207\7\7\0\1\7\34\0\32\7\4\0\1\7\1\0\32\7"+
    "\13\0\131\7\3\0\6\7\2\0\6\7\2\0\6\7\2\0\3\7"+
    "\3\0\2\7\3\0\2\7\31\0\14\7\1\0\32\7\1\0\23\7"+
    "\1\0\2\7\1\0\17\7\2\0\16\7\42\0\173\7\105\0\65\7"+
    "\u010b\0\35\7\3\0\61\7\57\0\37\7\21\0\33\7\65\0\36\7"+
    "\2\0\44\7\4\0\10\7\1\0\5\7\52\0\236\7\u0362\0\6\7"+
    "\2\0\1\7\1\0\54\7\1\0\2\7\3\0\1\7\2\0\27\7"+
    "\252\0\26\7\12\0\32\7\106\0\70\7\6\0\2\7\100\0\1\7"+
    "\17\0\4\7\1\0\3\7\1\0\33\7\54\0\35\7\203\0\66\7"+
    "\12\0\26\7\12\0\23\7\215\0\111\7\u03ba\0\65\7\113\0\55\7"+
    "\40\0\31\7\32\0\44\7\134\0\60\7\16\0\4\7\u04bb\0\53\7"+
    "\u0955\0\u036f\7\221\0\143\7\u0b9d\0\u042f\7\u33d1\0\u0239\7\u04c7\0\105\7"+
    "\13\0\1\7\102\0\15\7\u4060\0\2\7\u23fe\0\125\7\1\0\107\7"+
    "\1\0\2\7\2\0\1\7\2\0\2\7\2\0\4\7\1\0\14\7"+
    "\1\0\1\7\1\0\7\7\1\0\101\7\1\0\4\7\2\0\10\7"+
    "\1\0\7\7\1\0\34\7\1\0\4\7\1\0\5\7\1\0\1\7"+
    "\3\0\7\7\1\0\u0154\7\2\0\31\7\1\0\31\7\1\0\37\7"+
    "\1\0\31\7\1\0\37\7\1\0\31\7\1\0\37\7\1\0\31\7"+
    "\1\0\37\7\1\0\31\7\1\0\10\7\u1634\0\4\7\1\0\33\7"+
    "\1\0\2\7\1\0\1\7\2\0\1\7\1\0\12\7\1\0\4\7"+
    "\1\0\1\7\1\0\1\7\6\0\1\7\4\0\1\7\1\0\1\7"+
    "\1\0\1\7\1\0\3\7\1\0\2\7\1\0\1\7\2\0\1\7"+
    "\1\0\1\7\1\0\1\7\1\0\1\7\1\0\1\7\1\0\2\7"+
    "\1\0\1\7\2\0\4\7\1\0\7\7\1\0\4\7\1\0\4\7"+
    "\1\0\1\7\1\0\12\7\1\0\21\7\5\0\3\7\1\0\5\7"+
    "\1\0\21\7\u1144\0\ua6d7\7\51\0\u1035\7\13\0\336\7\u3fe2\0\u021e\7"+
    "\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\u05f0\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\24\0\6\1\1\2\1\3\1\4\1\3\1\5\1\2"+
    "\1\5\3\3\1\6\1\7\1\10\1\11\1\12\1\13"+
    "\1\14\1\15\1\16\1\15\1\17\7\15\1\20\1\3"+
    "\3\21\1\22\1\23\2\3\1\24\1\25\1\26\1\3"+
    "\1\27\1\2\1\30\1\31\1\32\1\33\2\34\1\1"+
    "\1\23\2\1\1\35\1\36\2\3\5\1\2\37\1\40"+
    "\1\41\5\3\7\0\1\42\1\0\1\2\1\43\1\44"+
    "\1\45\1\46\1\47\1\50\1\51\1\15\2\0\10\15"+
    "\6\0\1\52\3\0\1\26\1\1\4\0\1\1\13\0"+
    "\1\53\2\0\4\15\2\54\2\15\2\55\1\15\1\56"+
    "\2\0\1\57\2\0\1\52\1\1\2\0\1\1\2\0"+
    "\2\60\1\0\2\61\2\0\1\1\2\0\1\42\1\0"+
    "\1\62\1\15\2\63\2\15\1\64\2\15\1\65\1\0"+
    "\1\56\1\66\1\1\2\0\1\1\2\67\4\0\1\70"+
    "\3\0\1\71\3\15\6\0\1\72\1\73\1\74\1\75"+
    "\1\76\1\77\1\100\5\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[241];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\54\0\130\0\204\0\260\0\334\0\u0108\0\u0134"+
    "\0\u0160\0\u018c\0\u01b8\0\u01e4\0\u0210\0\u023c\0\u0268\0\u0294"+
    "\0\u02c0\0\u02ec\0\u0318\0\u0344\0\u0370\0\u039c\0\u03c8\0\u03f4"+
    "\0\u0420\0\u044c\0\u0478\0\u0370\0\u0370\0\u04a4\0\u04d0\0\u04fc"+
    "\0\u0528\0\u03c8\0\u0420\0\u044c\0\u0370\0\u0554\0\u0370\0\u0370"+
    "\0\u0580\0\u0370\0\u0370\0\u05ac\0\u05d8\0\u0370\0\u0604\0\u0630"+
    "\0\u065c\0\u0688\0\u06b4\0\u06e0\0\u070c\0\u0738\0\u0764\0\u0790"+
    "\0\u0370\0\u03c8\0\u03f4\0\u0370\0\u0370\0\u07bc\0\u07e8\0\u0814"+
    "\0\u0370\0\u0840\0\u086c\0\u0370\0\u0898\0\u0370\0\u0370\0\u0370"+
    "\0\u08c4\0\u08f0\0\u0370\0\u091c\0\u0948\0\u0974\0\u09a0\0\u09cc"+
    "\0\u0370\0\u09f8\0\u0a24\0\u0a50\0\u0a7c\0\u0aa8\0\u0ad4\0\u0b00"+
    "\0\u0b2c\0\u0370\0\u0370\0\u0370\0\u0b58\0\u0b84\0\u0bb0\0\u0bdc"+
    "\0\u0c08\0\u0c34\0\u0c60\0\u0c8c\0\u0cb8\0\u0420\0\u0ce4\0\u0d10"+
    "\0\u0370\0\u0d3c\0\u0370\0\u0370\0\u0370\0\u0370\0\u0370\0\u0370"+
    "\0\u0370\0\u0370\0\u0d68\0\u0604\0\u0d94\0\u0dc0\0\u0dec\0\u0e18"+
    "\0\u0e44\0\u0e70\0\u0e9c\0\u0ec8\0\u0ef4\0\u0764\0\u0f20\0\u0f4c"+
    "\0\u0f78\0\u0fa4\0\u07bc\0\u0370\0\u07e8\0\u0fd0\0\u086c\0\u086c"+
    "\0\u0ffc\0\u09f8\0\u1028\0\u0a24\0\u1054\0\u1080\0\u10ac\0\u10d8"+
    "\0\u1104\0\u1130\0\u115c\0\u1188\0\u11b4\0\u11e0\0\u120c\0\u1238"+
    "\0\u1264\0\u0d10\0\u1290\0\u12bc\0\u12e8\0\u1314\0\u1340\0\u136c"+
    "\0\u0370\0\u1398\0\u13c4\0\u13f0\0\u0370\0\u141c\0\u1448\0\u0370"+
    "\0\u1474\0\u14a0\0\u14cc\0\u14f8\0\u1524\0\u07e8\0\u1550\0\u157c"+
    "\0\u15a8\0\u15d4\0\u1600\0\u162c\0\u0370\0\u1658\0\u1684\0\u0370"+
    "\0\u16b0\0\u16dc\0\u1708\0\u11b4\0\u1734\0\u1760\0\u0d3c\0\u178c"+
    "\0\u05ac\0\u17b8\0\u0370\0\u17e4\0\u1810\0\u1398\0\u05ac\0\u183c"+
    "\0\u141c\0\u05ac\0\u1868\0\u0f78\0\u1894\0\u18c0\0\u18ec\0\u1918"+
    "\0\u1944\0\u0370\0\u1970\0\u199c\0\u1658\0\u19c8\0\u16b0\0\u0370"+
    "\0\u19f4\0\u1a20\0\u1a4c\0\u05ac\0\u17e4\0\u1a78\0\u1aa4\0\u1ad0"+
    "\0\u1afc\0\u1970\0\u1b28\0\u1b54\0\u1b80\0\u1bac\0\u05ac\0\u05ac"+
    "\0\u1bd8\0\u1c04\0\u0370\0\u0370\0\u1c30\0\u1c5c\0\u1c88\0\u1cb4"+
    "\0\u1ce0";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[241];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\25\1\26\2\25\1\27\1\25\1\30\1\31\1\25"+
    "\1\31\5\25\17\31\1\32\5\25\1\31\7\25\1\33"+
    "\2\34\33\33\1\35\5\33\1\36\4\33\1\37\2\33"+
    "\1\40\2\34\36\40\1\35\7\40\1\41\2\40\1\34"+
    "\1\26\2\25\1\42\1\34\1\30\1\43\1\34\1\43"+
    "\5\34\17\43\1\44\1\34\1\45\3\34\1\43\3\34"+
    "\1\25\2\34\1\25\1\34\1\26\2\25\3\34\1\46"+
    "\1\34\1\46\5\34\17\46\6\34\1\46\3\34\1\25"+
    "\2\34\1\25\1\34\1\26\2\25\32\34\1\47\1\50"+
    "\10\34\1\25\2\34\1\25\1\34\1\26\2\25\3\34"+
    "\1\51\1\34\1\51\5\34\17\51\1\52\3\34\1\53"+
    "\1\34\1\51\3\34\1\25\2\34\1\25\1\34\1\26"+
    "\2\25\1\42\1\34\1\30\1\54\1\55\1\54\1\55"+
    "\1\56\2\34\1\57\1\60\3\54\1\61\1\54\1\62"+
    "\1\63\1\64\2\54\1\65\1\66\2\54\1\47\1\67"+
    "\4\34\1\54\1\70\1\34\1\55\1\25\2\34\1\25"+
    "\1\71\1\26\1\25\1\71\1\72\1\71\1\73\5\71"+
    "\1\74\33\71\1\25\1\71\1\75\1\25\1\34\1\26"+
    "\2\25\3\34\1\76\1\34\1\76\2\34\1\74\2\34"+
    "\17\76\1\77\1\34\1\75\3\34\1\76\3\34\1\25"+
    "\2\34\1\25\1\34\1\26\2\25\3\34\1\100\1\34"+
    "\1\100\5\34\17\100\1\101\5\34\1\100\3\34\1\25"+
    "\2\34\1\25\1\34\1\26\2\25\1\42\1\34\1\30"+
    "\1\102\1\34\1\102\5\34\17\102\1\103\4\34\1\104"+
    "\1\102\3\34\1\25\2\34\1\25\54\34\36\105\1\106"+
    "\1\107\1\110\10\105\1\34\2\105\1\111\1\112\1\113"+
    "\51\111\1\114\1\115\1\75\1\114\1\116\1\114\1\117"+
    "\1\120\1\114\1\120\5\114\17\120\2\114\1\121\3\114"+
    "\1\120\7\114\16\34\1\122\20\34\1\123\14\34\1\124"+
    "\1\125\1\25\1\124\1\126\1\124\1\127\43\124\1\75"+
    "\1\124\1\114\1\130\1\25\1\114\1\116\1\114\1\117"+
    "\31\114\1\75\13\114\1\34\1\131\1\132\1\25\1\42"+
    "\1\34\1\30\4\34\1\133\1\34\1\134\7\34\1\135"+
    "\1\136\1\137\2\34\1\140\1\141\14\34\1\25\2\34"+
    "\1\25\56\0\1\25\55\0\1\30\1\142\46\0\1\30"+
    "\1\26\1\25\51\30\1\0\1\143\1\144\1\145\4\0"+
    "\2\146\5\0\17\146\1\147\1\150\2\0\1\151\4\0"+
    "\1\146\1\145\2\0\1\145\1\152\2\0\51\152\1\33"+
    "\2\0\33\33\1\0\5\33\1\0\4\33\1\0\2\33"+
    "\36\153\1\154\1\155\14\153\17\0\1\156\1\157\6\0"+
    "\1\160\6\0\1\161\15\0\1\40\2\0\36\40\1\0"+
    "\7\40\1\0\2\40\17\0\1\156\1\157\6\0\1\160"+
    "\11\0\1\162\22\0\2\46\5\0\17\46\11\0\1\46"+
    "\14\0\2\51\5\0\17\51\11\0\1\51\14\0\2\54"+
    "\1\163\1\56\2\0\1\56\17\54\11\0\1\54\14\0"+
    "\1\55\1\0\1\55\34\0\1\55\5\0\3\164\17\0"+
    "\1\165\24\0\1\164\2\0\1\164\10\0\2\54\1\163"+
    "\1\56\2\0\1\56\1\54\1\166\15\54\11\0\1\54"+
    "\14\0\2\54\1\163\1\56\2\0\1\56\5\54\1\167"+
    "\11\54\11\0\1\54\14\0\2\54\1\163\1\56\2\0"+
    "\1\56\11\54\1\170\5\54\11\0\1\54\14\0\2\54"+
    "\1\163\1\56\2\0\1\56\1\171\2\54\1\172\13\54"+
    "\11\0\1\54\14\0\2\54\1\163\1\56\2\0\1\56"+
    "\2\54\1\173\14\54\11\0\1\54\14\0\2\54\1\163"+
    "\1\56\2\0\1\56\5\54\1\174\11\54\11\0\1\54"+
    "\14\0\2\54\1\163\1\56\2\0\1\56\15\54\1\175"+
    "\1\54\11\0\1\54\5\0\2\164\1\176\3\0\1\177"+
    "\1\0\1\177\5\0\4\177\1\200\12\177\1\201\5\0"+
    "\1\177\3\0\1\176\2\0\1\176\45\0\1\202\16\0"+
    "\2\203\5\0\17\203\5\0\1\204\3\0\1\203\4\0"+
    "\1\205\2\0\33\205\1\206\15\205\10\0\2\100\5\0"+
    "\17\100\11\0\1\100\14\0\2\102\5\0\17\102\11\0"+
    "\1\102\4\0\1\207\2\0\33\207\1\210\15\207\36\105"+
    "\3\0\10\105\1\0\2\105\1\111\2\0\51\111\2\0"+
    "\1\113\51\0\2\114\1\0\35\114\1\0\15\114\1\75"+
    "\35\114\1\0\15\114\1\0\1\114\1\117\1\211\32\114"+
    "\1\0\13\114\1\117\1\130\1\25\35\117\1\30\13\117"+
    "\2\114\1\0\5\114\3\120\4\114\17\120\2\114\1\0"+
    "\6\114\1\120\4\114\1\0\3\212\17\0\1\213\24\0"+
    "\1\212\2\0\1\212\1\0\3\214\17\0\1\215\24\0"+
    "\1\214\2\0\1\214\2\124\1\0\47\124\1\0\3\124"+
    "\1\25\47\124\1\0\3\124\1\0\1\124\1\127\1\216"+
    "\44\124\1\0\1\124\1\127\1\125\1\25\47\127\1\30"+
    "\1\127\2\114\1\25\35\114\1\0\13\114\2\0\1\132"+
    "\101\0\1\217\42\0\1\220\2\0\1\221\52\0\1\222"+
    "\56\0\1\223\63\0\1\224\17\0\5\225\1\226\46\225"+
    "\2\0\1\144\36\0\1\227\53\0\1\227\15\0\1\230"+
    "\32\0\1\147\1\150\1\0\1\227\1\151\5\0\1\230"+
    "\2\0\1\230\1\147\2\0\33\147\1\231\15\147\40\150"+
    "\1\232\13\150\1\152\2\0\33\152\1\233\15\152\10\0"+
    "\3\163\4\0\17\163\11\0\1\163\40\0\1\234\27\0"+
    "\2\54\1\163\1\56\2\0\1\56\2\54\1\235\14\54"+
    "\11\0\1\54\14\0\2\54\1\163\1\56\2\0\1\56"+
    "\6\54\1\236\10\54\11\0\1\54\14\0\2\54\1\163"+
    "\1\56\2\0\1\56\7\54\1\237\7\54\11\0\1\54"+
    "\14\0\2\54\1\163\1\56\2\0\1\56\1\54\1\240"+
    "\15\54\11\0\1\54\14\0\2\54\1\163\1\241\2\0"+
    "\1\56\1\242\16\54\11\0\1\54\14\0\2\54\1\163"+
    "\1\56\2\0\1\56\6\54\1\243\4\54\1\244\3\54"+
    "\11\0\1\54\14\0\2\54\1\163\1\245\2\0\1\56"+
    "\16\54\1\246\11\0\1\54\14\0\2\54\1\163\1\56"+
    "\2\0\1\56\15\54\1\247\1\54\11\0\1\54\14\0"+
    "\2\177\5\0\17\177\5\0\1\250\3\0\1\177\14\0"+
    "\2\177\5\0\15\177\1\251\1\177\5\0\1\250\3\0"+
    "\1\177\4\0\1\201\2\0\33\201\1\252\15\201\7\0"+
    "\1\253\1\0\1\253\5\0\17\253\6\0\1\253\1\0"+
    "\2\254\1\255\3\0\1\205\2\0\33\205\1\206\4\205"+
    "\1\256\10\205\2\257\1\225\35\257\1\225\13\257\34\0"+
    "\1\260\53\0\1\261\17\0\2\262\1\225\47\262\1\225"+
    "\1\262\26\0\1\263\45\0\1\264\46\0\1\265\3\0"+
    "\1\266\66\0\1\267\34\0\1\270\21\0\1\271\52\0"+
    "\1\272\17\0\5\225\1\273\52\225\1\274\1\273\46\225"+
    "\41\227\1\275\12\227\3\0\1\230\32\0\1\147\1\150"+
    "\2\0\1\151\5\0\1\230\2\0\1\230\1\147\1\143"+
    "\1\144\1\276\32\147\1\231\1\150\10\147\1\276\2\147"+
    "\1\276\1\152\2\0\1\233\32\152\1\233\3\152\1\277"+
    "\5\152\1\233\2\152\1\233\20\0\1\300\43\0\2\54"+
    "\1\163\1\56\2\0\1\56\3\54\1\301\13\54\11\0"+
    "\1\54\14\0\2\54\1\163\1\56\2\0\1\56\7\54"+
    "\1\302\7\54\11\0\1\54\14\0\2\54\1\163\1\303"+
    "\2\0\1\56\1\304\16\54\11\0\1\54\14\0\2\54"+
    "\1\163\1\56\2\0\1\56\11\54\1\305\5\54\11\0"+
    "\1\54\14\0\2\54\1\163\1\241\2\0\1\56\1\306"+
    "\16\54\11\0\1\54\14\0\2\54\1\163\1\56\2\0"+
    "\1\56\6\54\1\307\10\54\11\0\1\54\14\0\2\54"+
    "\1\163\1\56\2\0\1\56\14\54\1\310\2\54\11\0"+
    "\1\54\14\0\2\54\1\163\1\245\2\0\1\56\16\54"+
    "\1\311\11\0\1\54\14\0\2\54\1\163\1\56\2\0"+
    "\1\56\6\54\1\312\10\54\11\0\1\54\14\0\2\177"+
    "\5\0\1\177\1\313\15\177\5\0\1\250\3\0\1\177"+
    "\4\0\1\201\2\0\33\201\1\252\4\201\1\314\10\201"+
    "\10\0\2\253\5\0\17\253\11\0\1\253\13\0\1\315"+
    "\1\0\1\315\5\0\17\315\6\0\1\315\16\0\1\253"+
    "\1\0\1\253\5\0\17\253\6\0\1\253\7\0\2\257"+
    "\1\225\2\257\1\316\32\257\1\225\13\257\20\0\1\317"+
    "\53\0\1\320\33\0\2\262\1\225\2\262\1\321\44\262"+
    "\1\225\1\262\13\0\1\322\3\0\1\323\64\0\1\324"+
    "\36\0\1\265\3\0\1\325\67\0\1\326\33\0\1\270"+
    "\21\0\1\327\43\0\1\330\26\0\4\225\1\25\1\273"+
    "\46\225\1\0\1\143\1\144\1\331\32\0\1\147\1\150"+
    "\10\0\1\331\2\0\1\331\1\147\1\143\1\144\1\276"+
    "\32\147\1\231\1\150\1\147\1\332\6\147\1\276\2\147"+
    "\1\276\3\0\1\333\44\0\1\333\2\0\1\333\10\0"+
    "\2\54\1\163\1\56\2\0\1\56\3\54\1\334\13\54"+
    "\11\0\1\54\14\0\2\54\1\163\1\303\2\0\1\56"+
    "\1\335\16\54\11\0\1\54\14\0\2\54\1\163\1\56"+
    "\2\0\1\56\10\54\1\336\6\54\11\0\1\54\14\0"+
    "\2\54\1\163\1\56\2\0\1\56\3\54\1\337\13\54"+
    "\11\0\1\54\7\0\1\333\4\0\2\177\5\0\17\177"+
    "\5\0\1\250\3\0\1\177\1\333\2\0\1\333\10\0"+
    "\2\315\5\0\17\315\11\0\1\315\4\0\2\257\1\225"+
    "\1\257\1\114\1\316\32\257\1\225\13\257\3\0\1\340"+
    "\44\0\1\340\2\0\1\340\3\0\1\341\44\0\1\341"+
    "\2\0\1\341\2\262\1\225\1\262\1\124\1\321\44\262"+
    "\1\225\1\262\13\0\1\322\3\0\1\342\63\0\1\343"+
    "\46\0\1\344\32\0\1\143\1\144\1\331\32\0\1\147"+
    "\1\150\1\0\1\227\6\0\1\331\2\0\1\331\1\332"+
    "\2\227\33\332\1\345\2\332\1\231\12\332\3\0\1\333"+
    "\3\0\1\346\1\0\1\346\5\0\17\346\6\0\1\346"+
    "\3\0\1\333\2\0\1\333\10\0\2\54\1\163\1\56"+
    "\2\0\1\56\12\54\1\347\4\54\11\0\1\54\14\0"+
    "\2\54\1\163\1\56\2\0\1\56\1\54\1\350\15\54"+
    "\11\0\1\54\7\0\1\340\3\0\1\351\1\0\1\351"+
    "\5\0\17\351\6\0\1\351\3\0\1\340\2\0\1\340"+
    "\3\0\1\341\3\0\1\352\1\0\1\352\5\0\17\352"+
    "\6\0\1\352\3\0\1\341\2\0\1\341\31\0\1\353"+
    "\42\0\1\354\33\0\1\332\1\355\1\356\1\357\32\332"+
    "\1\345\1\150\1\332\1\231\6\332\1\357\2\332\1\357"+
    "\10\0\2\346\5\0\17\346\11\0\1\346\14\0\2\351"+
    "\5\0\17\351\11\0\1\351\14\0\2\352\5\0\17\352"+
    "\11\0\1\352\4\0\2\227\1\356\36\227\1\360\53\227"+
    "\1\360\12\227\1\332\1\355\1\356\1\357\32\332\1\345"+
    "\1\150\1\332\1\345\6\332\1\357\2\332\1\357\1\227"+
    "\1\355\1\356\1\361\32\227\1\332\1\150\1\227\1\275"+
    "\6\227\1\361\2\227\1\361\1\227\1\355\1\356\1\361"+
    "\32\227\1\332\1\150\1\227\1\360\6\227\1\361\2\227"+
    "\1\361";

  private static int [] zzUnpackTrans() {
    int [] result = new int[7436];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\24\0\1\11\6\1\2\11\7\1\1\11\1\1\2\11"+
    "\1\1\2\11\2\1\1\11\12\1\1\11\2\1\2\11"+
    "\3\1\1\11\2\1\1\11\1\1\3\11\2\1\1\11"+
    "\5\1\1\11\10\1\3\11\5\1\7\0\1\11\1\0"+
    "\10\11\1\1\2\0\10\1\6\0\1\11\3\0\2\1"+
    "\4\0\1\1\13\0\1\1\2\0\4\1\1\11\3\1"+
    "\1\11\2\1\1\11\2\0\1\1\2\0\2\1\2\0"+
    "\1\1\2\0\1\11\1\1\1\0\1\11\1\1\2\0"+
    "\1\1\2\0\1\1\1\0\2\1\1\11\7\1\1\0"+
    "\3\1\2\0\1\1\1\11\1\1\4\0\1\11\3\0"+
    "\4\1\6\0\5\1\2\11\5\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[241];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;
  
  /** 
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /* user code: */
  StringBuffer string = new StringBuffer();
  String endOfMultiLineSymbol;
  Boolean isMultiLineFirstNewLine = true;
  Boolean isMultilineModified = false;
  Boolean stringAttributeName = false;
  int curleyBraceCounter = 0;
  int interpolatedCurleyBraceCounter = 0;
  Symbol currentValue;
  String currentMapKey;
  public ArrayList<Symbol> elementStack = new ArrayList<Symbol>();
  ArrayList<String> blockNames = null;
  Boolean inMap = false;
  Boolean fromMapKey = false;
  HCLAttribute attribute;
  SubTypePrimitiveType subTypePrimitiveType;
  Integer primitiveDepth = 0;

  Symbol currentBlock = null;
  private Symbol hclBlock(List<String> blockNames) {
    //System.out.println("Starting Block");
    HCLBlock block = new HCLBlock(blockNames,currentBlock,yyline,yycolumn-1,yychar-1);
    if(currentBlock == null) {
      elementStack.add(block);
    } else {
      currentBlock.appendChild(block);
    }
    currentBlock = block;
  return currentBlock;
  }

  private Symbol exitBlock() {
    //System.out.println("Leaving Block");
    Symbol result = null;
    if(currentBlock != null) {
      if(currentBlock.getParent() == null) {
        result = currentBlock;
      }
      currentBlock =  currentBlock.getParent();
    }
    return result;
  }

  private void startAttribute(String name) {
        //System.out.println("Starting Attribute");

    HCLAttribute currentAttribute = new HCLAttribute(name,yyline,yycolumn,yychar);
    if(currentBlock == null) {
      elementStack.add(currentAttribute);
    } else {
      currentBlock.appendChild(currentAttribute);
    }
    currentBlock = currentAttribute;
    attribute = currentAttribute;
  }

  private void startMap() {
    HCLMap currentAttribute = new HCLMap(yyline,yycolumn,yychar);
        if(currentBlock == null) {
          elementStack.add(currentAttribute);
        } else {
          currentBlock.appendChild(currentAttribute);
        }
        currentBlock = currentAttribute;
  }

  private void startArray() {
        HCLArray currentAttribute = new HCLArray(yyline,yycolumn,yychar);
            if(currentBlock == null) {
              elementStack.add(currentAttribute);
            } else {
              currentBlock.appendChild(currentAttribute);
            }
            currentBlock = currentAttribute;
            yybegin(HCLARRAY);
  }


  private Symbol exitAttribute(Boolean force) {

    if(currentBlock == null) {
      yybegin(YYINITIAL);
      Symbol result = attribute;
      attribute = null;
      exitBlock();
      return result;
    } else {
      attribute = null;
    if((!(currentBlock instanceof HCLArray) && !(currentBlock instanceof HCLMap)) || force == true) {
      exitBlock();
    }
      if(currentBlock instanceof HCLBlock) {
        yybegin(HCLINBLOCK);
      } else if(currentBlock instanceof HCLArray) {
        yybegin(HCLARRAY);
      } else if(currentBlock instanceof HCLMap) {
        yybegin(HCLMAP);
      } else if(currentBlock instanceof HCLAttribute) {
      exitAttribute();
      } else {
        yybegin(YYINITIAL);
      }
      return null;
    }
  }

  private Symbol exitAttribute() {
    return exitAttribute(false);
  }

     private void startEvalExpression() {
        yypushback(yylength());
      yybegin(EVALUATEDEXPRESSION);
     }





  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  HCLLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 2170) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException("Reader returned 0 characters. See JFlex examples for workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      /* If numRead == requested, we might have requested to few chars to
         encode a full Unicode character. We assume that a Reader would
         otherwise never return half characters. */
      if (numRead == requested) {
        if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Symbol yylex() throws java.io.IOException, HCLParserException
 {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn += zzCharCount;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { /* ignore */
            }
          case 65: break;
          case 2: 
            { string.append( yytext() );
            }
          case 66: break;
          case 3: 
            { throw new HCLParserException("Illegal character <("+
                                                        yytext()+ ") - state: " + yystate()+"> found on line: " + (yyline+1) + " col: " + (yycolumn+1) );
            }
          case 67: break;
          case 4: 
            { if(blockNames != null) { blockNames.add(string.toString());  yybegin(HCLBLOCKATTRIBUTES); } else if(currentBlock != null && currentBlock instanceof HCLMap && currentMapKey == null) { currentMapKey = string.toString() ; yybegin(HCLMAPKEYDEF); } else if (stringAttributeName) { stringAttributeName = false ; yybegin(HCLATTRIBUTE); startAttribute(string.toString());} else if(currentBlock != null) { currentBlock.appendChild(new HCLValue("string",string.toString(),yyline,yycolumn,yychar));  exitAttribute(); } else { throw new HCLParserException("String block found outside of block or attribute assignment."); }
            }
          case 68: break;
          case 5: 
            { string.append('\\');
            }
          case 69: break;
          case 6: 
            { exitAttribute();
            }
          case 70: break;
          case 7: 
            { yybegin(HCLBLOCKATTRIBUTES);blockNames = new ArrayList<String>(); blockNames.add(yytext());
            }
          case 71: break;
          case 8: 
            { yybegin(STRINGDOUBLE); string.setLength(0);
            }
          case 72: break;
          case 9: 
            { curleyBraceCounter++ ; hclBlock(blockNames) ; blockNames = null ; yybegin(HCLINBLOCK);
            }
          case 73: break;
          case 10: 
            { startAttribute(yytext());
            }
          case 74: break;
          case 11: 
            { yybegin(STRINGDOUBLE); stringAttributeName = true ;string.setLength(0);
            }
          case 75: break;
          case 12: 
            { yybegin(HCLATTRIBUTEVALUE);
            }
          case 76: break;
          case 13: 
            { startEvalExpression();
            }
          case 77: break;
          case 14: 
            { currentBlock.appendChild(new HCLValue("number",yytext(),yyline,yycolumn,yychar)) ; exitAttribute();
            }
          case 78: break;
          case 15: 
            { startArray();/* process an array */
            }
          case 79: break;
          case 16: 
            { blockNames = new ArrayList<String>(); blockNames.add(currentBlock.getName()); curleyBraceCounter++ ; hclBlock(blockNames) ; blockNames = null ; attribute = null ; yybegin(HCLINBLOCK);
            }
          case 80: break;
          case 17: 
            { yypushback(yylength()); yybegin(HCLATTRIBUTEVALUE);
            }
          case 81: break;
          case 18: 
            { /* should probably process this but due to simplicity we dont need to */
            }
          case 82: break;
          case 19: 
            { exitAttribute(true);
            }
          case 83: break;
          case 20: 
            { currentMapKey = yytext() ; yybegin(HCLMAPKEYDEF);
            }
          case 84: break;
          case 21: 
            { yybegin(STRINGDOUBLE); string.setLength(0); fromMapKey = true;
            }
          case 85: break;
          case 22: 
            { yybegin(HCLMAPKEY); yypushback(yylength());
            }
          case 86: break;
          case 23: 
            { startAttribute(currentMapKey); currentMapKey = null ; yybegin(HCLATTRIBUTEVALUE);
            }
          case 87: break;
          case 24: 
            { string.append(yytext());
            }
          case 88: break;
          case 25: 
            { string.append(yytext()); interpolatedCurleyBraceCounter++;
            }
          case 89: break;
          case 26: 
            { string.append(yytext()); if(interpolatedCurleyBraceCounter > 1) {interpolatedCurleyBraceCounter--;} else { interpolatedCurleyBraceCounter--; yybegin(STRINGDOUBLE);}
            }
          case 90: break;
          case 27: 
            { if(yytext().trim().equals(endOfMultiLineSymbol)) { endOfMultiLineSymbol = null; if(blockNames != null) { blockNames.add(string.toString());  yybegin(HCLBLOCKATTRIBUTES); } else if(attribute != null) { attribute.appendChild(new HCLValue("string",string.toString(),yyline,yycolumn,yychar)) ; exitAttribute(); } else { throw new HCLParserException("String block found outside of block or attribute assignment."); }} else {string.append( isMultilineModified ? yytext().trim() : yytext() );}
            }
          case 91: break;
          case 28: 
            { if(isMultiLineFirstNewLine) {isMultiLineFirstNewLine = false; } else {string.append( yytext() );}
            }
          case 92: break;
          case 29: 
            { currentBlock.appendChild(new Variable(yytext(),yyline,yycolumn,yychar)); exitAttribute();
            }
          case 93: break;
          case 30: 
            { yypushback(yylength()); exitAttribute(true);
            }
          case 94: break;
          case 31: 
            { subTypePrimitiveType = null; exitAttribute();
            }
          case 95: break;
          case 32: 
            { primitiveDepth++ ;
            }
          case 96: break;
          case 33: 
            { primitiveDepth--; if(primitiveDepth == 0) {subTypePrimitiveType = null; exitAttribute();}
            }
          case 97: break;
          case 34: 
            { yybegin(HCLATTRIBUTE);yypushback(yylength());
            }
          case 98: break;
          case 35: 
            { string.append( "$" ); yypushback(yylength()-1);
            }
          case 99: break;
          case 36: 
            { string.append('$');yypushback(yylength()-1); yybegin(STRINGINTERPOLATED);
            }
          case 100: break;
          case 37: 
            { string.append('\t');
            }
          case 101: break;
          case 38: 
            { string.append('\r');
            }
          case 102: break;
          case 39: 
            { string.append('\n');
            }
          case 103: break;
          case 40: 
            { string.append('\"');
            }
          case 104: break;
          case 41: 
            { string.append('\'');
            }
          case 105: break;
          case 42: 
            { yypushback(yylength()); yybegin(HCLMAPKEY);
            }
          case 106: break;
          case 43: 
            { yybegin(HCLBLOCKHEADER);yypushback(yylength());
            }
          case 107: break;
          case 44: 
            { subTypePrimitiveType = new SetPrimitiveType(null,yyline,yycolumn,yychar); currentBlock.appendChild(subTypePrimitiveType); yybegin(SUBTYPEPRIMITIVETYPE);
            }
          case 108: break;
          case 45: 
            { subTypePrimitiveType = new MapPrimitiveType(null,yyline,yycolumn,yychar); currentBlock.appendChild(subTypePrimitiveType); yybegin(SUBTYPEPRIMITIVETYPE);
            }
          case 109: break;
          case 46: 
            { startMap(); yypushback(yylength()-1) ; yybegin(HCLMAP);
            }
          case 110: break;
          case 47: 
            { yybegin(MULTILINESTRING) ; isMultiLineFirstNewLine = true ;isMultilineModified = true; string.setLength(0) ; endOfMultiLineSymbol = yytext().substring(2).trim();
            }
          case 111: break;
          case 48: 
            { SetPrimitiveType tmpPrimitive = new SetPrimitiveType(null,yyline,yycolumn,yychar); subTypePrimitiveType.subType = tmpPrimitive; subTypePrimitiveType = tmpPrimitive;
            }
          case 112: break;
          case 49: 
            { MapPrimitiveType tmpPrimitive = new MapPrimitiveType(null,yyline,yycolumn,yychar); subTypePrimitiveType.subType = tmpPrimitive; subTypePrimitiveType = tmpPrimitive;
            }
          case 113: break;
          case 50: 
            { currentBlock.appendChild(new HCLValue("boolean","true",yyline,yycolumn,yychar)) ; exitAttribute();
            }
          case 114: break;
          case 51: 
            { subTypePrimitiveType = new ListPrimitiveType(null,yyline,yycolumn,yychar); currentBlock.appendChild(subTypePrimitiveType); yybegin(SUBTYPEPRIMITIVETYPE);
            }
          case 115: break;
          case 52: 
            { currentBlock.appendChild(new HCLValue("null",null,yyline,yycolumn,yychar)) ; exitAttribute();
            }
          case 116: break;
          case 53: 
            { currentBlock.appendChild(new BooleanPrimitiveType(yyline,yycolumn,yychar)); exitAttribute();
            }
          case 117: break;
          case 54: 
            { yybegin(MULTILINESTRING) ; isMultiLineFirstNewLine = true ;isMultilineModified = true; string.setLength(0) ; endOfMultiLineSymbol = yytext().substring(3);
            }
          case 118: break;
          case 55: 
            { ListPrimitiveType tmpPrimitive = new ListPrimitiveType(null,yyline,yycolumn,yychar); subTypePrimitiveType.subType = tmpPrimitive; subTypePrimitiveType = tmpPrimitive;
            }
          case 119: break;
          case 56: 
            { subTypePrimitiveType.subType = new BooleanPrimitiveType(yyline,yycolumn,yychar); subTypePrimitiveType = null;
            }
          case 120: break;
          case 57: 
            { currentBlock.appendChild(new HCLValue("boolean","false",yyline,yycolumn,yychar)) ; exitAttribute();
            }
          case 121: break;
          case 58: 
            { yybegin(FORLOOPEXPRESSION); yypushback(yylength());
            }
          case 122: break;
          case 59: 
            { currentBlock.appendChild(new StringPrimitiveType(yyline,yycolumn,yychar)); exitAttribute();
            }
          case 123: break;
          case 60: 
            { currentBlock.appendChild(new NumberPrimitiveType(yyline,yycolumn,yychar)); exitAttribute();
            }
          case 124: break;
          case 61: 
            { yybegin(FORTUPLEEXPRESSION); yypushback(yylength()-1);
            }
          case 125: break;
          case 62: 
            { yybegin(FOROBJECTEXPRESSION); yypushback(yylength()-1);
            }
          case 126: break;
          case 63: 
            { subTypePrimitiveType.subType = new StringPrimitiveType(yyline,yycolumn,yychar); subTypePrimitiveType = null;
            }
          case 127: break;
          case 64: 
            { subTypePrimitiveType.subType = new NumberPrimitiveType(yyline,yycolumn,yychar); subTypePrimitiveType = null;
            }
          case 128: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
