/*
 * Decompiled with CFR 0.152.
 */
package com.bertramlabs.plugins.hcl4j;

import com.bertramlabs.plugins.hcl4j.HCLLexer;
import com.bertramlabs.plugins.hcl4j.HCLParserException;
import com.bertramlabs.plugins.hcl4j.RuntimeSymbols.EvalSymbol;
import com.bertramlabs.plugins.hcl4j.RuntimeSymbols.PrimitiveType;
import com.bertramlabs.plugins.hcl4j.RuntimeSymbols.Variable;
import com.bertramlabs.plugins.hcl4j.symbols.HCLArray;
import com.bertramlabs.plugins.hcl4j.symbols.HCLAttribute;
import com.bertramlabs.plugins.hcl4j.symbols.HCLBlock;
import com.bertramlabs.plugins.hcl4j.symbols.HCLMap;
import com.bertramlabs.plugins.hcl4j.symbols.HCLValue;
import com.bertramlabs.plugins.hcl4j.symbols.Symbol;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HCLParser {
    public Map<String, Object> parse(String input) throws HCLParserException, IOException {
        return this.parse(input, (Boolean)false);
    }

    public Map<String, Object> parse(String input, Boolean ignoreParserExceptions) throws HCLParserException, IOException {
        StringReader reader = new StringReader(input);
        return this.parse(reader, ignoreParserExceptions);
    }

    public Map<String, Object> parse(File input, Boolean ignoreParserExceptions) throws HCLParserException, IOException, UnsupportedEncodingException {
        return this.parse(input, "UTF-8", ignoreParserExceptions);
    }

    public Map<String, Object> parse(File input) throws HCLParserException, IOException, UnsupportedEncodingException {
        return this.parse(input, "UTF-8", (Boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> parse(File input, Charset cs) throws HCLParserException, IOException {
        try (FileInputStream is = null;){
            is = new FileInputStream(input);
            Map<String, Object> map = this.parse((InputStream)is, cs);
            return map;
        }
    }

    public Map<String, Object> parse(File input, String charsetName) throws HCLParserException, IOException {
        return this.parse(input, charsetName, (Boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> parse(File input, String charsetName, Boolean ignoreParserExceptions) throws HCLParserException, IOException {
        try (FileInputStream is = null;){
            is = new FileInputStream(input);
            Map<String, Object> map = this.parse(is, charsetName, ignoreParserExceptions);
            return map;
        }
    }

    public Map<String, Object> parse(InputStream input) throws HCLParserException, IOException {
        return this.parse(input, "UTF-8");
    }

    public Map<String, Object> parse(InputStream input, Charset cs) throws HCLParserException, IOException {
        InputStreamReader reader = cs != null ? new InputStreamReader(input, cs) : new InputStreamReader(input, "UTF-8");
        return this.parse(reader);
    }

    public Map<String, Object> parse(InputStream input, String charsetName) throws HCLParserException, IOException, UnsupportedEncodingException {
        return this.parse(input, charsetName, (Boolean)false);
    }

    public Map<String, Object> parse(InputStream input, String charsetName, Boolean ignoreParserExceptions) throws HCLParserException, IOException, UnsupportedEncodingException {
        InputStreamReader reader = charsetName != null ? new InputStreamReader(input, charsetName) : new InputStreamReader(input, "UTF-8");
        return this.parse(reader, ignoreParserExceptions);
    }

    public Map<String, Object> parse(Reader reader) throws HCLParserException, IOException {
        return this.parse(reader, (Boolean)false);
    }

    public Map<String, Object> parse(Reader reader, Boolean ignoreParserExceptions) throws HCLParserException, IOException {
        LinkedHashMap<String, Object> result;
        HCLLexer lexer = new HCLLexer(reader);
        if (ignoreParserExceptions.booleanValue()) {
            try {
                lexer.yylex();
            }
            catch (Exception exception) {}
        } else {
            lexer.yylex();
        }
        ArrayList<Symbol> rootBlocks = lexer.elementStack;
        LinkedHashMap<String, Object> mapPosition = result = new LinkedHashMap<String, Object>();
        for (Symbol currentElement : rootBlocks) {
            this.processSymbol(currentElement, mapPosition);
        }
        return result;
    }

    private Object processSymbol(Symbol symbol, Map<String, Object> mapPosition) throws HCLParserException {
        if (symbol instanceof HCLBlock) {
            HCLBlock block = (HCLBlock)symbol;
            for (int counter = 0; counter < block.blockNames.size(); ++counter) {
                String blockName = block.blockNames.get(counter);
                if (mapPosition.containsKey(blockName)) {
                    if (counter == block.blockNames.size() - 1 && mapPosition.get(blockName) instanceof Map) {
                        ArrayList<Map> objectList = new ArrayList<Map>();
                        LinkedHashMap addedObject = new LinkedHashMap();
                        objectList.add((Map)mapPosition.get(blockName));
                        objectList.add(addedObject);
                        mapPosition.put(blockName, (LinkedHashMap<String, Object>)((Object)objectList));
                        mapPosition = addedObject;
                        continue;
                    }
                    if (mapPosition.get(blockName) instanceof Map) {
                        mapPosition = (Map)mapPosition.get(blockName);
                        continue;
                    }
                    if (counter == block.blockNames.size() - 1 && mapPosition.get(blockName) instanceof List) {
                        LinkedHashMap<String, LinkedHashMap<String, Object>> addedObject = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
                        ((List)mapPosition.get(blockName)).add(addedObject);
                        mapPosition = addedObject;
                        continue;
                    }
                    if (mapPosition.get(blockName) instanceof List) {
                        throw new HCLParserException("HCL Block expression scope traverses an object array");
                    }
                    throw new HCLParserException("HCL Block expression scope traverses an object value");
                }
                mapPosition.put(blockName, new LinkedHashMap());
                mapPosition = (LinkedHashMap<String, LinkedHashMap<String, Object>>)mapPosition.get(blockName);
            }
            if (symbol.getChildren() != null) {
                for (Symbol child : block.getChildren()) {
                    this.processSymbol(child, mapPosition);
                }
            }
            return mapPosition;
        }
        if (symbol instanceof HCLMap) {
            LinkedHashMap<String, Object> nestedMap = new LinkedHashMap<String, Object>();
            if (symbol.getChildren() != null) {
                for (Symbol child : symbol.getChildren()) {
                    this.processSymbol(child, nestedMap);
                }
            }
            return nestedMap;
        }
        if (symbol instanceof HCLArray) {
            if (symbol.getChildren() != null) {
                ArrayList<Object> objectList = new ArrayList<Object>();
                for (Symbol child : symbol.getChildren()) {
                    LinkedHashMap<String, Object> nestedMap = new LinkedHashMap<String, Object>();
                    Object result = this.processSymbol(child, nestedMap);
                    objectList.add(result);
                }
                return objectList;
            }
            return null;
        }
        if (symbol instanceof HCLValue) {
            return this.processValue((HCLValue)symbol);
        }
        if (symbol instanceof PrimitiveType) {
            return symbol;
        }
        if (symbol instanceof EvalSymbol) {
            return this.processEvaluation((EvalSymbol)symbol);
        }
        if (symbol instanceof HCLAttribute) {
            LinkedHashMap<String, Object> nestedMap = new LinkedHashMap<String, Object>();
            if (symbol.getChildren().size() > 0) {
                Object results = this.processSymbol(symbol.getChildren().get(0), nestedMap);
                mapPosition.put(symbol.getName(), (LinkedHashMap<String, Object>)results);
            } else {
                mapPosition.put(symbol.getName(), null);
            }
            return mapPosition;
        }
        return null;
    }

    protected Object processValue(HCLValue value) throws HCLParserException {
        if (value.type.equals("string")) {
            return value.value;
        }
        if (value.type.equals("boolean")) {
            if (value.value.equals("true")) {
                return new Boolean(true);
            }
            return new Boolean(false);
        }
        if (value.type.equals("null")) {
            return null;
        }
        if (value.type.equals("number")) {
            try {
                Double numericalValue = Double.parseDouble((String)value.value);
                return numericalValue;
            }
            catch (NumberFormatException ex) {
                throw new HCLParserException("Error Parsing Numerical Value in HCL Attribute ", ex);
            }
        }
        throw new HCLParserException("HCL Attribute value not recognized by parser (not implemented yet).");
    }

    protected Object processEvaluation(EvalSymbol evalSymbol) {
        if (evalSymbol instanceof Variable) {
            return evalSymbol;
        }
        return null;
    }
}

