/* The following code was generated by JFlex 1.6.1 */

/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.bertramlabs.plugins.hcl4j;
import com.bertramlabs.plugins.hcl4j.symbols.*;
import com.bertramlabs.plugins.hcl4j.RuntimeSymbols.*;
import java.util.ArrayList;
import java.util.List;
import java.io.*;

/**
 * This class is a HCL lexer Generated from jflex.
 * @author David Estes
 */


class HCLLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int STRINGDOUBLE = 2;
  public static final int STRINGSINGLE = 4;
  public static final int HCLINBLOCK = 6;
  public static final int HCLBLOCKHEADER = 8;
  public static final int HCLBLOCKATTRIBUTES = 10;
  public static final int HCLATTRIBUTE = 12;
  public static final int HCLATTRIBUTEVALUE = 14;
  public static final int HCLARRAY = 16;
  public static final int HCLMAP = 18;
  public static final int HCLMAPKEY = 20;
  public static final int HCLMAPKEYDEF = 22;
  public static final int HCLMAPVALUE = 24;
  public static final int STRINGINTERPOLATED = 26;
  public static final int MULTILINESTRING = 28;
  public static final int EVALUATEDEXPRESSION = 30;
  public static final int FORLOOPEXPRESSION = 32;
  public static final int FORTUPLEEXPRESSION = 34;
  public static final int FOROBJVARIABLES = 36;
  public static final int FOROBJECTEXPRESSION = 38;
  public static final int FORTUPLEVARIABLES = 40;
  public static final int FORTUPLESOURCE = 42;
  public static final int FOROBJSOURCE = 44;
  public static final int FUNCTIONCALL = 46;
  public static final int SUBTYPEPRIMITIVETYPE = 48;
  public static final int VARIABLETREE = 50;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 
    16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23, 
    24, 24, 25, 25
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\63\1\2\1\0\1\3\1\1\22\0\1\54\1\60\1\43"+
    "\1\6\1\50\1\61\1\56\1\46\1\20\1\13\1\5\1\61\1\21"+
    "\1\53\1\15\1\4\12\10\1\16\1\0\1\51\1\47\1\57\1\61"+
    "\1\0\32\11\1\12\1\62\1\14\1\0\1\11\1\0\1\27\1\36"+
    "\1\42\1\11\1\25\1\26\1\34\1\11\1\33\1\17\1\11\1\30"+
    "\1\35\1\32\1\37\1\41\1\11\1\23\1\31\1\22\1\24\3\11"+
    "\1\40\1\11\1\44\1\55\1\45\1\52\43\0\4\7\4\0\1\7"+
    "\12\0\1\7\4\0\1\7\5\0\27\7\1\0\37\7\1\0\u01ca\7"+
    "\4\0\14\7\16\0\5\7\7\0\1\7\1\0\1\7\201\0\5\7"+
    "\1\0\2\7\2\0\4\7\1\0\1\7\6\0\1\7\1\0\3\7"+
    "\1\0\1\7\1\0\24\7\1\0\123\7\1\0\213\7\10\0\246\7"+
    "\1\0\46\7\2\0\1\7\7\0\47\7\7\0\1\7\100\0\33\7"+
    "\5\0\3\7\30\0\1\7\24\0\53\7\43\0\2\7\1\0\143\7"+
    "\1\0\1\7\17\0\2\7\7\0\2\7\12\0\3\7\2\0\1\7"+
    "\20\0\1\7\1\0\36\7\35\0\131\7\13\0\1\7\30\0\41\7"+
    "\11\0\2\7\4\0\1\7\5\0\26\7\4\0\1\7\11\0\1\7"+
    "\3\0\1\7\27\0\31\7\7\0\13\7\65\0\25\7\1\0\10\7"+
    "\106\0\66\7\3\0\1\7\22\0\1\7\7\0\12\7\17\0\20\7"+
    "\4\0\10\7\2\0\2\7\2\0\26\7\1\0\7\7\1\0\1\7"+
    "\3\0\4\7\3\0\1\7\20\0\1\7\15\0\2\7\1\0\3\7"+
    "\16\0\4\7\7\0\2\7\10\0\6\7\4\0\2\7\2\0\26\7"+
    "\1\0\7\7\1\0\2\7\1\0\2\7\1\0\2\7\37\0\4\7"+
    "\1\0\1\7\23\0\3\7\20\0\11\7\1\0\3\7\1\0\26\7"+
    "\1\0\7\7\1\0\2\7\1\0\5\7\3\0\1\7\22\0\1\7"+
    "\17\0\2\7\17\0\1\7\7\0\1\7\13\0\10\7\2\0\2\7"+
    "\2\0\26\7\1\0\7\7\1\0\2\7\1\0\5\7\3\0\1\7"+
    "\36\0\2\7\1\0\3\7\17\0\1\7\21\0\1\7\1\0\6\7"+
    "\3\0\3\7\1\0\4\7\3\0\2\7\1\0\1\7\1\0\2\7"+
    "\3\0\2\7\3\0\3\7\3\0\14\7\26\0\1\7\50\0\1\7"+
    "\13\0\10\7\1\0\3\7\1\0\27\7\1\0\20\7\3\0\1\7"+
    "\32\0\3\7\5\0\2\7\36\0\1\7\4\0\10\7\1\0\3\7"+
    "\1\0\27\7\1\0\12\7\1\0\5\7\3\0\1\7\40\0\1\7"+
    "\1\0\2\7\17\0\2\7\22\0\10\7\1\0\3\7\1\0\51\7"+
    "\2\0\1\7\20\0\1\7\5\0\3\7\10\0\3\7\30\0\6\7"+
    "\5\0\22\7\3\0\30\7\1\0\11\7\1\0\1\7\2\0\7\7"+
    "\72\0\60\7\1\0\2\7\13\0\10\7\72\0\2\7\1\0\1\7"+
    "\2\0\2\7\1\0\1\7\2\0\1\7\6\0\4\7\1\0\7\7"+
    "\1\0\3\7\1\0\1\7\1\0\1\7\2\0\2\7\1\0\4\7"+
    "\1\0\2\7\11\0\1\7\2\0\5\7\1\0\1\7\25\0\4\7"+
    "\40\0\1\7\77\0\10\7\1\0\44\7\33\0\5\7\163\0\53\7"+
    "\24\0\1\7\20\0\6\7\4\0\4\7\3\0\1\7\3\0\2\7"+
    "\7\0\3\7\4\0\15\7\14\0\1\7\21\0\46\7\1\0\1\7"+
    "\5\0\1\7\2\0\53\7\1\0\u014d\7\1\0\4\7\2\0\7\7"+
    "\1\0\1\7\1\0\4\7\2\0\51\7\1\0\4\7\2\0\41\7"+
    "\1\0\4\7\2\0\7\7\1\0\1\7\1\0\4\7\2\0\17\7"+
    "\1\0\71\7\1\0\4\7\2\0\103\7\45\0\20\7\20\0\126\7"+
    "\2\0\6\7\3\0\u026c\7\2\0\21\7\1\0\32\7\5\0\113\7"+
    "\3\0\13\7\7\0\15\7\1\0\4\7\16\0\22\7\16\0\22\7"+
    "\16\0\15\7\1\0\3\7\17\0\64\7\43\0\1\7\3\0\2\7"+
    "\103\0\130\7\10\0\5\7\2\0\42\7\1\0\1\7\5\0\106\7"+
    "\12\0\37\7\61\0\36\7\2\0\5\7\13\0\54\7\4\0\32\7"+
    "\66\0\27\7\11\0\65\7\122\0\1\7\135\0\57\7\21\0\7\7"+
    "\67\0\36\7\15\0\2\7\12\0\54\7\32\0\44\7\51\0\3\7"+
    "\12\0\44\7\2\0\11\7\140\0\4\7\1\0\4\7\3\0\2\7"+
    "\11\0\300\7\100\0\u0116\7\2\0\6\7\2\0\46\7\2\0\6\7"+
    "\2\0\10\7\1\0\1\7\1\0\1\7\1\0\1\7\1\0\37\7"+
    "\2\0\65\7\1\0\7\7\1\0\1\7\3\0\3\7\1\0\7\7"+
    "\3\0\4\7\2\0\6\7\4\0\15\7\5\0\3\7\1\0\7\7"+
    "\102\0\2\7\23\0\1\7\34\0\1\7\15\0\1\7\20\0\15\7"+
    "\3\0\40\7\102\0\1\7\4\0\1\7\2\0\12\7\1\0\1\7"+
    "\3\0\5\7\6\0\1\7\1\0\1\7\1\0\1\7\1\0\4\7"+
    "\1\0\13\7\2\0\4\7\5\0\5\7\4\0\1\7\21\0\51\7"+
    "\u0a77\0\57\7\1\0\57\7\1\0\205\7\6\0\4\7\3\0\2\7"+
    "\14\0\46\7\1\0\1\7\5\0\1\7\2\0\70\7\7\0\1\7"+
    "\20\0\27\7\11\0\7\7\1\0\7\7\1\0\7\7\1\0\7\7"+
    "\1\0\7\7\1\0\7\7\1\0\7\7\1\0\7\7\120\0\1\7"+
    "\u01d5\0\3\7\31\0\11\7\7\0\5\7\2\0\5\7\4\0\126\7"+
    "\6\0\3\7\1\0\132\7\1\0\4\7\5\0\52\7\2\0\136\7"+
    "\21\0\33\7\65\0\20\7\u0200\0\u19b6\7\112\0\u51eb\7\25\0\u048d\7"+
    "\103\0\56\7\2\0\u010d\7\3\0\20\7\12\0\2\7\24\0\57\7"+
    "\20\0\37\7\2\0\120\7\47\0\11\7\2\0\147\7\2\0\44\7"+
    "\1\0\10\7\77\0\13\7\1\0\3\7\1\0\4\7\1\0\27\7"+
    "\25\0\1\7\7\0\64\7\16\0\62\7\76\0\6\7\3\0\1\7"+
    "\1\0\1\7\14\0\34\7\12\0\27\7\31\0\35\7\7\0\57\7"+
    "\34\0\1\7\20\0\5\7\1\0\12\7\12\0\5\7\1\0\51\7"+
    "\27\0\3\7\1\0\10\7\24\0\27\7\3\0\1\7\3\0\62\7"+
    "\1\0\1\7\3\0\2\7\2\0\5\7\2\0\1\7\1\0\1\7"+
    "\30\0\3\7\2\0\13\7\7\0\3\7\14\0\6\7\2\0\6\7"+
    "\2\0\6\7\11\0\7\7\1\0\7\7\1\0\53\7\1\0\12\7"+
    "\12\0\163\7\35\0\u2ba4\7\14\0\27\7\4\0\61\7\u2104\0\u016e\7"+
    "\2\0\152\7\46\0\7\7\14\0\5\7\5\0\1\7\1\0\12\7"+
    "\1\0\15\7\1\0\5\7\1\0\1\7\1\0\2\7\1\0\2\7"+
    "\1\0\154\7\41\0\u016b\7\22\0\100\7\2\0\66\7\50\0\15\7"+
    "\66\0\2\7\30\0\3\7\31\0\1\7\6\0\5\7\1\0\207\7"+
    "\7\0\1\7\34\0\32\7\4\0\1\7\1\0\32\7\13\0\131\7"+
    "\3\0\6\7\2\0\6\7\2\0\6\7\2\0\3\7\3\0\2\7"+
    "\3\0\2\7\31\0\14\7\1\0\32\7\1\0\23\7\1\0\2\7"+
    "\1\0\17\7\2\0\16\7\42\0\173\7\105\0\65\7\u010b\0\35\7"+
    "\3\0\61\7\57\0\40\7\15\0\36\7\5\0\46\7\12\0\36\7"+
    "\2\0\44\7\4\0\10\7\1\0\5\7\52\0\236\7\22\0\44\7"+
    "\4\0\44\7\4\0\50\7\10\0\64\7\234\0\u0137\7\11\0\26\7"+
    "\12\0\10\7\230\0\6\7\2\0\1\7\1\0\54\7\1\0\2\7"+
    "\3\0\1\7\2\0\27\7\12\0\27\7\11\0\37\7\101\0\23\7"+
    "\1\0\2\7\12\0\26\7\12\0\32\7\106\0\70\7\6\0\2\7"+
    "\100\0\1\7\17\0\4\7\1\0\3\7\1\0\33\7\54\0\35\7"+
    "\3\0\35\7\43\0\10\7\1\0\34\7\33\0\66\7\12\0\26\7"+
    "\12\0\23\7\15\0\22\7\156\0\111\7\67\0\63\7\15\0\63\7"+
    "\u0310\0\65\7\113\0\55\7\40\0\31\7\32\0\44\7\51\0\43\7"+
    "\3\0\1\7\14\0\60\7\16\0\4\7\25\0\1\7\1\0\1\7"+
    "\43\0\22\7\1\0\31\7\124\0\7\7\1\0\1\7\1\0\4\7"+
    "\1\0\17\7\1\0\12\7\7\0\57\7\46\0\10\7\2\0\2\7"+
    "\2\0\26\7\1\0\7\7\1\0\2\7\1\0\5\7\3\0\1\7"+
    "\22\0\1\7\14\0\5\7\236\0\65\7\22\0\4\7\65\0\60\7"+
    "\24\0\2\7\1\0\1\7\270\0\57\7\51\0\4\7\44\0\60\7"+
    "\24\0\1\7\73\0\53\7\125\0\32\7\u0186\0\100\7\37\0\1\7"+
    "\u0100\0\1\7\12\0\50\7\7\0\1\7\25\0\1\7\13\0\50\7"+
    "\2\0\4\7\66\0\71\7\u0107\0\11\7\1\0\45\7\21\0\1\7"+
    "\61\0\36\7\160\0\7\7\1\0\2\7\1\0\46\7\25\0\1\7"+
    "\u02b9\0\u039a\7\146\0\157\7\21\0\304\7\u0abc\0\u042f\7\u0fd1\0\u0247\7"+
    "\u21b9\0\u0239\7\7\0\37\7\161\0\36\7\22\0\60\7\20\0\4\7"+
    "\37\0\25\7\5\0\23\7\u0370\0\105\7\13\0\1\7\102\0\15\7"+
    "\100\0\2\7\36\0\u17ed\7\23\0\u02f3\7\u250d\0\u011f\7\121\0\u018c\7"+
    "\u0904\0\153\7\5\0\15\7\3\0\11\7\7\0\12\7\u1766\0\125\7"+
    "\1\0\107\7\1\0\2\7\2\0\1\7\2\0\2\7\2\0\4\7"+
    "\1\0\14\7\1\0\1\7\1\0\7\7\1\0\101\7\1\0\4\7"+
    "\2\0\10\7\1\0\7\7\1\0\34\7\1\0\4\7\1\0\5\7"+
    "\1\0\1\7\3\0\7\7\1\0\u0154\7\2\0\31\7\1\0\31\7"+
    "\1\0\37\7\1\0\31\7\1\0\37\7\1\0\31\7\1\0\37\7"+
    "\1\0\31\7\1\0\37\7\1\0\31\7\1\0\10\7\u1034\0\305\7"+
    "\73\0\104\7\u04bc\0\4\7\1\0\33\7\1\0\2\7\1\0\1\7"+
    "\2\0\1\7\1\0\12\7\1\0\4\7\1\0\1\7\1\0\1\7"+
    "\6\0\1\7\4\0\1\7\1\0\1\7\1\0\1\7\1\0\3\7"+
    "\1\0\2\7\1\0\1\7\2\0\1\7\1\0\1\7\1\0\1\7"+
    "\1\0\1\7\1\0\1\7\1\0\2\7\1\0\1\7\2\0\4\7"+
    "\1\0\7\7\1\0\4\7\1\0\4\7\1\0\1\7\1\0\12\7"+
    "\1\0\21\7\5\0\3\7\1\0\5\7\1\0\21\7\u1144\0\ua6d7\7"+
    "\51\0\u1035\7\13\0\336\7\2\0\u1682\7\16\0\u1d31\7\u0c1f\0\u021e\7"+
    "\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\u05f0\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\32\0\6\1\1\2\1\3\1\4\1\3\1\5\1\2"+
    "\1\6\1\5\3\3\1\7\1\10\1\11\1\12\1\13"+
    "\1\14\1\15\1\16\2\17\2\20\1\21\1\22\1\23"+
    "\1\24\1\25\1\20\14\21\1\26\1\27\1\30\1\3"+
    "\1\20\2\3\2\20\3\31\1\32\2\3\1\33\1\34"+
    "\1\35\1\36\1\3\1\2\1\37\1\40\1\41\1\42"+
    "\2\43\1\44\1\20\1\44\1\45\1\46\3\3\1\47"+
    "\1\50\1\47\4\1\1\16\1\1\2\51\1\52\1\16"+
    "\2\52\1\53\1\16\2\53\1\31\2\1\1\31\1\1"+
    "\1\24\1\54\2\46\1\24\1\55\1\56\1\57\1\3"+
    "\1\46\2\3\1\46\7\0\1\60\1\0\1\2\1\61"+
    "\1\62\1\63\1\64\1\65\1\66\1\67\1\21\4\0"+
    "\12\21\1\20\3\21\6\0\1\70\3\0\1\35\1\44"+
    "\2\0\1\44\4\0\1\71\1\16\1\1\1\16\1\52"+
    "\2\0\2\52\1\53\2\0\2\53\1\31\7\0\1\72"+
    "\3\0\3\21\1\73\2\21\2\74\2\21\2\75\2\21"+
    "\1\76\2\0\1\77\2\0\1\70\3\0\1\1\2\0"+
    "\2\31\3\0\1\1\3\0\1\60\1\0\1\21\1\100"+
    "\2\21\2\101\2\21\1\102\2\21\1\103\1\21\1\0"+
    "\1\76\1\104\1\44\2\0\1\1\1\52\1\53\1\31"+
    "\1\1\1\0\1\24\2\0\1\105\1\101\1\106\4\21"+
    "\1\107\1\110\1\0\1\21\1\111\1\112\1\75\3\0"+
    "\1\21\4\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[314];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\64\0\150\0\234\0\320\0\u0104\0\u0138\0\u016c"+
    "\0\u01a0\0\u01d4\0\u0208\0\u023c\0\u0270\0\u02a4\0\u02d8\0\u030c"+
    "\0\u0340\0\u0374\0\u03a8\0\u03dc\0\u0410\0\u0444\0\u0478\0\u04ac"+
    "\0\u04e0\0\u0514\0\u0548\0\u057c\0\u05b0\0\u05e4\0\u0618\0\u064c"+
    "\0\u0680\0\u0548\0\u0548\0\u06b4\0\u06e8\0\u071c\0\u0548\0\u0750"+
    "\0\u05b0\0\u0618\0\u064c\0\u0548\0\u0784\0\u07b8\0\u0548\0\u0548"+
    "\0\u07ec\0\u0548\0\u0548\0\u0820\0\u0548\0\u05b0\0\u0548\0\u0854"+
    "\0\u0888\0\u08bc\0\u0548\0\u0548\0\u08f0\0\u0924\0\u0548\0\u0958"+
    "\0\u098c\0\u09c0\0\u09f4\0\u0a28\0\u0a5c\0\u0a90\0\u0ac4\0\u0af8"+
    "\0\u0b2c\0\u0548\0\u0b60\0\u0548\0\u0b94\0\u0bc8\0\u0bfc\0\u0c30"+
    "\0\u0c64\0\u0b94\0\u0548\0\u05b0\0\u05e4\0\u0548\0\u0c98\0\u0ccc"+
    "\0\u0d00\0\u0548\0\u0d34\0\u0548\0\u0d68\0\u0d9c\0\u0548\0\u0548"+
    "\0\u0548\0\u0dd0\0\u0e04\0\u0548\0\u0e38\0\u0e6c\0\u0ea0\0\u0548"+
    "\0\u0548\0\u0ed4\0\u0f08\0\u0f3c\0\u0f70\0\u0548\0\u0fa4\0\u0fd8"+
    "\0\u100c\0\u1040\0\u1074\0\u0fd8\0\u10a8\0\u10dc\0\u1110\0\u1144"+
    "\0\u1178\0\u11ac\0\u0548\0\u11e0\0\u1214\0\u1248\0\u0548\0\u127c"+
    "\0\u12b0\0\u127c\0\u12e4\0\u1318\0\u134c\0\u0548\0\u1380\0\u13b4"+
    "\0\u13e8\0\u141c\0\u0548\0\u0548\0\u1450\0\u1484\0\u14b8\0\u14ec"+
    "\0\u1450\0\u1520\0\u1554\0\u1588\0\u15bc\0\u0618\0\u15f0\0\u1624"+
    "\0\u0548\0\u1658\0\u0548\0\u0548\0\u0548\0\u0548\0\u0548\0\u0548"+
    "\0\u0548\0\u0548\0\u168c\0\u08bc\0\u16c0\0\u08f0\0\u16f4\0\u16f4"+
    "\0\u1728\0\u175c\0\u1790\0\u17c4\0\u17f8\0\u182c\0\u1860\0\u1894"+
    "\0\u18c8\0\u0854\0\u18fc\0\u1930\0\u1964\0\u0b60\0\u1998\0\u19cc"+
    "\0\u1a00\0\u1a34\0\u0c98\0\u0548\0\u0ccc\0\u1a68\0\u0d68\0\u0d68"+
    "\0\u1a9c\0\u0e6c\0\u1ad0\0\u1b04\0\u0ed4\0\u1b38\0\u0f08\0\u1b6c"+
    "\0\u0548\0\u0f70\0\u1ba0\0\u10dc\0\u1bd4\0\u1178\0\u1c08\0\u1c08"+
    "\0\u1c3c\0\u1c70\0\u1214\0\u1ca4\0\u1ca4\0\u1cd8\0\u1d0c\0\u1d40"+
    "\0\u1d74\0\u1da8\0\u1ddc\0\u1e10\0\u1e44\0\u1e78\0\u1624\0\u1eac"+
    "\0\u1ee0\0\u1f14\0\u1f48\0\u1f7c\0\u1fb0\0\u0854\0\u1fe4\0\u2018"+
    "\0\u0548\0\u204c\0\u2080\0\u20b4\0\u0548\0\u20e8\0\u211c\0\u2150"+
    "\0\u0548\0\u2184\0\u21b8\0\u21ec\0\u2220\0\u2254\0\u0ccc\0\u2288"+
    "\0\u22bc\0\u22f0\0\u2324\0\u2358\0\u238c\0\u23c0\0\u23f4\0\u2428"+
    "\0\u245c\0\u2490\0\u1d74\0\u24c4\0\u24f8\0\u252c\0\u1658\0\u2560"+
    "\0\u1f14\0\u0924\0\u2594\0\u25c8\0\u0548\0\u25fc\0\u2630\0\u204c"+
    "\0\u0854\0\u2664\0\u20e8\0\u0854\0\u2698\0\u26cc\0\u1a00\0\u2700"+
    "\0\u2288\0\u2734\0\u2768\0\u279c\0\u2358\0\u238c\0\u27d0\0\u23c0"+
    "\0\u2804\0\u2428\0\u2838\0\u286c\0\u2560\0\u28a0\0\u0854\0\u25fc"+
    "\0\u28d4\0\u2908\0\u293c\0\u2734\0\u2768\0\u2970\0\u28a0\0\u0854"+
    "\0\u0854\0\u29a4\0\u29d8\0\u2a0c\0\u2a40\0\u29a4\0\u2a74\0\u2aa8"+
    "\0\u2adc\0\u2b10";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[314];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\33\1\34\2\33\1\35\1\33\1\36\1\37\1\33"+
    "\1\37\5\33\1\37\2\33\21\37\1\40\4\33\1\37"+
    "\13\33\1\41\2\42\40\41\1\43\4\41\1\44\11\41"+
    "\1\45\1\41\1\46\2\42\43\46\1\47\13\46\1\50"+
    "\1\46\1\42\1\34\2\33\1\51\1\42\1\36\1\52"+
    "\1\42\1\52\5\42\1\52\2\42\21\52\1\53\1\42"+
    "\1\54\2\42\1\52\3\42\1\33\6\42\1\33\1\42"+
    "\1\34\2\33\3\42\1\55\1\42\1\55\5\42\1\55"+
    "\2\42\21\55\5\42\1\55\3\42\1\33\6\42\1\33"+
    "\1\42\1\34\2\33\3\42\1\56\1\42\1\56\5\42"+
    "\1\56\2\42\21\56\1\57\1\60\3\42\1\56\3\42"+
    "\1\33\6\42\1\33\1\42\1\34\2\33\3\42\1\61"+
    "\1\42\1\61\5\42\1\61\2\42\21\61\1\62\3\42"+
    "\1\63\1\61\3\42\1\33\6\42\1\33\1\42\1\64"+
    "\1\65\1\33\1\66\1\67\1\36\1\70\1\71\1\70"+
    "\1\72\1\73\1\74\1\71\1\75\1\76\1\77\1\54"+
    "\1\100\1\76\1\70\1\76\1\101\1\102\1\103\1\104"+
    "\1\105\1\106\1\70\1\107\1\110\1\111\3\70\1\112"+
    "\1\113\1\114\1\42\1\115\1\70\1\116\1\42\1\71"+
    "\1\33\1\117\1\120\1\121\1\122\1\67\1\42\1\33"+
    "\1\123\1\34\1\33\1\123\1\124\1\123\1\125\5\123"+
    "\1\73\4\123\1\126\32\123\1\33\6\123\1\33\1\42"+
    "\1\34\2\33\3\42\1\127\1\42\1\127\5\42\1\127"+
    "\1\42\1\126\21\127\1\130\1\42\1\73\2\42\1\127"+
    "\3\42\1\33\6\42\1\33\1\42\1\34\2\33\3\42"+
    "\1\131\1\42\1\131\5\42\1\131\2\42\21\131\1\132"+
    "\4\42\1\131\3\42\1\33\6\42\1\33\1\42\1\34"+
    "\2\33\1\51\1\42\1\36\1\133\1\42\1\133\4\42"+
    "\1\134\1\133\2\42\21\133\1\135\4\42\1\133\3\42"+
    "\1\33\6\42\1\33\64\42\43\136\1\137\1\140\1\141"+
    "\14\136\1\42\1\136\1\142\1\143\1\144\61\142\1\42"+
    "\1\64\1\65\1\33\1\66\1\67\1\36\1\145\1\42"+
    "\1\145\1\42\1\73\2\42\1\146\1\147\1\150\1\42"+
    "\2\147\1\145\1\147\2\145\1\147\12\145\2\42\1\151"+
    "\1\42\1\115\1\145\1\121\1\42\1\67\1\33\1\117"+
    "\1\120\1\121\1\122\1\67\1\42\1\33\12\42\1\152"+
    "\31\42\1\153\20\42\1\34\2\33\1\51\1\42\1\36"+
    "\5\42\1\73\1\42\1\63\14\42\1\154\20\42\1\33"+
    "\6\42\1\33\1\42\1\34\2\33\1\51\1\42\1\36"+
    "\1\155\1\42\1\155\5\42\1\155\1\42\1\156\11\155"+
    "\1\157\7\155\5\42\1\155\3\42\1\33\6\42\1\33"+
    "\1\160\1\161\1\33\1\160\1\162\1\160\1\163\7\160"+
    "\1\164\26\160\1\73\1\160\1\165\14\160\1\42\1\34"+
    "\2\33\1\51\1\42\1\36\1\166\1\42\1\166\5\42"+
    "\1\166\1\42\1\156\11\166\1\167\7\166\5\42\1\166"+
    "\3\42\1\33\6\42\1\33\1\42\1\34\2\33\1\51"+
    "\1\42\1\36\1\170\1\42\1\170\4\42\1\171\1\172"+
    "\1\173\1\42\2\172\1\170\1\172\2\170\1\172\12\170"+
    "\5\42\1\170\3\42\1\33\6\42\1\33\1\42\1\34"+
    "\2\33\1\51\1\42\1\36\1\174\1\42\1\174\4\42"+
    "\1\175\1\176\1\177\1\42\2\176\1\174\1\176\2\174"+
    "\1\176\12\174\5\42\1\174\3\42\1\33\6\42\1\33"+
    "\1\200\1\201\1\33\1\202\1\203\1\200\1\204\4\200"+
    "\1\73\5\200\1\63\32\200\1\33\6\200\1\202\1\42"+
    "\1\205\1\73\1\33\1\51\1\42\1\36\4\42\1\73"+
    "\4\42\1\206\33\42\1\33\6\42\1\33\1\42\1\207"+
    "\1\151\1\73\1\210\1\151\1\211\1\212\1\42\1\212"+
    "\1\213\2\151\1\156\1\151\1\212\1\214\1\151\21\212"+
    "\2\42\1\151\1\42\1\215\1\212\1\216\1\42\1\151"+
    "\1\73\1\217\1\220\1\216\1\221\1\151\1\42\1\73"+
    "\66\0\1\33\65\0\1\36\1\222\56\0\1\36\2\0"+
    "\61\36\1\0\1\223\1\224\1\225\4\0\2\226\5\0"+
    "\1\226\2\0\21\226\1\227\1\230\2\0\1\231\3\0"+
    "\1\226\1\225\6\0\1\225\1\232\2\0\61\232\1\41"+
    "\2\0\40\41\1\0\4\41\1\0\11\41\1\0\1\41"+
    "\43\233\1\234\1\235\17\233\22\0\1\236\1\237\6\0"+
    "\1\240\10\0\1\241\20\0\1\46\2\0\43\46\1\0"+
    "\13\46\1\0\1\46\22\0\1\236\1\237\6\0\1\240"+
    "\13\0\1\242\25\0\2\55\5\0\1\55\2\0\21\55"+
    "\10\0\1\55\20\0\2\56\5\0\1\56\2\0\21\56"+
    "\10\0\1\56\20\0\2\61\5\0\1\61\2\0\21\61"+
    "\10\0\1\61\12\0\1\65\71\0\2\70\1\77\2\0"+
    "\1\243\1\0\1\70\1\77\1\0\21\70\10\0\1\70"+
    "\20\0\1\71\4\0\1\71\35\0\1\71\11\0\3\244"+
    "\22\0\1\245\25\0\1\244\6\0\1\244\10\0\2\246"+
    "\1\247\2\0\1\246\1\0\1\246\2\0\21\246\10\0"+
    "\1\246\20\0\2\76\1\250\2\0\1\251\1\0\1\76"+
    "\1\77\1\0\21\76\10\0\1\76\20\0\2\76\1\250"+
    "\2\0\1\251\1\0\1\76\1\77\1\0\1\76\1\252"+
    "\1\253\16\76\10\0\1\76\20\0\2\70\1\77\2\0"+
    "\1\243\1\0\1\70\1\77\1\0\5\70\1\254\13\70"+
    "\10\0\1\70\20\0\2\70\1\77\2\0\1\243\1\0"+
    "\1\70\1\77\1\0\10\70\1\255\10\70\10\0\1\70"+
    "\20\0\2\76\1\250\2\0\1\251\1\0\1\76\1\77"+
    "\1\0\11\76\1\256\7\76\10\0\1\76\20\0\2\70"+
    "\1\77\2\0\1\243\1\0\1\70\1\77\1\0\1\257"+
    "\2\70\1\260\15\70\10\0\1\70\20\0\2\70\1\77"+
    "\2\0\1\243\1\0\1\70\1\77\1\0\2\70\1\261"+
    "\16\70\10\0\1\70\20\0\2\70\1\77\2\0\1\243"+
    "\1\0\1\70\1\77\1\0\4\70\1\262\14\70\10\0"+
    "\1\70\20\0\2\70\1\77\2\0\1\243\1\0\1\70"+
    "\1\77\1\0\5\70\1\263\13\70\10\0\1\70\20\0"+
    "\2\70\1\77\2\0\1\243\1\0\1\70\1\77\1\0"+
    "\15\70\1\264\3\70\10\0\1\70\20\0\2\70\1\77"+
    "\2\0\1\243\1\0\1\70\1\77\1\0\14\70\1\265"+
    "\4\70\10\0\1\70\11\0\3\266\3\0\1\267\1\0"+
    "\1\267\5\0\1\267\2\0\4\267\1\270\14\267\1\271"+
    "\4\0\1\267\3\0\1\266\6\0\1\266\47\0\1\67"+
    "\63\0\1\121\1\0\1\272\67\0\1\67\64\0\1\67"+
    "\54\0\1\121\24\0\2\273\4\0\1\274\1\273\2\0"+
    "\21\273\10\0\1\273\10\0\1\275\2\0\40\275\1\276"+
    "\20\275\10\0\2\131\5\0\1\131\2\0\21\131\10\0"+
    "\1\131\20\0\2\133\5\0\1\133\2\0\21\133\10\0"+
    "\1\133\10\0\1\277\2\0\40\277\1\300\20\277\43\136"+
    "\3\0\14\136\1\0\1\136\1\142\2\0\61\142\2\0"+
    "\1\144\71\0\2\145\3\0\1\301\1\0\1\145\1\214"+
    "\1\0\21\145\10\0\1\145\20\0\2\302\1\303\2\0"+
    "\1\302\1\0\1\302\2\0\21\302\10\0\1\302\20\0"+
    "\2\147\1\303\2\0\1\304\1\0\1\147\1\214\1\0"+
    "\21\147\10\0\1\147\11\0\3\305\22\0\1\306\25\0"+
    "\1\305\6\0\1\305\1\0\3\307\22\0\1\310\25\0"+
    "\1\307\6\0\1\307\26\0\1\311\45\0\2\155\5\0"+
    "\1\155\2\0\21\155\10\0\1\155\20\0\2\155\5\0"+
    "\1\155\2\0\10\155\1\312\10\155\10\0\1\155\10\0"+
    "\2\160\1\0\42\160\1\0\20\160\1\33\42\160\1\0"+
    "\20\160\1\0\1\160\1\163\1\313\37\160\1\0\16\160"+
    "\1\163\1\160\1\0\42\163\1\36\16\163\2\160\1\0"+
    "\42\160\1\0\11\160\1\164\4\160\10\0\2\166\5\0"+
    "\1\166\2\0\21\166\10\0\1\166\20\0\2\166\5\0"+
    "\1\166\2\0\10\166\1\314\10\166\10\0\1\166\20\0"+
    "\2\170\1\173\2\0\1\315\1\0\1\170\1\173\1\0"+
    "\21\170\10\0\1\170\20\0\2\316\1\317\2\0\1\316"+
    "\1\0\1\316\2\0\21\316\10\0\1\316\20\0\2\172"+
    "\1\320\2\0\1\321\1\0\1\172\1\173\1\0\21\172"+
    "\10\0\1\172\20\0\2\174\1\177\2\0\1\322\1\0"+
    "\1\174\1\177\1\0\21\174\10\0\1\174\20\0\2\323"+
    "\1\324\2\0\1\323\1\0\1\323\2\0\21\323\10\0"+
    "\1\323\20\0\2\176\1\325\2\0\1\326\1\0\1\176"+
    "\1\177\1\0\21\176\10\0\1\176\10\0\2\200\1\0"+
    "\10\200\1\0\5\200\1\0\32\200\1\0\11\200\1\33"+
    "\10\200\1\0\5\200\1\0\32\200\1\0\11\200\1\0"+
    "\1\200\1\204\1\327\5\200\1\0\5\200\1\0\32\200"+
    "\1\0\7\200\1\204\1\200\1\0\10\204\1\36\5\204"+
    "\1\36\32\204\1\36\7\204\2\0\1\73\63\0\1\151"+
    "\65\0\1\211\1\330\56\0\1\211\2\0\61\211\10\0"+
    "\2\212\5\0\1\212\1\214\1\0\21\212\10\0\1\212"+
    "\57\0\1\151\63\0\1\216\71\0\1\151\64\0\1\151"+
    "\5\0\5\331\1\332\56\331\2\0\1\224\4\0\1\333"+
    "\1\0\1\333\5\0\1\333\2\0\21\333\3\0\1\334"+
    "\1\0\1\333\22\0\1\333\1\0\1\333\5\0\1\333"+
    "\2\0\21\333\3\0\1\334\1\0\1\333\16\0\1\335"+
    "\3\0\1\333\1\0\1\333\5\0\1\333\2\0\21\333"+
    "\1\227\1\230\1\0\1\334\1\231\1\333\3\0\1\335"+
    "\6\0\1\335\1\227\2\0\40\227\1\336\20\227\45\230"+
    "\1\337\16\230\1\232\2\0\40\232\1\340\20\232\10\0"+
    "\2\243\3\0\1\243\1\0\1\243\2\0\21\243\10\0"+
    "\1\243\47\0\1\341\34\0\6\342\1\0\2\342\1\0"+
    "\22\342\2\0\1\342\4\0\1\342\20\0\2\251\1\247"+
    "\2\0\1\251\1\0\1\251\2\0\21\251\10\0\1\251"+
    "\20\0\2\76\1\250\2\0\1\251\1\0\1\76\1\77"+
    "\1\0\2\76\1\343\16\76\10\0\1\76\20\0\2\76"+
    "\1\250\2\0\1\251\1\0\1\76\1\77\1\0\17\76"+
    "\1\344\1\76\10\0\1\76\20\0\2\70\1\77\2\0"+
    "\1\243\1\0\1\70\1\77\1\0\6\70\1\345\12\70"+
    "\10\0\1\70\20\0\2\70\1\77\2\0\1\243\1\0"+
    "\1\70\1\77\1\0\16\70\1\346\2\70\10\0\1\70"+
    "\20\0\2\76\1\250\2\0\1\251\1\0\1\76\1\77"+
    "\1\0\7\76\1\347\11\76\10\0\1\76\20\0\2\70"+
    "\1\77\2\0\1\243\1\0\1\70\1\77\1\0\1\70"+
    "\1\350\17\70\10\0\1\70\20\0\2\70\1\77\2\0"+
    "\1\243\1\0\1\70\1\351\1\0\1\352\20\70\10\0"+
    "\1\70\20\0\2\70\1\77\2\0\1\243\1\0\1\70"+
    "\1\77\1\0\6\70\1\353\4\70\1\354\5\70\10\0"+
    "\1\70\20\0\2\70\1\77\2\0\1\243\1\0\1\70"+
    "\1\355\1\0\17\70\1\356\1\70\10\0\1\70\20\0"+
    "\2\70\1\77\2\0\1\243\1\0\1\70\1\77\1\0"+
    "\15\70\1\357\3\70\10\0\1\70\20\0\2\70\1\77"+
    "\2\0\1\243\1\0\1\360\1\77\1\0\21\70\10\0"+
    "\1\70\20\0\2\267\4\0\1\361\1\267\2\0\21\267"+
    "\10\0\1\267\20\0\2\267\4\0\1\361\1\267\2\0"+
    "\15\267\1\362\3\267\10\0\1\267\10\0\1\271\2\0"+
    "\40\271\1\363\20\271\7\0\1\364\1\0\1\364\5\0"+
    "\1\364\2\0\21\364\5\0\1\364\1\0\2\365\1\366"+
    "\7\0\1\275\2\0\13\275\1\367\24\275\1\276\20\275"+
    "\10\0\2\301\3\0\1\301\1\0\1\301\2\0\21\301"+
    "\10\0\1\301\20\0\6\370\1\0\2\370\1\0\22\370"+
    "\2\0\1\370\4\0\1\370\20\0\2\304\1\303\2\0"+
    "\1\304\1\0\1\304\2\0\21\304\10\0\1\304\47\0"+
    "\1\371\63\0\1\372\24\0\2\373\1\331\42\373\1\331"+
    "\16\373\10\0\2\315\3\0\1\315\1\0\1\315\2\0"+
    "\21\315\10\0\1\315\20\0\6\374\1\0\2\374\1\0"+
    "\22\374\2\0\1\374\4\0\1\374\20\0\2\321\1\317"+
    "\2\0\1\321\1\0\1\321\2\0\21\321\10\0\1\321"+
    "\20\0\2\322\3\0\1\322\1\0\1\322\2\0\21\322"+
    "\10\0\1\322\20\0\6\375\1\0\2\375\1\0\22\375"+
    "\2\0\1\375\4\0\1\375\20\0\2\326\1\324\2\0"+
    "\1\326\1\0\1\326\2\0\21\326\10\0\1\326\10\0"+
    "\2\376\1\331\2\376\1\377\5\376\1\331\5\376\1\331"+
    "\32\376\1\331\7\376\5\u0100\1\u0101\56\u0100\5\331\1\u0102"+
    "\62\331\1\u0103\1\u0102\56\331\1\0\1\223\1\224\1\u0104"+
    "\4\0\2\333\5\0\1\333\2\0\21\333\1\227\1\230"+
    "\6\0\1\333\1\u0104\6\0\1\u0104\46\334\1\u0105\15\334"+
    "\3\0\1\335\37\0\1\227\1\230\2\0\1\231\4\0"+
    "\1\335\6\0\1\335\1\227\1\223\1\224\1\u0106\37\227"+
    "\1\336\1\230\7\227\1\u0106\6\227\1\u0106\1\232\2\0"+
    "\1\340\37\232\1\340\3\232\1\u0107\4\232\1\340\6\232"+
    "\1\340\23\0\1\u0108\50\0\4\342\1\u0109\1\342\1\0"+
    "\2\342\1\0\22\342\2\0\1\342\4\0\1\342\20\0"+
    "\2\76\1\250\2\0\1\251\1\0\1\76\1\77\1\0"+
    "\3\76\1\u010a\15\76\10\0\1\76\20\0\2\76\1\250"+
    "\2\0\1\251\1\0\1\76\1\77\1\0\6\76\1\u010b"+
    "\12\76\10\0\1\76\20\0\2\70\1\77\2\0\1\243"+
    "\1\0\1\70\1\77\1\0\7\70\1\u010c\11\70\10\0"+
    "\1\70\20\0\2\76\1\250\2\0\1\251\1\0\1\76"+
    "\1\u010d\1\0\1\u010e\20\76\10\0\1\76\20\0\2\70"+
    "\1\77\2\0\1\243\1\0\1\70\1\77\1\0\11\70"+
    "\1\u010f\7\70\10\0\1\70\20\0\2\70\1\77\2\0"+
    "\1\243\1\0\1\70\1\351\1\0\1\u0110\20\70\10\0"+
    "\1\70\20\0\2\70\1\77\2\0\1\243\1\0\1\70"+
    "\1\77\1\0\6\70\1\u0111\12\70\10\0\1\70\20\0"+
    "\2\70\1\77\2\0\1\243\1\0\1\70\1\77\1\0"+
    "\14\70\1\u0112\4\70\10\0\1\70\20\0\2\70\1\77"+
    "\2\0\1\243\1\0\1\70\1\355\1\0\17\70\1\u0113"+
    "\1\70\10\0\1\70\20\0\2\70\1\77\2\0\1\243"+
    "\1\0\1\70\1\77\1\0\6\70\1\u0114\12\70\10\0"+
    "\1\70\20\0\2\70\1\77\2\0\1\243\1\0\1\70"+
    "\1\77\1\0\3\70\1\u0115\15\70\10\0\1\70\20\0"+
    "\2\267\4\0\1\361\1\267\2\0\1\267\1\u0116\17\267"+
    "\10\0\1\267\10\0\1\271\2\0\13\271\1\u0117\24\271"+
    "\1\363\20\271\10\0\2\364\5\0\1\364\2\0\21\364"+
    "\10\0\1\364\17\0\1\u0118\1\0\1\u0118\5\0\1\u0118"+
    "\2\0\21\u0118\5\0\1\u0118\22\0\1\364\1\0\1\364"+
    "\5\0\1\364\2\0\21\364\5\0\1\364\23\0\4\370"+
    "\1\u0119\1\370\1\0\2\370\1\0\22\370\2\0\1\370"+
    "\4\0\1\370\33\0\1\u011a\63\0\1\u011b\40\0\2\373"+
    "\1\331\2\373\1\u011c\37\373\1\331\16\373\10\0\4\374"+
    "\1\u011d\1\374\1\0\2\374\1\0\22\374\2\0\1\374"+
    "\4\0\1\374\20\0\4\375\1\u011e\1\375\1\0\2\375"+
    "\1\0\22\375\2\0\1\375\4\0\1\375\10\0\2\376"+
    "\1\331\2\376\1\u011f\5\376\1\331\5\376\1\331\32\376"+
    "\1\331\11\376\1\331\1\376\1\u0120\1\u011f\5\376\1\331"+
    "\5\376\1\331\32\376\1\331\7\376\5\u0100\1\u0121\62\u0100"+
    "\1\u0122\1\u0121\56\u0100\4\331\1\33\1\u0102\56\331\1\0"+
    "\1\223\1\224\1\u0104\3\0\1\333\1\0\1\333\5\0"+
    "\1\333\2\0\21\333\1\227\1\230\1\0\1\334\1\0"+
    "\1\333\3\0\1\u0104\6\0\1\u0104\1\0\1\223\1\224"+
    "\1\u0104\37\0\1\227\1\230\7\0\1\u0104\6\0\1\u0104"+
    "\1\227\1\223\1\224\1\u0106\3\227\1\u0123\1\227\1\u0123"+
    "\5\227\1\u0123\2\227\21\u0123\1\336\1\230\1\227\1\u0124"+
    "\1\227\1\u0123\3\227\1\u0106\6\227\1\u0106\3\0\1\u0125"+
    "\50\0\1\u0125\6\0\1\u0125\10\0\2\76\1\250\2\0"+
    "\1\251\1\0\1\76\1\u010d\1\0\3\76\1\u0126\15\76"+
    "\10\0\1\76\20\0\2\70\1\77\2\0\1\243\1\0"+
    "\1\70\1\77\1\0\3\70\1\u0127\15\70\10\0\1\70"+
    "\20\0\2\76\1\250\2\0\1\251\1\0\1\76\1\u010d"+
    "\1\0\1\u0128\20\76\10\0\1\76\20\0\2\70\1\77"+
    "\2\0\1\243\1\0\1\70\1\77\1\0\10\70\1\u0129"+
    "\10\70\10\0\1\70\20\0\2\70\1\77\2\0\1\243"+
    "\1\0\1\70\1\77\1\0\3\70\1\u012a\15\70\10\0"+
    "\1\70\20\0\2\70\1\77\2\0\1\243\1\0\1\70"+
    "\1\77\1\0\20\70\1\u012b\10\0\1\70\13\0\1\u0125"+
    "\4\0\2\267\4\0\1\361\1\267\2\0\21\267\10\0"+
    "\1\267\1\u0125\6\0\1\u0125\10\0\2\u0118\5\0\1\u0118"+
    "\2\0\21\u0118\10\0\1\u0118\13\0\1\u012c\50\0\1\u012c"+
    "\6\0\1\u012c\3\0\1\u012d\50\0\1\u012d\6\0\1\u012d"+
    "\2\373\1\331\1\373\1\160\1\u011c\37\373\1\331\16\373"+
    "\2\376\1\331\1\376\1\202\1\u011f\5\376\1\331\5\376"+
    "\1\331\32\376\1\331\7\376\4\u0100\1\73\1\u0121\56\u0100"+
    "\1\227\1\223\1\224\1\u0106\4\227\2\u0123\5\227\1\u0123"+
    "\2\227\21\u0123\1\336\1\230\6\227\1\u0123\1\u0106\6\227"+
    "\1\u0106\1\u0124\2\334\40\u0124\1\u012e\2\u0124\1\336\15\u0124"+
    "\10\0\2\76\1\250\2\0\1\251\1\0\1\76\1\u010d"+
    "\1\0\3\76\1\u012f\15\76\10\0\1\76\20\0\2\70"+
    "\1\77\2\0\1\243\1\0\1\70\1\77\1\0\12\70"+
    "\1\u0130\6\70\10\0\1\70\20\0\2\70\1\77\2\0"+
    "\1\243\1\0\1\70\1\77\1\0\1\70\1\u0131\17\70"+
    "\10\0\1\70\20\0\2\70\1\77\2\0\1\243\1\0"+
    "\1\70\1\355\1\0\1\u0132\20\70\10\0\1\70\10\0"+
    "\1\u0124\1\u0133\1\u0134\1\u0135\37\u0124\1\u012e\1\230\1\u0124"+
    "\1\336\5\u0124\1\u0135\6\u0124\1\u0135\10\0\2\70\1\77"+
    "\2\0\1\243\1\0\1\70\1\355\1\0\1\u0136\20\70"+
    "\10\0\1\70\10\0\2\334\1\u0134\4\334\1\u0137\1\334"+
    "\1\u0137\5\334\1\u0137\2\334\21\u0137\3\334\1\u0138\1\334"+
    "\1\u0137\22\334\1\u0137\1\334\1\u0137\5\334\1\u0137\2\334"+
    "\21\u0137\3\334\1\u0138\1\334\1\u0137\13\334\1\u0124\1\u0133"+
    "\1\u0134\1\u0135\3\u0124\1\u0139\1\u0124\1\u0139\5\u0124\1\u0139"+
    "\2\u0124\21\u0139\1\u012e\1\230\1\u0124\1\u012e\1\u0124\1\u0139"+
    "\3\u0124\1\u0135\6\u0124\1\u0135\1\334\1\u0133\1\u0134\1\u013a"+
    "\4\334\2\u0137\5\334\1\u0137\2\334\21\u0137\1\u0124\1\230"+
    "\1\334\1\u0105\4\334\1\u0137\1\u013a\6\334\1\u013a\1\334"+
    "\1\u0133\1\u0134\1\u013a\37\334\1\u0124\1\230\1\334\1\u0105"+
    "\5\334\1\u013a\6\334\1\u013a\1\u0124\1\u0133\1\u0134\1\u0135"+
    "\4\u0124\2\u0139\5\u0124\1\u0139\2\u0124\21\u0139\1\u012e\1\230"+
    "\1\u0124\1\336\4\u0124\1\u0139\1\u0135\6\u0124\1\u0135\1\334"+
    "\1\u0133\1\u0134\1\u013a\3\334\1\u0137\1\334\1\u0137\5\334"+
    "\1\u0137\2\334\21\u0137\1\u0124\1\230\1\334\1\u0138\1\334"+
    "\1\u0137\3\334\1\u013a\6\334\1\u013a";

  private static int [] zzUnpackTrans() {
    int [] result = new int[11076];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\32\0\1\11\6\1\2\11\3\1\1\11\4\1\1\11"+
    "\2\1\2\11\1\1\2\11\1\1\1\11\1\1\1\11"+
    "\3\1\2\11\2\1\1\11\12\1\1\11\1\1\1\11"+
    "\6\1\1\11\2\1\1\11\3\1\1\11\1\1\1\11"+
    "\2\1\3\11\2\1\1\11\3\1\2\11\4\1\1\11"+
    "\14\1\1\11\3\1\1\11\6\1\1\11\4\1\2\11"+
    "\5\1\7\0\1\11\1\0\10\11\1\1\4\0\16\1"+
    "\6\0\1\11\3\0\2\1\2\0\1\1\4\0\1\11"+
    "\4\1\2\0\3\1\2\0\3\1\7\0\1\1\3\0"+
    "\6\1\1\11\3\1\1\11\3\1\1\11\2\0\1\1"+
    "\2\0\1\1\3\0\1\1\2\0\2\1\3\0\1\1"+
    "\3\0\1\1\1\0\4\1\1\11\10\1\1\0\3\1"+
    "\2\0\5\1\1\0\1\1\2\0\11\1\1\0\4\1"+
    "\3\0\1\1\4\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[314];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;
  
  /** 
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /* user code: */
  StringBuffer string = new StringBuffer();
  String endOfMultiLineSymbol;
  Boolean isMultiLineFirstNewLine = true;
  Boolean isMultilineModified = false;
  Boolean stringAttributeName = false;
  int curleyBraceCounter = 0;
  int interpolatedCurleyBraceCounter = 0;
  Symbol currentValue;
  String currentMapKey;
  public ArrayList<Symbol> elementStack = new ArrayList<Symbol>();
  ArrayList<String> blockNames = null;
  Boolean inMap = false;
  Boolean fromMapKey = false;
  HCLAttribute attribute;
  SubTypePrimitiveType subTypePrimitiveType;
  Integer primitiveDepth = 0;
  Integer previousState = null;

  Symbol currentBlock = null;
  private Symbol hclBlock(List<String> blockNames) {
    //System.out.println("Starting Block");
    HCLBlock block = new HCLBlock(blockNames,currentBlock,yyline,yycolumn-1,yychar-1);
    if(currentBlock == null) {
      elementStack.add(block);
    } else {
      currentBlock.appendChild(block);
    }
    currentBlock = block;
  return currentBlock;
  }

  private Symbol exitBlock() {

    Symbol result = null;
    if(currentBlock != null) {
      if(currentBlock.getParent() == null) {
        result = currentBlock;
      }
      currentBlock =  currentBlock.getParent();

    }
    return result;
  }

  private void startAttribute(String name) {
        //System.out.println("Starting Attribute");

    HCLAttribute currentAttribute = new HCLAttribute(name,yyline,yycolumn,yychar);
    if(currentBlock == null) {
      elementStack.add(currentAttribute);
    } else {
      currentBlock.appendChild(currentAttribute);
    }
    currentBlock = currentAttribute;
    attribute = currentAttribute;
  }

  private void startAttribute(StringInterpolatedExpression expression) {
          //System.out.println("Starting Attribute");

      HCLAttribute currentAttribute = new HCLAttribute(null,yyline,yycolumn,yychar);
      currentAttribute.runtimeName = expression;
      if(currentBlock == null) {
        elementStack.add(currentAttribute);
      } else {
        currentBlock.appendChild(currentAttribute);
      }
      currentBlock = currentAttribute;
      attribute = currentAttribute;
    }

  private void startMap() {
    HCLMap currentAttribute = new HCLMap(yyline,yycolumn,yychar);
        if(currentBlock == null) {
          elementStack.add(currentAttribute);
        } else {
          currentBlock.appendChild(currentAttribute);
        }
        currentBlock = currentAttribute;
  }

  private void startInterpolatedString() {
    StringInterpolatedExpression currentAttribute;
    if(currentBlock != null && currentBlock instanceof StringInterpolatedExpression) {
     //we behave different since already in one
        currentAttribute = (StringInterpolatedExpression)currentBlock;
    } else {
        currentAttribute = new StringInterpolatedExpression(yyline,yycolumn,yychar);
        if(currentBlock == null) {
            elementStack.add(currentAttribute);
          } else {
            currentBlock.appendChild(currentAttribute);
          }
    }
    currentAttribute.appendChild(new HCLValue("string",string.toString(),yyline,yycolumn,yychar));
    string.setLength(0);
    currentAttribute.appendChild(new Operator("+",yyline,yycolumn,yychar));
    StringInterpolatedExpression expr = new StringInterpolatedExpression(yyline,yycolumn,yychar);
    currentAttribute.appendChild(expr);


      currentBlock = expr;
      yybegin(HCLATTRIBUTEVALUE);
  }



  private void startArray() {
        HCLArray currentAttribute = new HCLArray(yyline,yycolumn,yychar);
            if(currentBlock == null) {
              elementStack.add(currentAttribute);
            } else {
              currentBlock.appendChild(currentAttribute);
            }
            currentBlock = currentAttribute;
            yybegin(HCLARRAY);
  }


  private void startGroupedExpression() {
          GroupedExpression currentAttribute = new GroupedExpression(yyline,yycolumn,yychar);
              if(currentBlock == null) {
                elementStack.add(currentAttribute);
              } else {
                currentBlock.appendChild(currentAttribute);
              }
              currentBlock = currentAttribute;
              yybegin(HCLATTRIBUTEVALUE);
    }

    private void startNestedStringExpression() {
      StringInterpolatedExpression currentAttribute = new StringInterpolatedExpression(yyline,yycolumn,yychar);
      if(currentBlock == null) {
        elementStack.add(currentAttribute);
      } else {
        currentBlock.appendChild(currentAttribute);
      }
      currentBlock = currentAttribute;      
    }


  private void startVariableTree() {
          VariableTree currentAttribute = new VariableTree(yyline,yycolumn,yychar);
              if(currentBlock == null) {
                elementStack.add(currentAttribute);
              } else {
                currentBlock.appendChild(currentAttribute);
              }
              currentBlock = currentAttribute;
              yypushback(yylength());
              yybegin(VARIABLETREE);
    }


  private void startComputedTuple() {
          ComputedTuple currentAttribute = new ComputedTuple(yytext(),yyline,yycolumn,yychar);
              if(currentBlock == null) {
                elementStack.add(currentAttribute);
              } else {
                currentBlock.appendChild(currentAttribute);
              }
              currentBlock = currentAttribute;
              yybegin(FORTUPLEVARIABLES);
    }

    private void startForConditional() {
        ForConditional currentAttribute = new ForConditional(yyline,yycolumn,yychar);
          if(currentBlock == null) {
            elementStack.add(currentAttribute);
          } else {
            currentBlock.appendChild(currentAttribute);
          }
          currentBlock = currentAttribute;
          yybegin(HCLATTRIBUTEVALUE);
    }

    private void startComputedObject() {
              ComputedObject currentAttribute = new ComputedObject(yytext(),yyline,yycolumn,yychar);
              if(currentBlock == null) {
                elementStack.add(currentAttribute);
              } else {
                currentBlock.appendChild(currentAttribute);
              }
              currentBlock = currentAttribute;
              yybegin(FOROBJVARIABLES);
    }

    private void startFunction() {
            String functionName = yytext();
            if(functionName.endsWith("(")) {
                functionName = functionName.substring(0,functionName.length() - 1);
            }
            Function currentAttribute = new Function(functionName,yyline,yycolumn,yychar);
                if(currentBlock == null) {
                  elementStack.add(currentAttribute);
                } else {
                  currentBlock.appendChild(currentAttribute);
                }
                currentBlock = currentAttribute;
                yybegin(FUNCTIONCALL);
      }


  private Symbol exitAttribute(Boolean force) {

    if(currentBlock == null) {
      yybegin(YYINITIAL);
      Symbol result = attribute;
      attribute = null;
      exitBlock();
      return result;
    } else {
      attribute = null;
        if((!(currentBlock instanceof HCLArray) && !(currentBlock instanceof HCLMap) && !(currentBlock instanceof GroupedExpression) && !(currentBlock instanceof StringInterpolatedExpression) && !(currentBlock instanceof VariableTree) && !(currentBlock instanceof Variable) && !(currentBlock instanceof ComputedTuple) && !(currentBlock instanceof ComputedObject) && !(currentBlock instanceof Function)) || force == true) {
          exitBlock();

        }

      if(currentBlock instanceof Variable || currentBlock instanceof VariableTree) {
        yybegin(VARIABLETREE);
      }  else if(currentBlock instanceof SubTypePrimitiveType) {
         yybegin(SUBTYPEPRIMITIVETYPE);
      } else if(currentBlock instanceof StringInterpolatedExpression) {
                yybegin(HCLATTRIBUTEVALUE);
      } else if(currentBlock instanceof GroupedExpression) {
         yybegin(HCLATTRIBUTEVALUE);
      } else if(currentBlock instanceof ForConditional) {
         yybegin(HCLATTRIBUTEVALUE);
      } else if(currentBlock instanceof ComputedTuple) {
        yybegin(FORTUPLEEXPRESSION);
      } else if(currentBlock instanceof ComputedObject) {
        yybegin(FOROBJECTEXPRESSION);
      } else if(currentBlock instanceof Function) {
         yybegin(FUNCTIONCALL);
      } else if(currentBlock instanceof HCLBlock) {
        yybegin(HCLINBLOCK);
      } else if(currentBlock instanceof HCLArray) {
        yybegin(HCLARRAY);
      } else if(currentBlock instanceof HCLMap) {
        yybegin(HCLMAP);
      } else if(currentBlock instanceof HCLAttribute) {
        yybegin(HCLATTRIBUTEVALUE);
      } else {
        yybegin(YYINITIAL);
      }
      return null;
    }
  }

  private Symbol exitAttribute() {
    return exitAttribute(false);
  }

     private void startEvalExpression() {
        yypushback(yylength());
      yybegin(EVALUATEDEXPRESSION);
     }





  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  HCLLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 2570) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException("Reader returned 0 characters. See JFlex examples for workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      /* If numRead == requested, we might have requested to few chars to
         encode a full Unicode character. We assume that a Reader would
         otherwise never return half characters. */
      if (numRead == requested) {
        if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Symbol yylex() throws java.io.IOException, HCLParserException
 {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn += zzCharCount;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { /* ignore */
            }
          case 75: break;
          case 2: 
            { string.append( yytext() );
            }
          case 76: break;
          case 3: 
            { throw new HCLParserException("Illegal character <("+
                                                        yytext()+ ") - state: " + yystate()+"> found on line: " + (yyline+1) + " col: " + (yycolumn+1) );
            }
          case 77: break;
          case 4: 
            { if(blockNames != null) { blockNames.add(string.toString());  yybegin(HCLBLOCKATTRIBUTES); } else if(currentBlock != null && currentBlock instanceof HCLMap && currentMapKey == null) { currentMapKey = string.toString() ; yybegin(HCLMAPKEYDEF); } else if (stringAttributeName) { stringAttributeName = false ; yybegin(HCLATTRIBUTE); if(currentBlock instanceof StringInterpolatedExpression) {StringInterpolatedExpression expr = (StringInterpolatedExpression)currentBlock; exitAttribute(true);startAttribute(expr);yybegin(HCLATTRIBUTE);} else { startAttribute(string.toString());}} else if(currentBlock != null) { currentBlock.appendChild(new HCLValue("string",string.toString(),yyline,yycolumn,yychar));if(currentBlock instanceof StringInterpolatedExpression){exitAttribute(true);}  yybegin(HCLATTRIBUTEVALUE); } else { throw new HCLParserException("String block found outside of block or attribute assignment."); }
            }
          case 78: break;
          case 5: 
            { string.append('\\');
            }
          case 79: break;
          case 6: 
            { if(blockNames != null) { blockNames.add(string.toString());  yybegin(HCLBLOCKATTRIBUTES); } else if(currentBlock != null && currentBlock instanceof HCLMap && currentMapKey == null) { currentMapKey = string.toString() ; yybegin(HCLMAPKEYDEF); } else if (stringAttributeName) { stringAttributeName = false ; yybegin(HCLATTRIBUTE); startAttribute(string.toString());} else if(currentBlock != null) { currentBlock.appendChild(new HCLValue("string",string.toString(),yyline,yycolumn,yychar)); yybegin(HCLATTRIBUTEVALUE); } else { throw new HCLParserException("String block found outside of block or attribute assignment."); }
            }
          case 80: break;
          case 7: 
            { exitAttribute();
            }
          case 81: break;
          case 8: 
            { yybegin(HCLBLOCKATTRIBUTES);blockNames = new ArrayList<String>(); blockNames.add(yytext());
            }
          case 82: break;
          case 9: 
            { blockNames.add(yytext());
            }
          case 83: break;
          case 10: 
            { yybegin(STRINGDOUBLE); string.setLength(0);
            }
          case 84: break;
          case 11: 
            { curleyBraceCounter++ ; hclBlock(blockNames) ; blockNames = null ; yybegin(HCLINBLOCK);
            }
          case 85: break;
          case 12: 
            { startAttribute(yytext());
            }
          case 86: break;
          case 13: 
            { yybegin(STRINGDOUBLE); stringAttributeName = true ;string.setLength(0);
            }
          case 87: break;
          case 14: 
            { yybegin(HCLATTRIBUTEVALUE);
            }
          case 88: break;
          case 15: 
            { if(currentBlock instanceof HCLAttribute) {exitAttribute(true); }
            }
          case 89: break;
          case 16: 
            { currentBlock.appendChild(new Operator(yytext(),yyline,yycolumn,yychar));
            }
          case 90: break;
          case 17: 
            { startEvalExpression();
            }
          case 91: break;
          case 18: 
            { currentBlock.appendChild(new HCLValue("number",yytext(),yyline,yycolumn,yychar)) ;
            }
          case 92: break;
          case 19: 
            { startArray();/* process an array */
            }
          case 93: break;
          case 20: 
            { exitAttribute(true);
            }
          case 94: break;
          case 21: 
            { if(currentBlock instanceof HCLArray) {exitAttribute(true); } else if(currentBlock instanceof ForConditional) { exitAttribute(true); yypushback(yylength());}
            }
          case 95: break;
          case 22: 
            { if(currentBlock instanceof StringInterpolatedExpression) {startNestedStringExpression();} yybegin(STRINGDOUBLE); string.setLength(0);
            }
          case 96: break;
          case 23: 
            { blockNames = new ArrayList<String>(); blockNames.add(currentBlock.getName()); curleyBraceCounter++ ; hclBlock(blockNames) ; blockNames = null ; attribute = null ; yybegin(HCLINBLOCK);
            }
          case 97: break;
          case 24: 
            { if(currentBlock instanceof StringInterpolatedExpression) {exitAttribute(true);currentBlock.appendChild(new Operator("+",yyline,yycolumn,yychar));yybegin(STRINGDOUBLE);string.setLength(0);} else {yypushback(yylength()); exitAttribute(true); }
            }
          case 98: break;
          case 25: 
            { yypushback(yylength()); yybegin(HCLATTRIBUTEVALUE);
            }
          case 99: break;
          case 26: 
            { /* should probably process this but due to simplicity we dont need to */
            }
          case 100: break;
          case 27: 
            { currentMapKey = yytext() ; yybegin(HCLMAPKEYDEF);
            }
          case 101: break;
          case 28: 
            { yybegin(STRINGDOUBLE); string.setLength(0); fromMapKey = true;
            }
          case 102: break;
          case 29: 
            { yybegin(HCLMAPKEY); yypushback(yylength());
            }
          case 103: break;
          case 30: 
            { startAttribute(currentMapKey); currentMapKey = null ; yybegin(HCLATTRIBUTEVALUE);
            }
          case 104: break;
          case 31: 
            { string.append(yytext());
            }
          case 105: break;
          case 32: 
            { string.append(yytext()); interpolatedCurleyBraceCounter++;
            }
          case 106: break;
          case 33: 
            { string.append(yytext()); if(interpolatedCurleyBraceCounter > 1) {interpolatedCurleyBraceCounter--;} else { interpolatedCurleyBraceCounter--; yybegin(STRINGDOUBLE);}
            }
          case 107: break;
          case 34: 
            { if(yytext().trim().equals(endOfMultiLineSymbol)) { endOfMultiLineSymbol = null; if(blockNames != null) { blockNames.add(string.toString());  yybegin(HCLBLOCKATTRIBUTES); } else if(attribute != null) { attribute.appendChild(new HCLValue("string",string.toString(),yyline,yycolumn,yychar)) ; exitAttribute(); } else { throw new HCLParserException("String block found outside of block or attribute assignment."); }} else {string.append( isMultilineModified ? yytext() : yytext() );}
            }
          case 108: break;
          case 35: 
            { if(isMultiLineFirstNewLine) {isMultiLineFirstNewLine = false; } else {string.append( yytext() );}
            }
          case 109: break;
          case 36: 
            { startVariableTree();
            }
          case 110: break;
          case 37: 
            { startGroupedExpression();/* ignore */
            }
          case 111: break;
          case 38: 
            { yypushback(yylength()); exitAttribute(true);
            }
          case 112: break;
          case 39: 
            { if(yytext() == "in") {yybegin(HCLATTRIBUTEVALUE);} else {((ComputedObject)currentBlock).getVariables().add(new Variable(yytext(),yyline,yycolumn,yychar));}
            }
          case 113: break;
          case 40: 
            { /*ignore*/
            }
          case 114: break;
          case 41: 
            { if(yytext() == "in") {yybegin(HCLATTRIBUTEVALUE);} else {((ComputedTuple)currentBlock).getVariables().add(new Variable(yytext(),yyline,yycolumn,yychar));}
            }
          case 115: break;
          case 42: 
            { ((ComputedTuple)currentBlock).setSourceExpression( new Variable(yytext(),yyline,yycolumn,yychar));
            }
          case 116: break;
          case 43: 
            { ((ComputedObject)currentBlock).setSourceExpression( new Variable(yytext(),yyline,yycolumn,yychar));
            }
          case 117: break;
          case 44: 
            { currentBlock = subTypePrimitiveType ; yybegin(HCLATTRIBUTEVALUE);
            }
          case 118: break;
          case 45: 
            { currentBlock.appendChild(new Variable(yytext(),yyline,yycolumn,yychar));
            }
          case 119: break;
          case 46: 
            { startArray();
            }
          case 120: break;
          case 47: 
            { startFunction();
            }
          case 121: break;
          case 48: 
            { yybegin(HCLATTRIBUTE);yypushback(yylength());
            }
          case 122: break;
          case 49: 
            { string.append( "$" ); yypushback(yylength()-1);
            }
          case 123: break;
          case 50: 
            { startInterpolatedString();
            }
          case 124: break;
          case 51: 
            { string.append('\t');
            }
          case 125: break;
          case 52: 
            { string.append('\r');
            }
          case 126: break;
          case 53: 
            { string.append('\n');
            }
          case 127: break;
          case 54: 
            { string.append('\"');
            }
          case 128: break;
          case 55: 
            { string.append('\'');
            }
          case 129: break;
          case 56: 
            { yypushback(yylength()); yybegin(HCLMAPKEY);
            }
          case 130: break;
          case 57: 
            { startForConditional();
            }
          case 131: break;
          case 58: 
            { yybegin(HCLBLOCKHEADER);yypushback(yylength());
            }
          case 132: break;
          case 59: 
            { currentBlock.appendChild(new AnyPrimitiveType(yyline,yycolumn,yychar));
            }
          case 133: break;
          case 60: 
            { subTypePrimitiveType = new SetPrimitiveType(null,yyline,yycolumn,yychar); if(yytext().endsWith("(")) { yypushback(1);} currentBlock.appendChild(subTypePrimitiveType); yybegin(SUBTYPEPRIMITIVETYPE);
            }
          case 134: break;
          case 61: 
            { subTypePrimitiveType = new MapPrimitiveType(null,yyline,yycolumn,yychar); if(yytext().endsWith("(")) { yypushback(1);} currentBlock.appendChild(subTypePrimitiveType); yybegin(SUBTYPEPRIMITIVETYPE);
            }
          case 135: break;
          case 62: 
            { startMap(); yypushback(yylength()-1) ; yybegin(HCLMAP);
            }
          case 136: break;
          case 63: 
            { yybegin(MULTILINESTRING) ; isMultiLineFirstNewLine = true ;isMultilineModified = true; string.setLength(0) ; endOfMultiLineSymbol = yytext().substring(2).trim();
            }
          case 137: break;
          case 64: 
            { currentBlock.appendChild(new HCLValue("boolean","true",yyline,yycolumn,yychar)) ;
            }
          case 138: break;
          case 65: 
            { subTypePrimitiveType = new ListPrimitiveType(null,yyline,yycolumn,yychar); if(yytext().endsWith("(")) { yypushback(1);} currentBlock.appendChild(subTypePrimitiveType); yybegin(SUBTYPEPRIMITIVETYPE);
            }
          case 139: break;
          case 66: 
            { currentBlock.appendChild(new HCLValue("null",null,yyline,yycolumn,yychar)) ;
            }
          case 140: break;
          case 67: 
            { currentBlock.appendChild(new BooleanPrimitiveType(yyline,yycolumn,yychar));
            }
          case 141: break;
          case 68: 
            { yybegin(MULTILINESTRING) ; isMultiLineFirstNewLine = true ;isMultilineModified = true; string.setLength(0) ; endOfMultiLineSymbol = yytext().substring(3);
            }
          case 142: break;
          case 69: 
            { yybegin(FORLOOPEXPRESSION); yypushback(yylength());
            }
          case 143: break;
          case 70: 
            { currentBlock.appendChild(new HCLValue("boolean","false",yyline,yycolumn,yychar)) ;
            }
          case 144: break;
          case 71: 
            { startComputedTuple();
            }
          case 145: break;
          case 72: 
            { startComputedObject();
            }
          case 146: break;
          case 73: 
            { currentBlock.appendChild(new StringPrimitiveType(yyline,yycolumn,yychar));
            }
          case 147: break;
          case 74: 
            { currentBlock.appendChild(new NumberPrimitiveType(yyline,yycolumn,yychar));
            }
          case 148: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
