/*
 * Decompiled with CFR 0.152.
 */
package com.bertramlabs.plugins.hcl4j;

import com.bertramlabs.plugins.hcl4j.HCLParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;

public class HCLBaseFunctions {
    static void registerBaseFunctions(HCLParser parser) {
        parser.registerFunction("upper", arguments -> {
            if (arguments.size() > 0 && arguments.get(0) != null) {
                return arguments.get(0).toString().toUpperCase(Locale.ROOT);
            }
            return null;
        });
        parser.registerFunction("lower", arguments -> {
            if (arguments.size() > 0 && arguments.get(0) != null) {
                return arguments.get(0).toString().toLowerCase(Locale.ROOT);
            }
            return null;
        });
        parser.registerFunction("format", arguments -> {
            if (arguments.size() > 0 && arguments.get(0) != null) {
                String val = arguments.get(0).toString();
                ArrayList args = new ArrayList();
                for (int x = 1; x < arguments.size(); ++x) {
                    args.add(arguments.get(x));
                }
                return String.format(val, args.toArray());
            }
            return null;
        });
        parser.registerFunction("trimspace", arguments -> {
            if (arguments.size() > 0 && arguments.get(0) != null) {
                return arguments.get(0).toString();
            }
            return null;
        });
        parser.registerFunction("trim", arguments -> {
            if (arguments.size() > 0 && arguments.get(0) != null) {
                return arguments.get(0).toString();
            }
            return null;
        });
        parser.registerFunction("strrev", arguments -> {
            if (arguments.size() > 0 && arguments.get(0) != null) {
                String str = arguments.get(0).toString();
                String reversed = "";
                for (int i = 0; i < str.length(); ++i) {
                    char ch = str.charAt(i);
                    reversed = ch + reversed;
                }
                return reversed;
            }
            return null;
        });
        parser.registerFunction("contains", arguments -> {
            if (arguments.size() == 2) {
                if (arguments.get(0) instanceof Collection) {
                    Collection list = (Collection)arguments.get(0);
                    try {
                        return list.contains(arguments.get(1));
                    }
                    catch (ClassCastException ex) {
                        return null;
                    }
                }
                return null;
            }
            return null;
        });
        parser.registerFunction("split", arguments -> {
            if (arguments.size() == 2) {
                String separator = (String)arguments.get(0);
                String value = (String)arguments.get(1);
                ArrayList<String> elements = new ArrayList<String>();
                if (value == null) {
                    return null;
                }
                StringTokenizer tokenizer = new StringTokenizer(value, separator);
                while (tokenizer.hasMoreTokens()) {
                    elements.add(tokenizer.nextToken());
                }
                return elements;
            }
            return null;
        });
        parser.registerFunction("join", arguments -> {
            if (arguments.size() == 2) {
                String separator = (String)arguments.get(0);
                if (arguments.get(1) instanceof Collection) {
                    Collection list = (Collection)arguments.get(1);
                    ArrayList<String> elements = new ArrayList<String>();
                    for (Object listItem : list) {
                        elements.add(listItem.toString());
                    }
                    return String.join((CharSequence)separator, elements);
                }
                return null;
            }
            return null;
        });
        parser.registerFunction("startswith", arguments -> {
            if (arguments.size() == 2) {
                String prefix = (String)arguments.get(1);
                String value = (String)arguments.get(0);
                return value.startsWith(prefix);
            }
            return null;
        });
        parser.registerFunction("endswith", arguments -> {
            if (arguments.size() == 2) {
                String prefix = (String)arguments.get(1);
                String value = (String)arguments.get(0);
                return value.endsWith(prefix);
            }
            return null;
        });
        parser.registerFunction("substr", arguments -> {
            if (arguments.size() == 3) {
                Double offset = (Double)arguments.get(1);
                Double length = (Double)arguments.get(2);
                String value = (String)arguments.get(0);
                Integer endIndex = offset.intValue() + length.intValue();
                if (endIndex > value.length() - 1) {
                    endIndex = value.length();
                }
                if (length < 0.0) {
                    endIndex = value.length() + 1 + length.intValue();
                }
                if (offset < 0.0) {
                    offset = (double)value.length() + offset;
                }
                return value.substring(offset.intValue(), endIndex);
            }
            return null;
        });
        parser.registerFunction("replace", arguments -> {
            if (arguments.size() == 3) {
                String substring = (String)arguments.get(1);
                String replacement = (String)arguments.get(2);
                String value = (String)arguments.get(0);
                if (value == null) {
                    return null;
                }
                return value.replace(substring, replacement);
            }
            return null;
        });
        parser.registerFunction("uuid", arguments -> UUID.randomUUID().toString());
        HCLBaseFunctions.registerNumericFunctions(parser);
        HCLBaseFunctions.registerCollectionFunctions(parser);
        HCLBaseFunctions.registerDateFunctions(parser);
        HCLBaseFunctions.registerCastingFunctions(parser);
    }

    static void registerNumericFunctions(HCLParser parser) {
        parser.registerFunction("max", arguments -> {
            Double maxValue = null;
            for (Object argument : arguments) {
                if (!(argument instanceof Double) || maxValue != null && !((Double)argument > maxValue)) continue;
                maxValue = (Double)argument;
            }
            return maxValue;
        });
        parser.registerFunction("tonumber", arguments -> {
            if (arguments.size() > 0 && arguments.get(0) instanceof String) {
                Double val = null;
                try {
                    val = Double.parseDouble((String)arguments.get(0));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return val;
            }
            if (arguments.size() > 0 && arguments.get(0) instanceof Double) {
                return arguments.get(0);
            }
            return null;
        });
        parser.registerFunction("min", arguments -> {
            Double minValue = null;
            for (Object argument : arguments) {
                if (!(argument instanceof Double) || minValue != null && !((Double)argument < minValue)) continue;
                minValue = (Double)argument;
            }
            return minValue;
        });
        parser.registerFunction("abs", arguments -> {
            if (arguments.size() > 0 && arguments.get(0) instanceof Double) {
                Double val = (Double)arguments.get(0);
                return Math.abs(val);
            }
            return null;
        });
        parser.registerFunction("ceil", arguments -> {
            if (arguments.size() > 0 && arguments.get(0) instanceof Double) {
                Double val = (Double)arguments.get(0);
                return Math.ceil(val);
            }
            return null;
        });
        parser.registerFunction("floor", arguments -> {
            if (arguments.size() > 0 && arguments.get(0) instanceof Double) {
                Double val = (Double)arguments.get(0);
                return Math.floor(val);
            }
            return null;
        });
    }

    static void registerCollectionFunctions(HCLParser parser) {
        parser.registerFunction("element", arguments -> {
            if (arguments.size() > 0) {
                if (arguments.get(0) instanceof List) {
                    List elements = (List)arguments.get(0);
                    Double val = (Double)arguments.get(1);
                    return elements.get(val.intValue());
                }
                return null;
            }
            return null;
        });
        parser.registerFunction("length", arguments -> {
            if (arguments.size() > 0) {
                if (arguments.get(0) instanceof List) {
                    List elements = (List)arguments.get(0);
                    return new Double(elements.size());
                }
                return null;
            }
            return null;
        });
        parser.registerFunction("index", arguments -> {
            if (arguments.size() > 0) {
                if (arguments.get(0) instanceof List) {
                    List elements = (List)arguments.get(0);
                    Object val = arguments.get(1);
                    return elements.indexOf(val);
                }
                return null;
            }
            return null;
        });
        parser.registerFunction("one", arguments -> {
            if (arguments.size() > 0) {
                if (arguments.get(0) instanceof List) {
                    List elements = (List)arguments.get(0);
                    if (elements.size() > 0) {
                        return elements.get(0);
                    }
                    return null;
                }
                return null;
            }
            return null;
        });
        parser.registerFunction("lookup", arguments -> {
            if (arguments.size() > 0) {
                if (arguments.get(0) instanceof Map) {
                    String key;
                    Map elements = (Map)arguments.get(0);
                    Object value = elements.get(key = (String)arguments.get(1));
                    if (value == null && arguments.size() > 2) {
                        value = arguments.get(2);
                    }
                    return value;
                }
                return null;
            }
            return null;
        });
    }

    static void registerDateFunctions(HCLParser parser) {
        parser.registerFunction("timestamp", arguments -> new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").format(new Date()));
    }

    static void registerCastingFunctions(HCLParser parser) {
        parser.registerFunction("jsonencode", arguments -> {
            if (arguments.size() > 0) {
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(arguments.get(0));
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            }
            return null;
        });
        parser.registerFunction("jsondecode", arguments -> {
            if (arguments.size() > 0 && arguments.get(0) instanceof String) {
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    String val = (String)arguments.get(0);
                    JsonNode node = objectMapper.readTree(val);
                    if (node.getNodeType() == JsonNodeType.OBJECT) {
                        Map result = (Map)objectMapper.convertValue((Object)node, (TypeReference)new TypeReference<Map<String, Object>>(){});
                        return result;
                    }
                    if (node.getNodeType() == JsonNodeType.ARRAY) {
                        ArrayList result = (ArrayList)objectMapper.convertValue((Object)node, (TypeReference)new TypeReference<ArrayList<Object>>(){});
                        return result;
                    }
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            }
            return null;
        });
        parser.registerFunction("base64encode", arguments -> {
            String content;
            if (arguments.size() > 0 && (content = (String)arguments.get(0)) != null) {
                return Base64.getEncoder().encodeToString(content.getBytes(StandardCharsets.UTF_8));
            }
            return null;
        });
        parser.registerFunction("base64decode", arguments -> {
            String content;
            if (arguments.size() > 0 && (content = (String)arguments.get(0)) != null) {
                byte[] decodedBytes = Base64.getDecoder().decode(content);
                return new String(decodedBytes, StandardCharsets.UTF_8);
            }
            return null;
        });
        parser.registerFunction("textencodebase64", arguments -> {
            if (arguments.size() > 1) {
                String content = (String)arguments.get(0);
                String encoding = (String)arguments.get(1);
                if (content != null) {
                    return Base64.getEncoder().encodeToString(content.getBytes(Charset.forName(encoding)));
                }
            }
            return null;
        });
        parser.registerFunction("textdecodebase64", arguments -> {
            String content;
            if (arguments.size() > 1 && (content = (String)arguments.get(0)) != null) {
                String encoding = (String)arguments.get(1);
                byte[] decodedBytes = Base64.getDecoder().decode(content);
                return new String(decodedBytes, Charset.forName(encoding));
            }
            return null;
        });
    }
}

