/*
 * Decompiled with CFR 0.152.
 */
package com.bertramlabs.plugins.hcl4j;

import com.bertramlabs.plugins.hcl4j.HCLBaseFunctions;
import com.bertramlabs.plugins.hcl4j.HCLFunction;
import com.bertramlabs.plugins.hcl4j.HCLLexer;
import com.bertramlabs.plugins.hcl4j.HCLParserException;
import com.bertramlabs.plugins.hcl4j.RuntimeSymbols.ComputedObject;
import com.bertramlabs.plugins.hcl4j.RuntimeSymbols.ComputedTuple;
import com.bertramlabs.plugins.hcl4j.RuntimeSymbols.EvalSymbol;
import com.bertramlabs.plugins.hcl4j.RuntimeSymbols.Function;
import com.bertramlabs.plugins.hcl4j.RuntimeSymbols.GroupedExpression;
import com.bertramlabs.plugins.hcl4j.RuntimeSymbols.Operator;
import com.bertramlabs.plugins.hcl4j.RuntimeSymbols.PrimitiveType;
import com.bertramlabs.plugins.hcl4j.RuntimeSymbols.StringInterpolatedExpression;
import com.bertramlabs.plugins.hcl4j.RuntimeSymbols.Variable;
import com.bertramlabs.plugins.hcl4j.RuntimeSymbols.VariableTree;
import com.bertramlabs.plugins.hcl4j.symbols.HCLArray;
import com.bertramlabs.plugins.hcl4j.symbols.HCLAttribute;
import com.bertramlabs.plugins.hcl4j.symbols.HCLBlock;
import com.bertramlabs.plugins.hcl4j.symbols.HCLMap;
import com.bertramlabs.plugins.hcl4j.symbols.HCLValue;
import com.bertramlabs.plugins.hcl4j.symbols.Symbol;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HCLParser {
    static Logger log = LoggerFactory.getLogger(HCLParser.class);
    protected Map<String, Object> result = new LinkedHashMap<String, Object>();
    protected Map<String, Object> variables = new LinkedHashMap<String, Object>();
    protected Map<String, HCLFunction> functionRegistry = new LinkedHashMap<String, HCLFunction>();

    public HCLParser() {
        HCLBaseFunctions.registerBaseFunctions(this);
    }

    public Map<String, Object> parseVars(String input, Boolean ignoreParseException) throws HCLParserException, IOException {
        HCLParser varLoader = new HCLParser();
        Map<String, Object> results = varLoader.parse(input, ignoreParseException);
        for (String key : results.keySet()) {
            this.variables.put(key, results.get(key));
        }
        return this.variables;
    }

    public void registerFunction(String functionName, HCLFunction function) {
        this.functionRegistry.put(functionName, function);
    }

    public void setVariable(String variableName, Object value) {
        this.variables.put(variableName, value);
    }

    public void setVariables(Map<String, Object> variableMap) {
        for (String key : variableMap.keySet()) {
            this.variables.put(key, variableMap.get(key));
        }
    }

    public Map<String, Object> parse(String input) throws HCLParserException, IOException {
        return this.parse(input, (Boolean)false);
    }

    public Map<String, Object> parse(String input, Boolean ignoreParserExceptions) throws HCLParserException, IOException {
        StringReader reader = new StringReader(input);
        return this.parse(reader, ignoreParserExceptions);
    }

    public Map<String, Object> parse(File input, Boolean ignoreParserExceptions) throws HCLParserException, IOException, UnsupportedEncodingException {
        return this.parse(input, "UTF-8", ignoreParserExceptions);
    }

    public Map<String, Object> parse(File input) throws HCLParserException, IOException, UnsupportedEncodingException {
        return this.parse(input, "UTF-8", (Boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> parse(File input, Charset cs) throws HCLParserException, IOException {
        try (FileInputStream is = null;){
            is = new FileInputStream(input);
            Map<String, Object> map = this.parse((InputStream)is, cs);
            return map;
        }
    }

    public Map<String, Object> parse(File input, String charsetName) throws HCLParserException, IOException {
        return this.parse(input, charsetName, (Boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> parse(File input, String charsetName, Boolean ignoreParserExceptions) throws HCLParserException, IOException {
        try (FileInputStream is = null;){
            is = new FileInputStream(input);
            Map<String, Object> map = this.parse(is, charsetName, ignoreParserExceptions);
            return map;
        }
    }

    public Map<String, Object> parse(InputStream input) throws HCLParserException, IOException {
        return this.parse(input, "UTF-8");
    }

    public Map<String, Object> parse(InputStream input, Charset cs) throws HCLParserException, IOException {
        InputStreamReader reader = cs != null ? new InputStreamReader(input, cs) : new InputStreamReader(input, "UTF-8");
        return this.parse(reader);
    }

    public Map<String, Object> parse(InputStream input, String charsetName) throws HCLParserException, IOException, UnsupportedEncodingException {
        return this.parse(input, charsetName, (Boolean)false);
    }

    public Map<String, Object> parse(InputStream input, String charsetName, Boolean ignoreParserExceptions) throws HCLParserException, IOException, UnsupportedEncodingException {
        InputStreamReader reader = charsetName != null ? new InputStreamReader(input, charsetName) : new InputStreamReader(input, "UTF-8");
        return this.parse(reader, ignoreParserExceptions);
    }

    public Map<String, Object> parse(Reader reader) throws HCLParserException, IOException {
        return this.parse(reader, (Boolean)false);
    }

    public Map<String, Object> parse(Reader reader, Boolean ignoreParserExceptions) throws HCLParserException, IOException {
        block4: {
            HCLLexer lexer = new HCLLexer(reader);
            try {
                lexer.yylex();
                ArrayList<Symbol> rootBlocks = lexer.elementStack;
                Map<String, Object> mapPosition = this.result = new LinkedHashMap<String, Object>();
                for (Symbol currentElement : rootBlocks) {
                    this.processSymbolPass1(currentElement, mapPosition);
                }
                for (String key : this.result.keySet()) {
                    this.processSymbolPass2(this.result.get(key), this.result);
                }
            }
            catch (Exception ex) {
                log.error("Error Parsing HCL...{}", (Object)ex.getMessage(), (Object)ex);
                if (ignoreParserExceptions.booleanValue()) break block4;
                throw new RuntimeException(ex);
            }
        }
        return this.result;
    }

    private Object processSymbolPass1(Symbol symbol, Map<String, Object> mapPosition) throws HCLParserException {
        if (symbol instanceof HCLBlock) {
            HCLBlock block = (HCLBlock)symbol;
            for (int counter = 0; counter < block.blockNames.size(); ++counter) {
                String blockName = block.blockNames.get(counter);
                if (mapPosition.containsKey(blockName)) {
                    if (counter == block.blockNames.size() - 1 && mapPosition.get(blockName) instanceof Map) {
                        ArrayList<Map> objectList = new ArrayList<Map>();
                        LinkedHashMap addedObject = new LinkedHashMap();
                        objectList.add((Map)mapPosition.get(blockName));
                        objectList.add(addedObject);
                        mapPosition.put(blockName, (LinkedHashMap<String, Object>)((Object)objectList));
                        mapPosition = addedObject;
                        continue;
                    }
                    if (mapPosition.get(blockName) instanceof Map) {
                        mapPosition = (Map)mapPosition.get(blockName);
                        continue;
                    }
                    if (counter == block.blockNames.size() - 1 && mapPosition.get(blockName) instanceof List) {
                        LinkedHashMap<String, LinkedHashMap<String, Object>> addedObject = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
                        ((List)mapPosition.get(blockName)).add(addedObject);
                        mapPosition = addedObject;
                        continue;
                    }
                    if (mapPosition.get(blockName) instanceof List) {
                        throw new HCLParserException("HCL Block expression scope traverses an object array");
                    }
                    throw new HCLParserException("HCL Block expression scope traverses an object value");
                }
                mapPosition.put(blockName, new LinkedHashMap());
                mapPosition = (LinkedHashMap<String, LinkedHashMap<String, Object>>)mapPosition.get(blockName);
            }
            if (symbol.getChildren() != null) {
                for (Symbol child : block.getChildren()) {
                    this.processSymbolPass1(child, mapPosition);
                }
            }
            return mapPosition;
        }
        if (symbol instanceof HCLMap) {
            LinkedHashMap<String, Object> nestedMap = new LinkedHashMap<String, Object>();
            if (symbol.getChildren() != null) {
                for (Symbol child : symbol.getChildren()) {
                    this.processSymbolPass1(child, nestedMap);
                }
            }
            return nestedMap;
        }
        if (symbol instanceof HCLArray) {
            if (symbol.getChildren() != null) {
                ArrayList<Object> objectList = new ArrayList<Object>();
                for (Symbol child : symbol.getChildren()) {
                    LinkedHashMap<String, Object> nestedMap = new LinkedHashMap<String, Object>();
                    Object result = this.processSymbolPass1(child, nestedMap);
                    objectList.add(result);
                }
                return objectList;
            }
            return null;
        }
        if (symbol instanceof HCLValue) {
            return this.processValue((HCLValue)symbol);
        }
        if (symbol instanceof PrimitiveType) {
            return symbol;
        }
        if (symbol instanceof EvalSymbol) {
            return this.processEvaluation((EvalSymbol)symbol, null);
        }
        if (symbol instanceof HCLAttribute) {
            String symName = symbol.getName();
            if (symName == null && ((HCLAttribute)symbol).runtimeName != null) {
                LinkedHashMap<String, Object> nestedMap = new LinkedHashMap<String, Object>();
                symName = (String)this.processSymbolPass2(((HCLAttribute)symbol).runtimeName, nestedMap);
            }
            if (symbol.getChildren().size() == 1 && symbol.getChildren().get(0) instanceof HCLBlock) {
                Object results = null;
                LinkedHashMap<String, Object> nestedMap = new LinkedHashMap<String, Object>();
                results = this.processSymbolPass1(symbol.getChildren().get(0), nestedMap);
                mapPosition.put(symName, (LinkedHashMap<String, Object>)results);
            } else {
                mapPosition.put(symName, (LinkedHashMap<String, Object>)((Object)symbol));
            }
            return mapPosition;
        }
        return null;
    }

    private Object processSymbolPass2(Object val, Map<String, Object> mapPosition) throws HCLParserException {
        if (val instanceof Map) {
            Map subMap = (Map)val;
            for (String key : subMap.keySet()) {
                this.processSymbolPass2(subMap.get(key), subMap);
            }
        } else if (val instanceof ArrayList) {
            ArrayList currentCollection = (ArrayList)val;
            for (int x = 0; x < currentCollection.size(); ++x) {
                Object obj = currentCollection.get(x);
                Object res = this.processSymbolPass2(obj, mapPosition);
                if (res == null) continue;
                currentCollection.set(x, res);
            }
        } else {
            if (val instanceof HCLMap) {
                HCLMap symbol = (HCLMap)val;
                LinkedHashMap<String, Object> nestedMap = new LinkedHashMap<String, Object>();
                if (symbol.getChildren() != null) {
                    for (Symbol child : symbol.getChildren()) {
                        this.processSymbolPass2(child, nestedMap);
                    }
                }
                return nestedMap;
            }
            if (val instanceof HCLBlock) {
                HCLBlock symbol = (HCLBlock)val;
                LinkedHashMap<String, Object> nestedMap = new LinkedHashMap<String, Object>();
                if (symbol.getChildren() != null) {
                    for (Symbol child : symbol.getChildren()) {
                        this.processSymbolPass2(child, nestedMap);
                    }
                }
                return nestedMap;
            }
            if (val instanceof HCLArray) {
                HCLArray symbol = (HCLArray)val;
                if (symbol.getChildren() != null) {
                    ArrayList<Object> objectList = new ArrayList<Object>();
                    for (Symbol child : symbol.getChildren()) {
                        LinkedHashMap<String, Object> nestedMap = new LinkedHashMap<String, Object>();
                        Object result = this.processSymbolPass2(child, nestedMap);
                        objectList.add(result);
                    }
                    return objectList;
                }
                return null;
            }
            if (val instanceof HCLValue) {
                return this.processValue((HCLValue)val);
            }
            if (val instanceof PrimitiveType) {
                return val;
            }
            if (val instanceof EvalSymbol) {
                return this.processEvaluation((EvalSymbol)val, null);
            }
            if (val instanceof HCLAttribute || val instanceof GroupedExpression || val instanceof StringInterpolatedExpression) {
                Symbol symbol = (Symbol)val;
                LinkedHashMap<String, Object> nestedMap = new LinkedHashMap<String, Object>();
                if (symbol.getChildren().size() > 0) {
                    Object results = null;
                    block40: for (int x = 0; x < symbol.getChildren().size(); ++x) {
                        Symbol child = symbol.getChildren().get(x);
                        if (child instanceof Operator) {
                            switch (child.getName()) {
                                case "&&": 
                                case "||": {
                                    GroupedExpression groupedConditional = new GroupedExpression(null, null, null);
                                    Symbol nextConditionalElement = symbol.getChildren().get(++x);
                                    groupedConditional.appendChild(nextConditionalElement);
                                    while (x < symbol.getChildren().size() - 1) {
                                        nextConditionalElement = symbol.getChildren().get(++x);
                                        if (!(nextConditionalElement.getName().equals("&&") || nextConditionalElement.getName().equals("||") || nextConditionalElement.getName().equals("?") || nextConditionalElement.equals(":"))) {
                                            groupedConditional.appendChild(nextConditionalElement);
                                            continue;
                                        }
                                        --x;
                                        break;
                                    }
                                    Object andResult = this.processSymbolPass2(groupedConditional, nestedMap);
                                    if (child.getName().equals("||")) {
                                        if (results instanceof Boolean && (Boolean)results != false || !(results instanceof Boolean) && results != null || andResult instanceof Boolean && (Boolean)andResult != false || !(andResult instanceof Boolean) && andResult != null) {
                                            results = true;
                                            break;
                                        }
                                        results = false;
                                        break;
                                    }
                                    if ((results instanceof Boolean && ((Boolean)results).booleanValue() || !(results instanceof Boolean) && results != null) && (andResult instanceof Boolean && ((Boolean)andResult).booleanValue() || !(andResult instanceof Boolean) && andResult != null)) {
                                        results = true;
                                        break;
                                    }
                                    results = false;
                                    break;
                                }
                                case "?": {
                                    if ((!(results instanceof Boolean) || ((Boolean)results).booleanValue()) && results != null) break;
                                    Symbol nextElement = symbol.getChildren().get(++x);
                                    while (!(nextElement instanceof Operator) && nextElement.getName() != ":") {
                                        nextElement = symbol.getChildren().get(++x);
                                    }
                                    continue block40;
                                }
                                case ":": {
                                    x = symbol.getChildren().size();
                                    break;
                                }
                                case "==": {
                                    Object compareResult = this.processSymbolPass2(symbol.getChildren().get(++x), nestedMap);
                                    if (compareResult == results || compareResult != null && compareResult.equals(results)) {
                                        results = true;
                                        break;
                                    }
                                    results = false;
                                    break;
                                }
                                case ">": {
                                    if (!(results instanceof Double)) break;
                                    Object rightResult = this.processSymbolPass2(symbol.getChildren().get(++x), nestedMap);
                                    if (rightResult == null || !(rightResult instanceof Double)) continue block40;
                                    results = (Double)results > (Double)rightResult;
                                    break;
                                }
                                case ">=": {
                                    if (!(results instanceof Double)) break;
                                    Object rightResult = this.processSymbolPass2(symbol.getChildren().get(++x), nestedMap);
                                    if (rightResult == null || !(rightResult instanceof Double)) continue block40;
                                    results = (Double)results >= (Double)rightResult;
                                    break;
                                }
                                case "<": {
                                    if (!(results instanceof Double)) break;
                                    Object rightResult = this.processSymbolPass2(symbol.getChildren().get(++x), nestedMap);
                                    if (rightResult == null || !(rightResult instanceof Double)) continue block40;
                                    results = (Double)results < (Double)rightResult;
                                    break;
                                }
                                case "<=": {
                                    if (!(results instanceof Double)) break;
                                    Object rightResult = this.processSymbolPass2(symbol.getChildren().get(++x), nestedMap);
                                    if (rightResult == null || !(rightResult instanceof Double)) continue block40;
                                    results = (Double)results <= (Double)rightResult;
                                    break;
                                }
                                case "!=": {
                                    Object compareResult2 = this.processSymbolPass2(symbol.getChildren().get(++x), nestedMap);
                                    if (!(compareResult2 == results || compareResult2 != null && compareResult2.equals(results))) {
                                        results = true;
                                        break;
                                    }
                                    results = false;
                                    break;
                                }
                                case "!": {
                                    Object notResult = this.processSymbolPass2(symbol.getChildren().get(++x), nestedMap);
                                    if (notResult == null || notResult.equals(false)) {
                                        results = true;
                                        break;
                                    }
                                    results = false;
                                    break;
                                }
                                case "+": {
                                    Object rightResult;
                                    if (results instanceof String) {
                                        rightResult = this.processSymbolPass2(symbol.getChildren().get(++x), nestedMap);
                                        if (rightResult == null) continue block40;
                                        results = (String)results + rightResult.toString();
                                        break;
                                    }
                                    if (results instanceof Double) {
                                        rightResult = this.processSymbolPass2(symbol.getChildren().get(++x), nestedMap);
                                        if (rightResult == null || !(rightResult instanceof Double)) continue block40;
                                        results = (Double)results + (Double)rightResult;
                                        break;
                                    }
                                    if (results != null) break;
                                    results = this.processSymbolPass2(symbol.getChildren().get(++x), nestedMap);
                                    break;
                                }
                                case "-": {
                                    Object rightResult;
                                    if (results instanceof Double) {
                                        rightResult = this.processSymbolPass2(symbol.getChildren().get(++x), nestedMap);
                                        if (rightResult == null || !(rightResult instanceof Double)) continue block40;
                                        results = (Double)results - (Double)rightResult;
                                        break;
                                    }
                                    if (results != null) break;
                                    rightResult = this.processSymbolPass2(symbol.getChildren().get(++x), nestedMap);
                                    if (rightResult == null || !(rightResult instanceof Double)) continue block40;
                                    results = -((Double)rightResult).doubleValue();
                                    break;
                                }
                                case "/": {
                                    if (!(results instanceof Double)) break;
                                    Object rightResult = this.processSymbolPass2(symbol.getChildren().get(++x), nestedMap);
                                    if (rightResult == null || !(rightResult instanceof Double)) continue block40;
                                    results = (Double)results / (Double)rightResult;
                                    break;
                                }
                                case "%": {
                                    if (!(results instanceof Double)) break;
                                    Object rightResult = this.processSymbolPass2(symbol.getChildren().get(++x), nestedMap);
                                    if (rightResult == null || !(rightResult instanceof Double)) continue block40;
                                    results = (Double)results % (Double)rightResult;
                                    break;
                                }
                                case "*": {
                                    Object rightResult;
                                    if (!(results instanceof Double) || (rightResult = this.processSymbolPass2(symbol.getChildren().get(++x), nestedMap)) == null || !(rightResult instanceof Double)) break;
                                    results = (Double)results * (Double)rightResult;
                                }
                            }
                            continue;
                        }
                        results = this.processSymbolPass2(child, nestedMap);
                    }
                    if (symbol instanceof GroupedExpression || symbol instanceof StringInterpolatedExpression) {
                        return results;
                    }
                    mapPosition.put(symbol.getName(), results);
                } else {
                    if (symbol instanceof GroupedExpression || symbol instanceof StringInterpolatedExpression) {
                        return null;
                    }
                    mapPosition.put(symbol.getName(), null);
                }
                return mapPosition;
            }
        }
        return null;
    }

    private Object processSymbol(Symbol symbol, Map<String, Object> mapPosition) throws HCLParserException {
        if (symbol instanceof HCLBlock) {
            HCLBlock block = (HCLBlock)symbol;
            for (int counter = 0; counter < block.blockNames.size(); ++counter) {
                String blockName = block.blockNames.get(counter);
                if (mapPosition.containsKey(blockName)) {
                    if (counter == block.blockNames.size() - 1 && mapPosition.get(blockName) instanceof Map) {
                        ArrayList<Map> objectList = new ArrayList<Map>();
                        LinkedHashMap addedObject = new LinkedHashMap();
                        objectList.add((Map)mapPosition.get(blockName));
                        objectList.add(addedObject);
                        mapPosition.put(blockName, (LinkedHashMap<String, Object>)((Object)objectList));
                        mapPosition = addedObject;
                        continue;
                    }
                    if (mapPosition.get(blockName) instanceof Map) {
                        mapPosition = (Map)mapPosition.get(blockName);
                        continue;
                    }
                    if (counter == block.blockNames.size() - 1 && mapPosition.get(blockName) instanceof List) {
                        LinkedHashMap<String, LinkedHashMap<String, Object>> addedObject = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
                        ((List)mapPosition.get(blockName)).add(addedObject);
                        mapPosition = addedObject;
                        continue;
                    }
                    if (mapPosition.get(blockName) instanceof List) {
                        throw new HCLParserException("HCL Block expression scope traverses an object array");
                    }
                    throw new HCLParserException("HCL Block expression scope traverses an object value");
                }
                mapPosition.put(blockName, new LinkedHashMap());
                mapPosition = (LinkedHashMap<String, LinkedHashMap<String, Object>>)mapPosition.get(blockName);
            }
            if (symbol.getChildren() != null) {
                for (Symbol child : block.getChildren()) {
                    this.processSymbol(child, mapPosition);
                }
            }
            return mapPosition;
        }
        if (symbol instanceof HCLMap) {
            LinkedHashMap<String, Object> nestedMap = new LinkedHashMap<String, Object>();
            if (symbol.getChildren() != null) {
                for (Symbol child : symbol.getChildren()) {
                    this.processSymbol(child, nestedMap);
                }
            }
            return nestedMap;
        }
        if (symbol instanceof HCLArray) {
            if (symbol.getChildren() != null) {
                ArrayList<Object> objectList = new ArrayList<Object>();
                for (Symbol child : symbol.getChildren()) {
                    LinkedHashMap<String, Object> nestedMap = new LinkedHashMap<String, Object>();
                    Object result = this.processSymbol(child, nestedMap);
                    objectList.add(result);
                }
                return objectList;
            }
            return null;
        }
        if (symbol instanceof HCLValue) {
            return this.processValue((HCLValue)symbol);
        }
        if (symbol instanceof PrimitiveType) {
            return symbol;
        }
        if (symbol instanceof EvalSymbol) {
            return this.processEvaluation((EvalSymbol)symbol, null);
        }
        if (symbol instanceof HCLAttribute || symbol instanceof GroupedExpression) {
            LinkedHashMap<String, Object> nestedMap = new LinkedHashMap<String, Object>();
            if (symbol.getChildren().size() > 0) {
                Object results = null;
                block16: for (int x = 0; x < symbol.getChildren().size(); ++x) {
                    Symbol child = symbol.getChildren().get(x);
                    if (child instanceof Operator) {
                        switch (child.getName()) {
                            case "+": {
                                Object rightResult;
                                if (results instanceof String) {
                                    rightResult = this.processSymbol(symbol.getChildren().get(++x), nestedMap);
                                    if (rightResult == null) continue block16;
                                    results = (String)results + rightResult.toString();
                                    break;
                                }
                                if (!(results instanceof Double)) break;
                                rightResult = this.processSymbol(symbol.getChildren().get(++x), nestedMap);
                                if (rightResult == null || !(rightResult instanceof Double)) continue block16;
                                results = (Double)results + (Double)rightResult;
                                break;
                            }
                            case "-": {
                                if (!(results instanceof Double)) break;
                                Object rightResult = this.processSymbol(symbol.getChildren().get(++x), nestedMap);
                                if (rightResult == null || !(rightResult instanceof Double)) continue block16;
                                results = (Double)results - (Double)rightResult;
                                break;
                            }
                            case "/": {
                                if (!(results instanceof Double)) break;
                                Object rightResult = this.processSymbol(symbol.getChildren().get(++x), nestedMap);
                                if (rightResult == null || !(rightResult instanceof Double)) continue block16;
                                results = (Double)results / (Double)rightResult;
                                break;
                            }
                            case "*": {
                                Object rightResult;
                                if (!(results instanceof Double) || (rightResult = this.processSymbol(symbol.getChildren().get(++x), nestedMap)) == null || !(rightResult instanceof Double)) break;
                                results = (Double)results * (Double)rightResult;
                            }
                        }
                        continue;
                    }
                    results = this.processSymbol(symbol.getChildren().get(0), nestedMap);
                }
                if (symbol instanceof GroupedExpression) {
                    return results;
                }
                mapPosition.put(symbol.getName(), (LinkedHashMap<String, Object>)results);
            } else {
                if (symbol instanceof GroupedExpression) {
                    return null;
                }
                mapPosition.put(symbol.getName(), null);
            }
            return mapPosition;
        }
        return null;
    }

    protected Object processValue(HCLValue value) throws HCLParserException {
        if (value.type.equals("string")) {
            return value.value;
        }
        if (value.type.equals("boolean")) {
            if (value.value.equals("true")) {
                return new Boolean(true);
            }
            return new Boolean(false);
        }
        if (value.type.equals("null")) {
            return null;
        }
        if (value.type.equals("number")) {
            try {
                Double numericalValue = Double.parseDouble((String)value.value);
                return numericalValue;
            }
            catch (NumberFormatException ex) {
                throw new HCLParserException("Error Parsing Numerical Value in HCL Attribute ", ex);
            }
        }
        throw new HCLParserException("HCL Attribute value not recognized by parser (not implemented yet).");
    }

    protected Object evaluateFunctionCall(String functionName, Function functionSymbol) throws HCLParserException {
        if (this.functionRegistry.get(functionName) != null) {
            HCLFunction functionMethod = this.functionRegistry.get(functionName);
            ArrayList<Object> functionArguments = new ArrayList<Object>();
            for (Symbol child : functionSymbol.getChildren()) {
                Object elementResult = null;
                if (child instanceof EvalSymbol) {
                    elementResult = this.processEvaluation((EvalSymbol)child, null);
                } else if (child instanceof Symbol) {
                    elementResult = this.processSymbol(child, this.result);
                }
                if (elementResult instanceof VariableTree) {
                    return null;
                }
                functionArguments.add(elementResult);
            }
            return functionMethod.method(functionArguments);
        }
        return null;
    }

    protected Object processEvaluation(EvalSymbol evalSymbol, Object context) throws HCLParserException {
        Boolean variableLookup = false;
        if (evalSymbol instanceof VariableTree) {
            for (int x = 0; x < evalSymbol.getChildren().size(); ++x) {
                Symbol child = evalSymbol.getChildren().get(x);
                if (child instanceof Variable && evalSymbol.getChildren().size() > x + 1 && evalSymbol.getChildren().get(x + 1) instanceof Function) {
                    return this.evaluateFunctionCall(child.getName(), (Function)evalSymbol.getChildren().get(x + 1));
                }
                if (child instanceof Variable) {
                    if (context == null && x == 0) {
                        switch (child.getName()) {
                            case "local": {
                                context = this.flattenContext(this.result.get("locals"));
                                break;
                            }
                            case "var": {
                                variableLookup = true;
                                context = this.variables;
                                break;
                            }
                            default: {
                                context = this.result.get(child.getName());
                                break;
                            }
                        }
                        continue;
                    }
                    if (context == null) continue;
                    context = ((Map)context).get(child.getName());
                    if (!variableLookup.booleanValue() || context != null || this.result.get("variable") == null || !(this.result.get("variable") instanceof Map)) continue;
                    Map variableDefinitions = (Map)this.result.get("variable");
                    if (variableDefinitions.get(child.getName()) instanceof Map) {
                        Map varDefinition = (Map)variableDefinitions.get(child.getName());
                        if (varDefinition != null) {
                            return varDefinition.get("default");
                        }
                        return null;
                    }
                    return variableDefinitions.get(child.getName());
                }
                if (!(child instanceof HCLArray)) continue;
                Symbol firstElement = child.getChildren().get(0);
                Object elementResult = null;
                if (firstElement instanceof EvalSymbol) {
                    elementResult = this.processEvaluation((EvalSymbol)firstElement, null);
                } else if (firstElement instanceof HCLValue) {
                    elementResult = this.processValue((HCLValue)firstElement);
                }
                if (elementResult != null && elementResult instanceof String && context != null) {
                    context = ((Map)context).get(elementResult);
                    if (!variableLookup.booleanValue() || context != null || this.result.get("variable") == null || !(this.result.get("variable") instanceof Map)) continue;
                    Map variableDefinitions = (Map)this.result.get("variable");
                    if (variableDefinitions.get(elementResult) instanceof Map) {
                        Map varDefinition = (Map)variableDefinitions.get(elementResult);
                        if (varDefinition != null) {
                            return varDefinition.get("default");
                        }
                        return null;
                    }
                    return variableDefinitions.get(elementResult);
                }
                if (elementResult != null && elementResult instanceof Double && context != null) {
                    Double elementDouble = (Double)elementResult;
                    if (context instanceof Map) {
                        context = ((Map)context).get(elementDouble.intValue());
                        continue;
                    }
                    context = ((List)context).get(elementDouble.intValue());
                    continue;
                }
                context = null;
            }
            if (context != null) {
                if (context instanceof HCLAttribute) {
                    LinkedHashMap<String, Object> nestedMap = new LinkedHashMap<String, Object>();
                    context = this.processSymbolPass2(context, nestedMap);
                    for (String key : nestedMap.keySet()) {
                        context = nestedMap.get(key);
                    }
                }
                return context;
            }
            return evalSymbol;
        }
        if (evalSymbol instanceof Function) {
            Function thisFunction = (Function)evalSymbol;
            if (thisFunction.getName() != null && thisFunction.getName().length() > 0) {
                return this.evaluateFunctionCall(thisFunction.getName(), thisFunction);
            }
            return null;
        }
        if (evalSymbol instanceof Variable || evalSymbol instanceof ComputedTuple || evalSymbol instanceof ComputedObject) {
            return evalSymbol;
        }
        return null;
    }

    protected Object flattenContext(Object context) {
        if (context == null) {
            return null;
        }
        if (context instanceof Collection) {
            LinkedHashMap contextMap = new LinkedHashMap();
            for (Object contextObj : (Collection)context) {
                if (!(contextObj instanceof Map)) continue;
                Map currentContextMap = (Map)contextObj;
                for (String key : currentContextMap.keySet()) {
                    contextMap.put(key, currentContextMap.get(key));
                }
            }
            return contextMap;
        }
        return context;
    }

    protected Object evaluateEvalSymbol(EvalSymbol evalSymbol) {
        if (evalSymbol instanceof Variable) {
            return this.evaluateVariable((Variable)evalSymbol);
        }
        if (evalSymbol instanceof Function) {
            return null;
        }
        if (evalSymbol instanceof ComputedTuple) {
            return null;
        }
        return null;
    }

    protected Object evaluateVariable(Variable var) {
        String[] variableArguments = var.getName().split("\\.");
        Object currentVariableObject = null;
        for (int x = 0; x < variableArguments.length; ++x) {
            String variableElement;
            if (currentVariableObject == null && x > 0) {
                return null;
            }
            String varName = variableElement = variableArguments[x];
            Boolean accessElement = false;
            if (variableElement.indexOf("[") > -1) {
                varName = variableElement.substring(0, variableElement.indexOf("["));
                accessElement = true;
            }
            currentVariableObject = this.getVariableObject(varName, currentVariableObject);
        }
        return currentVariableObject;
    }

    protected Object getVariableObject(String varName, Object source) {
        if (source != null && source instanceof Map) {
            return ((Map)source).get(varName);
        }
        switch (varName) {
            case "local": {
                if (this.result.get("locals") != null) {
                    Map localVariables = (Map)this.result.get("locals");
                    return localVariables.get(varName);
                }
                return null;
            }
            case "var": {
                if (this.result.get("variable") != null) {
                    Map variableEntries = (Map)this.result.get("variable");
                    return variableEntries.get(varName);
                }
                return null;
            }
        }
        return this.result.get(varName);
    }
}

