/*
 * Decompiled with CFR 0.152.
 */
package com.bertramlabs.plugins.hcl4j.utils;

import com.bertramlabs.plugins.hcl4j.utils.ServiceResponse;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.ParseException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Lookup;
import org.apache.http.config.MessageConstraints;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpConnectionFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.DefaultHttpResponseParser;
import org.apache.http.impl.conn.DefaultHttpResponseParserFactory;
import org.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.io.DefaultHttpRequestWriterFactory;
import org.apache.http.io.HttpMessageParser;
import org.apache.http.io.HttpMessageParserFactory;
import org.apache.http.io.HttpMessageWriterFactory;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicLineParser;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.LineParser;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpApiClient {
    HttpClient httpClient;
    HttpClientConnectionManager connectionManager;
    BasicCookieStore cookieStore = new BasicCookieStore();
    public Long throttleRate = 0L;
    private Date lastCallTime;
    static Logger log = LoggerFactory.getLogger(HttpApiClient.class);
    static final Integer WEB_CONNECTION_TIMEOUT = 120000;

    public ServiceResponse callApi(String url, String path, String username, String password) throws URISyntaxException, Exception {
        return this.callApi(url, path, username, password, new RequestOptions(), "POST");
    }

    public ServiceResponse callApi(String url, String path, String username, String password, RequestOptions opts) throws URISyntaxException, Exception {
        return this.callApi(url, path, username, password, opts, "POST");
    }

    private void sleepIfNecessary() {
        try {
            Long tmpThrottleRate = this.throttleRate;
            if (tmpThrottleRate != null && tmpThrottleRate > 0L) {
                if (this.lastCallTime != null) {
                    Date now = new Date();
                    Long timeDiff = now.getTime() - this.lastCallTime.getTime();
                    if ((tmpThrottleRate = Long.valueOf(tmpThrottleRate - timeDiff)) > 0L) {
                        Thread.sleep(tmpThrottleRate);
                    }
                } else {
                    Thread.sleep(tmpThrottleRate);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public ServiceResponse callApi(String url, String path, String username, String password, RequestOptions opts, String method) throws URISyntaxException, Exception {
        ServiceResponse rtn = new ServiceResponse();
        LinkedHashMap data = new LinkedHashMap();
        rtn.setData(data);
        URIBuilder uriBuilder = new URIBuilder(url);
        try {
            HttpHead request;
            this.sleepIfNecessary();
            this.lastCallTime = new Date();
            String existingPath = uriBuilder.getPath();
            String newPath = path;
            if (path != null && path.length() > 0) {
                if (existingPath != null && existingPath.length() > 0 && !path.startsWith(existingPath)) {
                    if (existingPath.endsWith("/") && path.startsWith("/")) {
                        existingPath = existingPath.substring(0, existingPath.length() - 1);
                    } else if (!existingPath.endsWith("/") && !path.startsWith("/")) {
                        existingPath = existingPath + "/";
                    }
                    newPath = existingPath + path;
                }
                uriBuilder.setPath(newPath);
            }
            if (opts.queryParams != null && !opts.queryParams.isEmpty()) {
                for (CharSequence queryKey : opts.queryParams.keySet()) {
                    uriBuilder.addParameter(queryKey.toString(), opts.queryParams.get(queryKey).toString());
                }
            }
            switch (method.toUpperCase()) {
                case "HEAD": {
                    request = new HttpHead(uriBuilder.build());
                    break;
                }
                case "PUT": {
                    request = new HttpPut(uriBuilder.build());
                    break;
                }
                case "POST": {
                    request = new HttpPost(uriBuilder.build());
                    break;
                }
                case "PATCH": {
                    request = new HttpPatch(uriBuilder.build());
                    break;
                }
                case "GET": {
                    request = new HttpGet(uriBuilder.build());
                    break;
                }
                case "DELETE": {
                    request = new HttpDelete(uriBuilder.build());
                    break;
                }
                default: {
                    throw new Exception("method was not specified");
                }
            }
            if (username != null && username.length() > 0 && password != null && password.length() > 0) {
                String creds = username + ":" + password;
                String credHeader = "Basic " + Base64.getEncoder().encodeToString(creds.getBytes());
                request.addHeader("Authorization", credHeader);
            }
            if (opts.apiToken != null) {
                int newLine = opts.apiToken.indexOf(10);
                if (newLine > -1) {
                    opts.apiToken = opts.apiToken.substring(0, newLine);
                }
                request.addHeader("Authorization", "Bearer " + opts.apiToken);
            }
            if (opts.headers == null || opts.headers.isEmpty() || !opts.headers.containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/json");
            }
            if (opts.headers != null && !opts.headers.isEmpty()) {
                for (CharSequence headerKey : opts.headers.keySet()) {
                    request.addHeader(headerKey.toString(), opts.headers.get(headerKey).toString());
                }
            }
            if (opts.body != null) {
                HttpEntityEnclosingRequestBase postRequest = (HttpEntityEnclosingRequestBase)request;
                if (opts.body instanceof Map) {
                    if (opts.contentType == "form") {
                        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
                        Map bodyMap = (Map)opts.body;
                        for (String key : bodyMap.keySet()) {
                            Object v = bodyMap.get(key);
                            Object rowValue = v instanceof CharSequence ? v : v.toString();
                            urlParameters.add(new BasicNameValuePair(key, rowValue.toString()));
                        }
                        postRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters));
                    } else if (opts.contentType == "multi-part-form") {
                        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
                        String rowBoundary = "--" + UUID.randomUUID().toString() + "--";
                        Map bodyMap = (Map)opts.body;
                        for (String key : bodyMap.keySet()) {
                            Object v = bodyMap.get(key);
                            if (v instanceof Collection) {
                                for (String rowValue : (Collection)v) {
                                    StringBody rowBody = new StringBody(rowValue.toString(), ContentType.create((String)"text/plain", (String)"UTF-8"));
                                    entityBuilder.addPart(key, (ContentBody)rowBody);
                                }
                                continue;
                            }
                            Object rowValue = v instanceof CharSequence ? v : v.toString();
                            StringBody rowBody = new StringBody(rowValue.toString(), ContentType.create((String)"text/plain", (String)"UTF-8"));
                            entityBuilder.addPart(key, (ContentBody)rowBody);
                        }
                        entityBuilder.setContentType(ContentType.MULTIPART_FORM_DATA);
                        entityBuilder.setBoundary(rowBoundary);
                        postRequest.setEntity(entityBuilder.build());
                        if (request.containsHeader("Content-Type")) {
                            Header currentType = request.getFirstHeader("Content-Type");
                            String newValue = currentType.getValue();
                            newValue = newValue + "; boundary=" + rowBoundary;
                            request.setHeader("Content-Type", newValue);
                        }
                    }
                } else if (opts.body instanceof byte[]) {
                    postRequest.setEntity((HttpEntity)new ByteArrayEntity((byte[])opts.body));
                } else if (opts.body instanceof InputStream) {
                    postRequest.setEntity((HttpEntity)new InputStreamEntity((InputStream)opts.body, opts.contentLength != null ? opts.contentLength : -1L));
                } else {
                    postRequest.setEntity((HttpEntity)new StringEntity(opts.body.toString()));
                }
            }
            this.withClient(opts, (arg_0, arg_1) -> this.lambda$callApi$0((HttpRequestBase)request, rtn, opts, url, path, uriBuilder, arg_0, arg_1));
        }
        catch (SSLProtocolException sslEx) {
            log.error("Error Occurred calling API (SSL Exception): {}", (Object)sslEx.getMessage(), (Object)sslEx);
            rtn.addError("sslHandshake", "SSL Handshake Exception (is SNI Misconfigured): " + sslEx.getMessage());
            rtn.setSuccess(false);
        }
        catch (Exception e) {
            log.error("Error Occurred calling API: " + e.getMessage(), (Throwable)e);
            rtn.addError("error", e.getMessage());
            rtn.setSuccess(false);
        }
        return rtn;
    }

    public Map<CharSequence, CharSequence> addRequiredHeader(Map<CharSequence, CharSequence> headers, String name, String value) {
        if (headers == null) {
            headers = new LinkedHashMap<CharSequence, CharSequence>();
        }
        headers.putIfAbsent(name, value);
        return headers;
    }

    Map<String, String> extractCookie(String rawCookie) {
        if (rawCookie == null || rawCookie.length() == 0) {
            return null;
        }
        String[] cookieArgs = rawCookie.split("=");
        String name = cookieArgs[0];
        String data = rawCookie.split(name + "=")[1].split(";")[0];
        String value = "";
        if (data != null && data.length() > 0) {
            value = data.substring(1, data.length() - 1);
        }
        LinkedHashMap<String, String> cookieMap = new LinkedHashMap<String, String>();
        cookieMap.put(name, value);
        return cookieMap;
    }

    private void withClient(final RequestOptions opts, WithClientFunction withClientFunction) {
        SSLConnectionSocketFactory sslConnectionFactory;
        Boolean ignoreSSL = opts.ignoreSSL;
        if (this.httpClient != null) {
            withClientFunction.method(this.httpClient, this.cookieStore);
            return;
        }
        HttpClientBuilder clientBuilder = HttpClients.custom();
        RequestConfig.Builder reqConfigBuilder = RequestConfig.custom();
        reqConfigBuilder.setCookieSpec("standard");
        if (opts.connectionTimeout != null) {
            reqConfigBuilder.setConnectTimeout(opts.connectionTimeout.intValue());
            reqConfigBuilder.setConnectionRequestTimeout(opts.connectionTimeout.intValue());
        }
        if (opts.readTimeout != null) {
            reqConfigBuilder.setSocketTimeout(opts.readTimeout.intValue());
        }
        clientBuilder.setDefaultRequestConfig(reqConfigBuilder.build());
        clientBuilder.setDefaultCookieStore((CookieStore)this.cookieStore);
        clientBuilder.setHostnameVerifier(new X509HostnameVerifier(){

            public boolean verify(String host, SSLSession sess) {
                return true;
            }

            public void verify(String host, SSLSocket ssl) {
            }

            public void verify(String host, String[] cns, String[] subjectAlts) {
            }

            public void verify(String host, X509Certificate cert) {
            }
        });
        SSLContext sslcontext = null;
        if (ignoreSSL.booleanValue()) {
            try {
                sslcontext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                }).build();
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
                // empty catch block
            }
            sslConnectionFactory = new SSLConnectionSocketFactory(sslcontext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER){

                protected void prepareSocket(SSLSocket socket) {
                    try {
                        PropertyUtils.setProperty((Object)socket, (String)"host", null);
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    List<SNIServerName> serverNames = Collections.emptyList();
                    SSLParameters sslParams = socket.getSSLParameters();
                    sslParams.setServerNames(serverNames);
                    socket.setSSLParameters(sslParams);
                }

                public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException, ConnectTimeoutException {
                    if (socket instanceof SSLSocket) {
                        try {
                            String[] enabledProtocols = new String[]{"SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"};
                            SSLSocket sslSocket = (SSLSocket)socket;
                            sslSocket.setEnabledProtocols(enabledProtocols);
                            PropertyUtils.setProperty((Object)socket, (String)"host", (Object)host.getHostName());
                        }
                        catch (Exception ex) {
                            log.error("We have an unhandled exception when attempting to connect to {} ignoring SSL errors", (Object)host, (Object)ex);
                        }
                    }
                    return super.connectSocket(WEB_CONNECTION_TIMEOUT.intValue(), socket, host, remoteAddress, localAddress, context);
                }
            };
        } else {
            sslcontext = SSLContexts.createSystemDefault();
            sslConnectionFactory = new SSLConnectionSocketFactory(sslcontext){

                public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException, ConnectTimeoutException {
                    if (socket instanceof SSLSocket) {
                        try {
                            String[] enabledProtocols = new String[]{"SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"};
                            SSLSocket sslSocket = (SSLSocket)socket;
                            sslSocket.setEnabledProtocols(enabledProtocols);
                            PropertyUtils.setProperty((Object)socket, (String)"host", (Object)host.getHostName());
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                            // empty catch block
                        }
                    }
                    return super.connectSocket(opts.timeout != null ? opts.timeout : 30000, socket, host, remoteAddress, localAddress, context);
                }
            };
        }
        DefaultHttpResponseParserFactory responseParserFactory = new DefaultHttpResponseParserFactory(){

            public HttpMessageParser<HttpResponse> create(SessionInputBuffer ibuffer, MessageConstraints constraints) {
                BasicLineParser lineParser = new BasicLineParser(){

                    public Header parseHeader(CharArrayBuffer buffer) {
                        try {
                            return super.parseHeader(buffer);
                        }
                        catch (ParseException ex) {
                            return new BasicHeader(buffer.toString(), null);
                        }
                    }
                };
                return new DefaultHttpResponseParser(ibuffer, (LineParser)lineParser, (HttpResponseFactory)DefaultHttpResponseFactory.INSTANCE, constraints != null ? constraints : MessageConstraints.DEFAULT){

                    protected boolean reject(CharArrayBuffer line, int count) {
                        return count > 100;
                    }
                };
            }
        };
        clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionFactory);
        Registry registry = RegistryBuilder.create().register("https", (Object)sslConnectionFactory).register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
        DefaultHttpRequestWriterFactory requestWriterFactory = new DefaultHttpRequestWriterFactory();
        ManagedHttpClientConnectionFactory connFactory = new ManagedHttpClientConnectionFactory((HttpMessageWriterFactory)requestWriterFactory, (HttpMessageParserFactory)responseParserFactory);
        BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager((Lookup)registry, (HttpConnectionFactory)connFactory);
        clientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        CloseableHttpClient client = clientBuilder.build();
        this.httpClient = client;
        this.connectionManager = connectionManager;
        withClientFunction.method((HttpClient)client, this.cookieStore);
    }

    public void shutdownClient() {
        if (this.connectionManager != null) {
            try {
                this.connectionManager.shutdown();
            }
            catch (Exception ex) {
                log.error("Error Shutting Down Keep-Alive {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$callApi$0(HttpRequestBase request, ServiceResponse rtn, RequestOptions opts, String url, String path, URIBuilder uriBuilder, HttpClient client, BasicCookieStore cookieStore) {
        CloseableHttpResponse response = null;
        try {
            response = (CloseableHttpResponse)client.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() <= 399) {
                for (Header header : response.getAllHeaders()) {
                    rtn.addHeader(header.getName(), header.getValue());
                }
                for (Header header : response.getHeaders("Set-Cookie")) {
                    Map<String, String> cookies = this.extractCookie(header.getValue());
                    for (String cookieKey : cookies.keySet()) {
                        BasicClientCookie cookie = new BasicClientCookie(cookieKey, cookies.get(cookieKey));
                        cookie.setPath("/");
                        cookie.setDomain(request.getURI().getHost());
                        cookieStore.addCookie((Cookie)cookie);
                    }
                }
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    rtn.setContent(EntityUtils.toString((HttpEntity)entity));
                    if (!opts.suppressLog.booleanValue()) {
                        log.debug("results of SUCCESSFUL call to {}/{}, results: {}", new Object[]{url, path, rtn.getContent()});
                    }
                } else {
                    rtn.setContent(null);
                }
                rtn.setErrorCode(Integer.toString(response.getStatusLine().getStatusCode()));
                rtn.setSuccess(true);
            } else {
                if (response.getEntity() != null) {
                    rtn.setContent(EntityUtils.toString((HttpEntity)response.getEntity()));
                }
                rtn.setSuccess(false);
                rtn.setErrorCode(Integer.toString(response.getStatusLine().getStatusCode()));
                log.warn("path: {} error: {} - {}", new Object[]{path, rtn.getErrorCode(), rtn.getContent()});
            }
        }
        catch (Exception ex) {
            try {
                log.error("Error occurred processing the response for {} : {}", new Object[]{uriBuilder.build().toString(), ex.getMessage(), ex});
                rtn.setError("Error occurred processing the response for " + uriBuilder.build().toString() + " : " + ex.getMessage());
            }
            catch (URISyntaxException uie) {
                log.error("Error occurred processing the response for {} : {}", new Object[]{"invalid uri", ex.getMessage(), ex});
                rtn.setError("Error occurred processing the response for invalid uri  : " + ex.getMessage());
            }
            rtn.setSuccess(false);
        }
        finally {
            this.lastCallTime = new Date();
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static class RequestOptions {
        public Object body;
        public String contentType;
        public Map<CharSequence, CharSequence> headers;
        public Map<CharSequence, CharSequence> queryParams;
        public Boolean suppressLog = true;
        public Boolean ignoreSSL = true;
        public Integer timeout = 30000;
        public Integer connectionTimeout = null;
        public Integer readTimeout = null;
        public Long contentLength = null;
        public OauthOptions oauth;
        public String apiToken;
        public HttpClient httpClient;
        public HttpClientConnectionManager connectionManager;

        public static class OauthOptions {
            public String version;
            public String consumerKey;
            public String consumerSecret;
            public String apiKey;
            public String apiSecret;
        }
    }

    @FunctionalInterface
    public static interface WithClientFunction {
        public void method(HttpClient var1, BasicCookieStore var2);
    }
}

