/*
 * Decompiled with CFR 0.152.
 */
package com.bertramlabs.plugins.hcl4j.utils;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ServiceResponse<T> {
    private static final String DEFAULT_ERROR_KEY = "error";
    private Boolean success = false;
    private Boolean warning = false;
    private String msg = null;
    private Map<String, String> errors = new LinkedHashMap<String, String>();
    private T data;
    private Map<String, Object> headers;
    private String content;
    private String errorCode;
    private Object results;
    private Map<String, String> cookies;
    public Boolean inProgress = false;

    public ServiceResponse() {
    }

    public ServiceResponse(Boolean success, String msg, Map<String, String> errors, T data) {
        this.success = success;
        this.msg = msg;
        if (errors != null) {
            this.errors = errors;
        }
        this.data = data;
    }

    public static ServiceResponse prepare() {
        return new ServiceResponse<Object>(false, null, null, null);
    }

    public static ServiceResponse prepare(Object data) {
        return new ServiceResponse<Object>(false, null, null, data);
    }

    public static ServiceResponse create(Map<String, Object> config) {
        Boolean warning;
        Boolean configSuccess = config.get("success") == null ? false : (Boolean)config.get("success");
        String configMsg = config.get("msg") != null ? (String)config.get("message") : null;
        LinkedHashMap<String, String> configErrors = config.getOrDefault("errors", new LinkedHashMap());
        LinkedHashMap configData = config.getOrDefault("data", new LinkedHashMap());
        ServiceResponse rtn = new ServiceResponse(configSuccess, configMsg, configErrors, configData);
        Boolean inProgress = (Boolean)config.get("inProgress");
        if (inProgress != null) {
            rtn.inProgress = inProgress;
        }
        if ((warning = (Boolean)config.get("warning")) != null) {
            rtn.warning = warning;
        }
        return rtn;
    }

    public static ServiceResponse create(ServiceResponse source) {
        return source;
    }

    public static ServiceResponse error() {
        ServiceResponse<Object> serviceResponse = new ServiceResponse<Object>(false, null, null, null);
        serviceResponse.setError(DEFAULT_ERROR_KEY);
        return serviceResponse;
    }

    public static ServiceResponse error(String msg) {
        ServiceResponse<Object> serviceResponse = new ServiceResponse<Object>(false, null, null, null);
        serviceResponse.setError(msg);
        return serviceResponse;
    }

    public static ServiceResponse error(String msg, Map<String, String> errors) {
        return new ServiceResponse<Object>(false, msg, errors, null);
    }

    public static ServiceResponse error(String msg, Map<String, String> errors, Object data) {
        return new ServiceResponse<Object>(false, msg, errors, data);
    }

    static ServiceResponse success(Object data, String msg) {
        return new ServiceResponse<Object>(true, msg, null, data);
    }

    public static ServiceResponse success(Object data) {
        return new ServiceResponse<Object>(true, null, null, data);
    }

    public static ServiceResponse success() {
        return new ServiceResponse<Object>(true, null, null, null);
    }

    public Map<String, Object> toMap() {
        return this.toMap(null);
    }

    public Map<String, Object> toMap(String dataKeyName) {
        LinkedHashMap<String, Object> returnMap = new LinkedHashMap<String, Object>();
        returnMap.put("success", this.success);
        returnMap.put("msg", this.msg);
        returnMap.put("errors", this.errors);
        returnMap.put(dataKeyName != null ? dataKeyName : "data", this.data);
        return returnMap;
    }

    public boolean hasError(String key) {
        if (this.errors == null) {
            return false;
        }
        return this.errors.containsKey(key);
    }

    public boolean hasErrors() {
        if (this.errors == null) {
            return false;
        }
        if (!this.success.booleanValue()) {
            return true;
        }
        return this.errors.size() > 0;
    }

    public String toString() {
        return this.toMap().toString();
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Map<String, String> getErrors() {
        return this.errors;
    }

    public void setErrors(Map<String, String> errors) {
        if (errors != null) {
            this.success = false;
        }
        this.errors = errors;
    }

    public void addError(String value) {
        this.success = false;
        this.errors.put(DEFAULT_ERROR_KEY, value);
    }

    public void addError(String key, String value) {
        this.success = false;
        this.errors.put(key, value);
    }

    public void removeError() {
        this.errors.remove(DEFAULT_ERROR_KEY);
        if (this.errors.size() == 0) {
            this.success = true;
        }
    }

    public void clearErrors() {
        this.errors.clear();
        this.success = true;
    }

    public void removeError(String key) {
        this.errors.remove(key);
    }

    public String getError(String key) {
        return this.errors.getOrDefault(key, null);
    }

    public String getError() {
        return this.errors.getOrDefault(DEFAULT_ERROR_KEY, null);
    }

    public void setError(String value) {
        this.success = false;
        this.errors.put(DEFAULT_ERROR_KEY, value);
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public void addHeader(String key, Object value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>();
        }
        this.headers.put(key, value);
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public Object getResults() {
        return this.results;
    }

    public void setResults(Object results) {
        this.results = results;
    }

    public Map getCookies() {
        return this.cookies;
    }

    public void setCookies(Map cookies) {
        this.cookies = cookies;
    }

    public void addCookie(String key, Object value) {
        if (this.cookies == null) {
            this.cookies = new HashMap<String, String>();
        }
        this.cookies.put(key, value.toString());
    }

    public String getCookie(String key) {
        if (this.cookies == null) {
            return null;
        }
        return this.cookies.getOrDefault(key, null);
    }
}

