/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.collections.generic;

import com.bestvike.CultureInfo;
import com.bestvike.IComparison;
import com.bestvike.collections.generic.ComparisonComparer;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;
import java.text.Collator;
import java.util.Comparator;

public final class Comparer<T>
implements Comparator<T> {
    private static final Comparer DEFAULT = new Comparer(null);
    private static final Comparer DEFAULT_INVARIANT = new Comparer(CultureInfo.getInvariantCulture());
    private final Collator collator;

    private Comparer(Collator collator) {
        this.collator = collator;
    }

    public static <T> Comparator<T> Default() {
        return DEFAULT;
    }

    public static <T> Comparator<T> DefaultInvariant() {
        return DEFAULT_INVARIANT;
    }

    public static <T> Comparator<T> create(Collator collator) {
        if (collator == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.collator);
        }
        return new Comparer<T>(collator);
    }

    public static <T> Comparator<T> create(IComparison<? super T> comparison) {
        if (comparison == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.comparison);
        }
        return new ComparisonComparer<T>(comparison);
    }

    @Override
    public int compare(T x, T y) {
        if (x == y) {
            return 0;
        }
        if (x == null) {
            return -1;
        }
        if (y == null) {
            return 1;
        }
        if (x instanceof String && y instanceof String) {
            return (this.collator == null ? CultureInfo.getCurrentCulture() : this.collator).compare((String)x, (String)y);
        }
        if (x instanceof Comparable) {
            return ((Comparable)x).compareTo(y);
        }
        if (y instanceof Comparable) {
            return -((Comparable)y).compareTo(x);
        }
        ThrowHelper.throwImplementComparableException();
        return 0;
    }
}

