/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.adapter.enumerator;

import com.bestvike.linq.enumerable.AbstractEnumerator;

public final class LineEnumerator
extends AbstractEnumerator<String> {
    private final CharSequence source;

    public LineEnumerator(CharSequence source) {
        this.source = source;
    }

    @Override
    public boolean moveNext() {
        if (this.state == -1) {
            return false;
        }
        int length = this.source.length();
        for (int index = this.state; index < length; ++index) {
            char tail;
            char head = this.source.charAt(index);
            if (head == '\r' || head == '\n') {
                continue;
            }
            int beginIndex = index++;
            while (index < length && (tail = this.source.charAt(index)) != '\r' && tail != '\n') {
                ++index;
            }
            this.current = this.source.subSequence(beginIndex, index).toString();
            this.state = index;
            return true;
        }
        this.close();
        return false;
    }
}

