/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.adapter.enumerator;

import com.bestvike.linq.enumerable.AbstractEnumerator;

public final class WordEnumerator
extends AbstractEnumerator<String> {
    private final CharSequence source;

    public WordEnumerator(CharSequence source) {
        this.source = source;
    }

    @Override
    public boolean moveNext() {
        if (this.state == -1) {
            return false;
        }
        int length = this.source.length();
        for (int index = this.state; index < length; ++index) {
            char tail;
            char head = this.source.charAt(index);
            if (!Character.isLetterOrDigit(head)) {
                continue;
            }
            int beginIndex = index++;
            while (index < length && Character.isLetterOrDigit(tail = this.source.charAt(index))) {
                ++index;
            }
            this.current = this.source.subSequence(beginIndex, index).toString();
            this.state = index;
            return true;
        }
        this.close();
        return false;
    }
}

