/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.ICollection;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.AppendPrependIterator;
import com.bestvike.linq.enumerable.AppendPrependNIterator;
import com.bestvike.linq.enumerable.EnumerableHelpers;
import com.bestvike.linq.enumerable.IIListProvider;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.LargeArrayBuilder;
import com.bestvike.linq.enumerable.SingleLinkedNode;
import com.bestvike.linq.util.ArrayUtils;
import com.bestvike.linq.util.ListUtils;
import java.util.ArrayList;
import java.util.List;

final class AppendPrepend1Iterator<TSource>
extends AppendPrependIterator<TSource> {
    private final TSource item;
    private final boolean appending;

    AppendPrepend1Iterator(IEnumerable<TSource> source, TSource item, boolean appending) {
        super(source);
        this.item = item;
        this.appending = appending;
    }

    @Override
    public Iterator<TSource> clone() {
        return new AppendPrepend1Iterator<TSource>(this.source, this.item, this.appending);
    }

    @Override
    public boolean moveNext() {
        switch (this.state) {
            case 1: {
                this.state = 2;
                if (!this.appending) {
                    this.current = this.item;
                    return true;
                }
            }
            case 2: {
                this.getSourceEnumerator();
                this.state = 3;
            }
            case 3: {
                if (this.loadFromEnumerator()) {
                    return true;
                }
                if (this.appending) {
                    this.current = this.item;
                    return true;
                }
                this.close();
                return false;
            }
        }
        return false;
    }

    @Override
    public AppendPrependIterator<TSource> _append(TSource item) {
        return this.appending ? new AppendPrependNIterator<TSource>(this.source, null, new SingleLinkedNode<TSource>(this.item).add(item), 0, 2) : new AppendPrependNIterator<TSource>(this.source, new SingleLinkedNode<TSource>(this.item), new SingleLinkedNode<TSource>(item), 1, 1);
    }

    @Override
    public AppendPrependIterator<TSource> _prepend(TSource item) {
        return this.appending ? new AppendPrependNIterator<TSource>(this.source, new SingleLinkedNode<TSource>(item), new SingleLinkedNode<TSource>(this.item), 1, 1) : new AppendPrependNIterator<TSource>(this.source, new SingleLinkedNode<TSource>(this.item).add(item), null, 2, 0);
    }

    private TSource[] lazyToArray(Class<TSource> clazz) {
        assert (this._getCount(true) == -1);
        LargeArrayBuilder<TSource> builder = new LargeArrayBuilder<TSource>();
        if (!this.appending) {
            builder.slowAdd(this.item);
        }
        builder.addRange(this.source);
        if (this.appending) {
            builder.slowAdd(this.item);
        }
        return builder.toArray(clazz);
    }

    private Object[] lazyToArray() {
        assert (this._getCount(true) == -1);
        LargeArrayBuilder<TSource> builder = new LargeArrayBuilder<TSource>();
        if (!this.appending) {
            builder.slowAdd(this.item);
        }
        builder.addRange(this.source);
        if (this.appending) {
            builder.slowAdd(this.item);
        }
        return builder.toArray();
    }

    @Override
    public TSource[] _toArray(Class<TSource> clazz) {
        int index;
        int count = this._getCount(true);
        if (count == -1) {
            return this.lazyToArray(clazz);
        }
        Object[] array = ArrayUtils.newInstance(clazz, count);
        if (this.appending) {
            index = 0;
        } else {
            array[0] = this.item;
            index = 1;
        }
        EnumerableHelpers.copy(this.source, array, index, count - 1);
        if (this.appending) {
            array[array.length - 1] = this.item;
        }
        return array;
    }

    @Override
    public Object[] _toArray() {
        int index;
        int count = this._getCount(true);
        if (count == -1) {
            return this.lazyToArray();
        }
        Object[] array = new Object[count];
        if (this.appending) {
            index = 0;
        } else {
            array[0] = this.item;
            index = 1;
        }
        EnumerableHelpers.copy(this.source, array, index, count - 1);
        if (this.appending) {
            array[array.length - 1] = this.item;
        }
        return array;
    }

    @Override
    public List<TSource> _toList() {
        ArrayList<TSource> list;
        int count = this._getCount(true);
        ArrayList<Object> arrayList = list = count == -1 ? new ArrayList<TSource>() : new ArrayList(count);
        if (!this.appending) {
            list.add(this.item);
        }
        ListUtils.addRange(list, this.source);
        if (this.appending) {
            list.add(this.item);
        }
        return list;
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        if (this.source instanceof IIListProvider) {
            IIListProvider listProv = (IIListProvider)this.source;
            int count = listProv._getCount(onlyIfCheap);
            return count == -1 ? -1 : count + 1;
        }
        return !onlyIfCheap || this.source instanceof ICollection ? this.source.count() + 1 : -1;
    }
}

