/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.ICollection;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.AppendPrependIterator;
import com.bestvike.linq.enumerable.IIListProvider;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.SingleLinkedNode;
import com.bestvike.linq.enumerable.SparseArrayBuilder;
import com.bestvike.linq.util.ArrayUtils;
import com.bestvike.linq.util.ListUtils;
import java.util.ArrayList;
import java.util.List;

final class AppendPrependNIterator<TSource>
extends AppendPrependIterator<TSource> {
    private final SingleLinkedNode<TSource> prepended;
    private final SingleLinkedNode<TSource> appended;
    private final int prependCount;
    private final int appendCount;
    private SingleLinkedNode<TSource> node;

    AppendPrependNIterator(IEnumerable<TSource> source, SingleLinkedNode<TSource> prepended, SingleLinkedNode<TSource> appended, int prependCount, int appendCount) {
        super(source);
        assert (prepended != null || appended != null);
        assert (prependCount > 0 || appendCount > 0);
        assert (prependCount + appendCount >= 2);
        assert ((prepended == null ? 0 : prepended.getCount()) == prependCount);
        assert ((appended == null ? 0 : appended.getCount()) == appendCount);
        this.prepended = prepended;
        this.appended = appended;
        this.prependCount = prependCount;
        this.appendCount = appendCount;
    }

    @Override
    public Iterator<TSource> clone() {
        return new AppendPrependNIterator<TSource>(this.source, this.prepended, this.appended, this.prependCount, this.appendCount);
    }

    @Override
    public boolean moveNext() {
        switch (this.state) {
            case 1: {
                this.node = this.prepended;
                this.state = 2;
            }
            case 2: {
                if (this.node != null) {
                    this.current = this.node.getItem();
                    this.node = this.node.getLinked();
                    return true;
                }
                this.getSourceEnumerator();
                this.state = 3;
            }
            case 3: {
                if (this.loadFromEnumerator()) {
                    return true;
                }
                if (this.appended == null) {
                    this.close();
                    return false;
                }
                this.enumerator = this.appended.toArray(this.appendCount).enumerator();
                this.state = 4;
            }
            case 4: {
                return this.loadFromEnumerator();
            }
        }
        return false;
    }

    @Override
    public AppendPrependIterator<TSource> _append(TSource item) {
        SingleLinkedNode<TSource> appended = this.appended != null ? this.appended.add(item) : new SingleLinkedNode<TSource>(item);
        return new AppendPrependNIterator<TSource>(this.source, this.prepended, appended, this.prependCount, this.appendCount + 1);
    }

    @Override
    public AppendPrependIterator<TSource> _prepend(TSource item) {
        SingleLinkedNode<TSource> prepended = this.prepended != null ? this.prepended.add(item) : new SingleLinkedNode<TSource>(item);
        return new AppendPrependNIterator<TSource>(this.source, prepended, this.appended, this.prependCount + 1, this.appendCount);
    }

    private TSource[] lazyToArray(Class<TSource> clazz) {
        SingleLinkedNode<TSource> node;
        assert (this._getCount(true) == -1);
        SparseArrayBuilder<TSource> builder = new SparseArrayBuilder<TSource>();
        if (this.prepended != null) {
            builder.reserve(this.prependCount);
        }
        builder.addRange(this.source);
        if (this.appended != null) {
            builder.reserve(this.appendCount);
        }
        T[] array = builder.toArray(clazz);
        int index = 0;
        for (node = this.prepended; node != null; node = node.getLinked()) {
            array[index++] = node.getItem();
        }
        index = array.length - 1;
        for (node = this.appended; node != null; node = node.getLinked()) {
            array[index--] = node.getItem();
        }
        return array;
    }

    private Object[] lazyToArray() {
        SingleLinkedNode<TSource> node;
        assert (this._getCount(true) == -1);
        SparseArrayBuilder builder = new SparseArrayBuilder();
        if (this.prepended != null) {
            builder.reserve(this.prependCount);
        }
        builder.addRange(this.source);
        if (this.appended != null) {
            builder.reserve(this.appendCount);
        }
        Object[] array = builder.toArray();
        int index = 0;
        for (node = this.prepended; node != null; node = node.getLinked()) {
            array[index++] = node.getItem();
        }
        index = array.length - 1;
        for (node = this.appended; node != null; node = node.getLinked()) {
            array[index--] = node.getItem();
        }
        return array;
    }

    @Override
    public TSource[] _toArray(Class<TSource> clazz) {
        SingleLinkedNode<TSource> node;
        int count = this._getCount(true);
        if (count == -1) {
            return this.lazyToArray(clazz);
        }
        Object[] array = ArrayUtils.newInstance(clazz, count);
        int index = 0;
        for (node = this.prepended; node != null; node = node.getLinked()) {
            array[index] = node.getItem();
            ++index;
        }
        if (this.source instanceof ICollection) {
            ICollection sourceCollection = (ICollection)this.source;
            sourceCollection._copyTo(array, index);
        } else {
            try (IEnumerator e = this.source.enumerator();){
                while (e.moveNext()) {
                    array[index] = e.current();
                    ++index;
                }
            }
        }
        index = array.length;
        for (node = this.appended; node != null; node = node.getLinked()) {
            array[--index] = node.getItem();
        }
        return array;
    }

    @Override
    public Object[] _toArray() {
        SingleLinkedNode<TSource> node;
        int count = this._getCount(true);
        if (count == -1) {
            return this.lazyToArray();
        }
        Object[] array = new Object[count];
        int index = 0;
        for (node = this.prepended; node != null; node = node.getLinked()) {
            array[index] = node.getItem();
            ++index;
        }
        if (this.source instanceof ICollection) {
            ICollection sourceCollection = (ICollection)this.source;
            sourceCollection._copyTo(array, index);
        } else {
            try (IEnumerator e = this.source.enumerator();){
                while (e.moveNext()) {
                    array[index] = e.current();
                    ++index;
                }
            }
        }
        index = array.length;
        for (node = this.appended; node != null; node = node.getLinked()) {
            array[--index] = node.getItem();
        }
        return array;
    }

    @Override
    public List<TSource> _toList() {
        int count = this._getCount(true);
        ArrayList<TSource> list = count == -1 ? new ArrayList<TSource>() : new ArrayList(count);
        for (SingleLinkedNode<TSource> node = this.prepended; node != null; node = node.getLinked()) {
            list.add(node.getItem());
        }
        ListUtils.addRange(list, this.source);
        if (this.appended != null) {
            ListUtils.addRange(list, this.appended.toArray(this.appendCount));
        }
        return list;
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        if (this.source instanceof IIListProvider) {
            IIListProvider listProv = (IIListProvider)this.source;
            int count = listProv._getCount(onlyIfCheap);
            return count == -1 ? -1 : count + this.appendCount + this.prependCount;
        }
        return !onlyIfCheap || this.source instanceof ICollection ? this.source.count() + this.appendCount + this.prependCount : -1;
    }
}

