/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.EnumerableHelpers;
import com.bestvike.linq.enumerable.IIListProvider;
import com.bestvike.linq.util.ArrayUtils;
import com.bestvike.out;

final class Buffer<TElement> {
    final Object[] items;
    final int count;

    Buffer(IEnumerable<TElement> source) {
        if (source instanceof IIListProvider) {
            IIListProvider iterator = (IIListProvider)source;
            this.items = iterator._toArray();
            this.count = this.items.length;
        } else {
            out<Integer> countRef = out.init();
            this.items = EnumerableHelpers.toArray(source, countRef);
            this.count = (Integer)countRef.value;
        }
    }

    public TElement[] toArray(Class<TElement> clazz) {
        TElement[] array = ArrayUtils.newInstance(clazz, this.count);
        if (this.count > 0) {
            System.arraycopy(this.items, 0, array, 0, this.count);
        }
        return array;
    }
}

