/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.enumerable.AbstractIterator;

final class CharKeepEmptySplitIterator0
extends AbstractIterator<String> {
    private final CharSequence source;

    CharKeepEmptySplitIterator0(CharSequence source) {
        assert (source != null);
        this.source = source;
    }

    @Override
    public AbstractIterator<String> clone() {
        return new CharKeepEmptySplitIterator0(this.source);
    }

    @Override
    public boolean moveNext() {
        if (this.state == -1) {
            return false;
        }
        int index = this.state - 1;
        if (index < 0) {
            this.close();
            return false;
        }
        int length = this.source.length();
        int beginIndex = index;
        while (index < length) {
            char current = this.source.charAt(index);
            if (Character.isWhitespace(current)) {
                this.current = index == beginIndex ? "" : this.source.subSequence(beginIndex, index).toString();
                this.state = index + 2;
                return true;
            }
            ++index;
        }
        if (index == length) {
            this.current = index == beginIndex ? "" : this.source.subSequence(beginIndex, index).toString();
            this.state = index + 2;
            return true;
        }
        this.close();
        return false;
    }
}

