/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.enumerable.AbstractIterator;

final class CharKeepEmptySplitIterator1
extends AbstractIterator<String> {
    private final CharSequence source;
    private final char separator;

    CharKeepEmptySplitIterator1(CharSequence source, char separator) {
        assert (source != null);
        this.source = source;
        this.separator = separator;
    }

    @Override
    public AbstractIterator<String> clone() {
        return new CharKeepEmptySplitIterator1(this.source, this.separator);
    }

    @Override
    public boolean moveNext() {
        if (this.state == -1) {
            return false;
        }
        int index = this.state - 1;
        if (index < 0) {
            this.close();
            return false;
        }
        int length = this.source.length();
        int beginIndex = index;
        while (index < length) {
            char current = this.source.charAt(index);
            if (current == this.separator) {
                this.current = index == beginIndex ? "" : this.source.subSequence(beginIndex, index).toString();
                this.state = index + 2;
                return true;
            }
            ++index;
        }
        if (index == length) {
            this.current = index == beginIndex ? "" : this.source.subSequence(beginIndex, index).toString();
            this.state = index + 2;
            return true;
        }
        this.close();
        return false;
    }
}

