/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.enumerable.AbstractIterator;
import com.bestvike.linq.enumerable.ProbabilisticMap;

final class CharKeepEmptySplitIteratorN
extends AbstractIterator<String> {
    private final CharSequence source;
    private final char[] separators;
    private ProbabilisticMap charMap;

    CharKeepEmptySplitIteratorN(CharSequence source, char[] separators) {
        assert (source != null);
        assert (separators != null && separators.length > 3);
        this.source = source;
        this.separators = separators;
    }

    @Override
    public AbstractIterator<String> clone() {
        return new CharKeepEmptySplitIteratorN(this.source, this.separators);
    }

    @Override
    public boolean moveNext() {
        int index;
        if (this.state == -1) {
            return false;
        }
        if (this.state == 1) {
            this.charMap = new ProbabilisticMap(this.separators);
        }
        if ((index = this.state - 1) < 0) {
            this.close();
            return false;
        }
        int length = this.source.length();
        int beginIndex = index;
        while (index < length) {
            char current = this.source.charAt(index);
            if (this.charMap.contains(current)) {
                this.current = index == beginIndex ? "" : this.source.subSequence(beginIndex, index).toString();
                this.state = index + 2;
                return true;
            }
            ++index;
        }
        if (index == length) {
            this.current = index == beginIndex ? "" : this.source.subSequence(beginIndex, index).toString();
            this.state = index + 2;
            return true;
        }
        this.close();
        return false;
    }

    @Override
    public void close() {
        this.charMap = null;
        super.close();
    }
}

