/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.enumerable.AbstractIterator;
import com.bestvike.linq.util.Strings;

final class CharOmitEmptySplitIterator0
extends AbstractIterator<String> {
    private final CharSequence source;

    CharOmitEmptySplitIterator0(CharSequence source) {
        assert (!Strings.isNullOrEmpty(source));
        this.source = source;
    }

    @Override
    public AbstractIterator<String> clone() {
        return new CharOmitEmptySplitIterator0(this.source);
    }

    @Override
    public boolean moveNext() {
        if (this.state == -1) {
            return false;
        }
        int length = this.source.length();
        for (int index = this.state - 1; index < length; ++index) {
            char tail;
            char head = this.source.charAt(index);
            if (Character.isWhitespace(head)) {
                continue;
            }
            int beginIndex = index++;
            while (index < length && !Character.isWhitespace(tail = this.source.charAt(index))) {
                ++index;
            }
            this.current = this.source.subSequence(beginIndex, index).toString();
            this.state = index + 1;
            return true;
        }
        this.close();
        return false;
    }
}

