/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.enumerable.AbstractIterator;
import com.bestvike.linq.util.Strings;

final class CharOmitEmptySplitIterator1
extends AbstractIterator<String> {
    private final CharSequence source;
    private final char separator;

    CharOmitEmptySplitIterator1(CharSequence source, char separator) {
        assert (!Strings.isNullOrEmpty(source));
        this.source = source;
        this.separator = separator;
    }

    @Override
    public AbstractIterator<String> clone() {
        return new CharOmitEmptySplitIterator1(this.source, this.separator);
    }

    @Override
    public boolean moveNext() {
        if (this.state == -1) {
            return false;
        }
        int length = this.source.length();
        for (int index = this.state - 1; index < length; ++index) {
            char tail;
            char head = this.source.charAt(index);
            if (head == this.separator) {
                continue;
            }
            int beginIndex = index++;
            while (index < length && (tail = this.source.charAt(index)) != this.separator) {
                ++index;
            }
            this.current = this.source.subSequence(beginIndex, index).toString();
            this.state = index + 1;
            return true;
        }
        this.close();
        return false;
    }
}

