/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.enumerable.AbstractIterator;
import com.bestvike.linq.util.Strings;

final class CharOmitEmptySplitIterator2
extends AbstractIterator<String> {
    private final CharSequence source;
    private final char separator0;
    private final char separator1;

    CharOmitEmptySplitIterator2(CharSequence source, char separator0, char separator1) {
        assert (!Strings.isNullOrEmpty(source));
        this.source = source;
        this.separator0 = separator0;
        this.separator1 = separator1;
    }

    @Override
    public AbstractIterator<String> clone() {
        return new CharOmitEmptySplitIterator2(this.source, this.separator0, this.separator1);
    }

    @Override
    public boolean moveNext() {
        if (this.state == -1) {
            return false;
        }
        int length = this.source.length();
        for (int index = this.state - 1; index < length; ++index) {
            char tail;
            char head = this.source.charAt(index);
            if (head == this.separator0 || head == this.separator1) {
                continue;
            }
            int beginIndex = index++;
            while (index < length && (tail = this.source.charAt(index)) != this.separator0 && tail != this.separator1) {
                ++index;
            }
            this.current = this.source.subSequence(beginIndex, index).toString();
            this.state = index + 1;
            return true;
        }
        this.close();
        return false;
    }
}

