/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.enumerable.AbstractIterator;
import com.bestvike.linq.enumerable.ProbabilisticMap;
import com.bestvike.linq.util.Strings;

final class CharOmitEmptySplitIteratorN
extends AbstractIterator<String> {
    private final CharSequence source;
    private final char[] separators;
    private ProbabilisticMap charMap;

    CharOmitEmptySplitIteratorN(CharSequence source, char[] separators) {
        assert (!Strings.isNullOrEmpty(source));
        assert (separators != null && separators.length > 3);
        this.source = source;
        this.separators = separators;
    }

    @Override
    public AbstractIterator<String> clone() {
        return new CharOmitEmptySplitIteratorN(this.source, this.separators);
    }

    @Override
    public boolean moveNext() {
        if (this.state == -1) {
            return false;
        }
        if (this.state == 1) {
            this.charMap = new ProbabilisticMap(this.separators);
        }
        int length = this.source.length();
        for (int index = this.state - 1; index < length; ++index) {
            char tail;
            char head = this.source.charAt(index);
            if (this.charMap.contains(head)) {
                continue;
            }
            int beginIndex = index++;
            while (index < length && !this.charMap.contains(tail = this.source.charAt(index))) {
                ++index;
            }
            this.current = this.source.subSequence(beginIndex, index).toString();
            this.state = index + 1;
            return true;
        }
        this.close();
        return false;
    }

    @Override
    public void close() {
        this.charMap = null;
        super.close();
    }
}

