/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.Concat2Iterator;
import com.bestvike.linq.enumerable.ConcatIterator;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class Concat {
    private Concat() {
    }

    public static <TSource> IEnumerable<TSource> concat(IEnumerable<TSource> first, IEnumerable<TSource> second) {
        if (first == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.first);
        }
        if (second == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.second);
        }
        if (first instanceof ConcatIterator) {
            ConcatIterator firstConcat = (ConcatIterator)first;
            return firstConcat._concat(second);
        }
        return new Concat2Iterator<TSource>(first, second);
    }
}

