/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.ICollection;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.ConcatIterator;
import com.bestvike.linq.enumerable.ConcatNIterator;
import com.bestvike.linq.enumerable.EnumerableHelpers;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.Marker;
import com.bestvike.linq.enumerable.SparseArrayBuilder;
import com.bestvike.out;

final class Concat2Iterator<TSource>
extends ConcatIterator<TSource> {
    final IEnumerable<TSource> first;
    final IEnumerable<TSource> second;

    Concat2Iterator(IEnumerable<TSource> first, IEnumerable<TSource> second) {
        assert (first != null);
        assert (second != null);
        this.first = first;
        this.second = second;
    }

    @Override
    public Iterator<TSource> clone() {
        return new Concat2Iterator<TSource>(this.first, this.second);
    }

    @Override
    public ConcatIterator<TSource> _concat(IEnumerable<TSource> next) {
        boolean hasOnlyCollections = next instanceof ICollection && this.first instanceof ICollection && this.second instanceof ICollection;
        return new ConcatNIterator<TSource>(this, next, 2, hasOnlyCollections);
    }

    @Override
    public IEnumerable<TSource> getEnumerable(int index) {
        assert (index >= 0 && index <= 2);
        switch (index) {
            case 0: {
                return this.first;
            }
            case 1: {
                return this.second;
            }
        }
        return null;
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        out<Integer> firstCountRef = out.init();
        out<Integer> secondCountRef = out.init();
        if (!EnumerableHelpers.tryGetCount(this.first, firstCountRef)) {
            if (onlyIfCheap) {
                return -1;
            }
            firstCountRef.value = this.first.count();
        }
        if (!EnumerableHelpers.tryGetCount(this.second, secondCountRef)) {
            if (onlyIfCheap) {
                return -1;
            }
            secondCountRef.value = this.second.count();
        }
        return Math.addExact((Integer)firstCountRef.value, (Integer)secondCountRef.value);
    }

    @Override
    public TSource[] _toArray(Class<TSource> clazz) {
        Marker marker;
        SparseArrayBuilder<TSource> builder = new SparseArrayBuilder<TSource>();
        boolean reservedFirst = builder.reserveOrAdd(this.first);
        boolean reservedSecond = builder.reserveOrAdd(this.second);
        Object[] array = builder.toArray(clazz);
        if (reservedFirst) {
            marker = builder.getMarkers().first();
            assert (marker.getIndex() == 0);
            EnumerableHelpers.copy(this.first, array, 0, marker.getCount());
        }
        if (reservedSecond) {
            marker = builder.getMarkers().last();
            EnumerableHelpers.copy(this.second, array, marker.getIndex(), marker.getCount());
        }
        return array;
    }

    @Override
    public Object[] _toArray() {
        Marker marker;
        SparseArrayBuilder<TSource> builder = new SparseArrayBuilder<TSource>();
        boolean reservedFirst = builder.reserveOrAdd(this.first);
        boolean reservedSecond = builder.reserveOrAdd(this.second);
        Object[] array = builder.toArray();
        if (reservedFirst) {
            marker = builder.getMarkers().first();
            assert (marker.getIndex() == 0);
            EnumerableHelpers.copy(this.first, array, 0, marker.getCount());
        }
        if (reservedSecond) {
            marker = builder.getMarkers().last();
            EnumerableHelpers.copy(this.second, array, marker.getIndex(), marker.getCount());
        }
        return array;
    }
}

