/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.ICollection;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.ArrayBuilder;
import com.bestvike.linq.enumerable.Concat2Iterator;
import com.bestvike.linq.enumerable.ConcatIterator;
import com.bestvike.linq.enumerable.EnumerableHelpers;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.Marker;
import com.bestvike.linq.enumerable.SparseArrayBuilder;
import com.bestvike.linq.util.ArrayUtils;

final class ConcatNIterator<TSource>
extends ConcatIterator<TSource> {
    private final ConcatIterator<TSource> tail;
    private final IEnumerable<TSource> head;
    private final int headIndex;
    private final boolean hasOnlyCollections;

    ConcatNIterator(ConcatIterator<TSource> tail, IEnumerable<TSource> head, int headIndex, boolean hasOnlyCollections) {
        assert (tail != null);
        assert (head != null);
        assert (headIndex >= 2);
        this.tail = tail;
        this.head = head;
        this.headIndex = headIndex;
        this.hasOnlyCollections = hasOnlyCollections;
    }

    private ConcatNIterator<TSource> getPreviousN() {
        return this.tail instanceof ConcatNIterator ? (ConcatNIterator)this.tail : null;
    }

    @Override
    public Iterator<TSource> clone() {
        return new ConcatNIterator<TSource>(this.tail, this.head, this.headIndex, this.hasOnlyCollections);
    }

    @Override
    public ConcatIterator<TSource> _concat(IEnumerable<TSource> next) {
        if (this.headIndex == 0x7FFFFFFD) {
            return new Concat2Iterator<TSource>(this, next);
        }
        boolean hasOnlyCollections = this.hasOnlyCollections && next instanceof ICollection;
        return new ConcatNIterator<TSource>(this, next, this.headIndex + 1, hasOnlyCollections);
    }

    @Override
    public IEnumerable<TSource> getEnumerable(int index) {
        ConcatNIterator<TSource> node;
        assert (index >= 0);
        if (index > this.headIndex) {
            return null;
        }
        ConcatNIterator<TSource> previousN = this;
        do {
            node = previousN;
            if (index != node.headIndex) continue;
            return node.head;
        } while ((previousN = node.getPreviousN()) != null);
        assert (index == 0 || index == 1);
        assert (node.tail instanceof Concat2Iterator);
        return node.tail.getEnumerable(index);
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        ConcatNIterator<TSource> node;
        if (onlyIfCheap && !this.hasOnlyCollections) {
            return -1;
        }
        int count = 0;
        ConcatNIterator<TSource> previousN = this;
        do {
            ICollection collection;
            node = previousN;
            IEnumerable<TSource> source = node.head;
            ICollection iCollection = collection = source instanceof ICollection ? (ICollection)source : null;
            assert (!this.hasOnlyCollections || collection != null);
            int sourceCount = collection == null ? source.count() : collection._getCount();
            count = Math.addExact(count, sourceCount);
        } while ((previousN = node.getPreviousN()) != null);
        assert (node.tail instanceof Concat2Iterator);
        return Math.addExact(count, node.tail._getCount(onlyIfCheap));
    }

    @Override
    public TSource[] _toArray(Class<TSource> clazz) {
        return this.hasOnlyCollections ? this.preallocatingToArray(clazz) : this.lazyToArray(clazz);
    }

    @Override
    public Object[] _toArray() {
        return this.hasOnlyCollections ? this.preallocatingToArray() : this.lazyToArray();
    }

    private TSource[] lazyToArray(Class<TSource> clazz) {
        IEnumerable<TSource> source;
        assert (!this.hasOnlyCollections);
        SparseArrayBuilder<TSource> builder = new SparseArrayBuilder<TSource>();
        ArrayBuilder<Integer> deferredCopies = new ArrayBuilder<Integer>();
        int i = 0;
        while ((source = this.getEnumerable(i)) != null) {
            if (builder.reserveOrAdd(source)) {
                deferredCopies.add(i);
            }
            ++i;
        }
        Object[] array = builder.toArray(clazz);
        ArrayBuilder<Marker> markers = builder.getMarkers();
        for (int i2 = 0; i2 < markers.getCount(); ++i2) {
            Marker marker = markers.get(i2);
            IEnumerable<TSource> source2 = this.getEnumerable((Integer)deferredCopies.get(i2));
            EnumerableHelpers.copy(source2, array, marker.getIndex(), marker.getCount());
        }
        return array;
    }

    private Object[] lazyToArray() {
        IEnumerable<TSource> source;
        assert (!this.hasOnlyCollections);
        SparseArrayBuilder<TSource> builder = new SparseArrayBuilder<TSource>();
        ArrayBuilder<Integer> deferredCopies = new ArrayBuilder<Integer>();
        int i = 0;
        while ((source = this.getEnumerable(i)) != null) {
            if (builder.reserveOrAdd(source)) {
                deferredCopies.add(i);
            }
            ++i;
        }
        Object[] array = builder.toArray();
        ArrayBuilder<Marker> markers = builder.getMarkers();
        for (int i2 = 0; i2 < markers.getCount(); ++i2) {
            Marker marker = markers.get(i2);
            IEnumerable<TSource> source2 = this.getEnumerable((Integer)deferredCopies.get(i2));
            EnumerableHelpers.copy(source2, array, marker.getIndex(), marker.getCount());
        }
        return array;
    }

    private TSource[] preallocatingToArray(Class<TSource> clazz) {
        ConcatNIterator<TSource> node;
        assert (this.hasOnlyCollections);
        int count = this._getCount(true);
        assert (count >= 0);
        if (count == 0) {
            return ArrayUtils.empty(clazz);
        }
        Object[] array = ArrayUtils.newInstance(clazz, count);
        int arrayIndex = array.length;
        ConcatNIterator<TSource> previousN = this;
        do {
            node = previousN;
            ICollection source = (ICollection)node.head;
            int sourceCount = source._getCount();
            if (sourceCount <= 0) continue;
            arrayIndex = Math.subtractExact(arrayIndex, sourceCount);
            source._copyTo(array, arrayIndex);
        } while ((previousN = node.getPreviousN()) != null);
        Concat2Iterator previous2 = (Concat2Iterator)node.tail;
        ICollection second = (ICollection)previous2.second;
        int secondCount = second._getCount();
        if (secondCount > 0) {
            second._copyTo(array, Math.subtractExact(arrayIndex, secondCount));
        }
        if (arrayIndex > secondCount) {
            ICollection first = (ICollection)previous2.first;
            first._copyTo(array, 0);
        }
        return array;
    }

    private Object[] preallocatingToArray() {
        ConcatNIterator<TSource> node;
        assert (this.hasOnlyCollections);
        int count = this._getCount(true);
        assert (count >= 0);
        if (count == 0) {
            return ArrayUtils.empty();
        }
        Object[] array = new Object[count];
        int arrayIndex = array.length;
        ConcatNIterator<TSource> previousN = this;
        do {
            node = previousN;
            ICollection source = (ICollection)node.head;
            int sourceCount = source._getCount();
            if (sourceCount <= 0) continue;
            arrayIndex = Math.subtractExact(arrayIndex, sourceCount);
            source._copyTo(array, arrayIndex);
        } while ((previousN = node.getPreviousN()) != null);
        Concat2Iterator previous2 = (Concat2Iterator)node.tail;
        ICollection second = (ICollection)previous2.second;
        int secondCount = second._getCount();
        if (secondCount > 0) {
            second._copyTo(array, Math.subtractExact(arrayIndex, secondCount));
        }
        if (arrayIndex > secondCount) {
            ICollection first = (ICollection)previous2.first;
            first._copyTo(array, 0);
        }
        return array;
    }
}

