/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.ICollection;
import com.bestvike.function.Predicate1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.IIListProvider;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class Count {
    private Count() {
    }

    public static <TSource> int count(IEnumerable<TSource> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (source instanceof ICollection) {
            ICollection collection = (ICollection)source;
            return collection._getCount();
        }
        if (source instanceof IIListProvider) {
            IIListProvider listProv = (IIListProvider)source;
            return listProv._getCount(false);
        }
        int count = 0;
        try (IEnumerator<TSource> e = source.enumerator();){
            while (e.moveNext()) {
                count = Math.addExact(count, 1);
            }
        }
        return count;
    }

    public static <TSource> int count(IEnumerable<TSource> source, Predicate1<TSource> predicate) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (predicate == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.predicate);
        }
        int count = 0;
        try (IEnumerator<TSource> e = source.enumerator();){
            while (e.moveNext()) {
                if (!predicate.apply(e.current())) continue;
                count = Math.addExact(count, 1);
            }
        }
        return count;
    }

    public static <TSource> long longCount(IEnumerable<TSource> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        long count = 0L;
        try (IEnumerator<TSource> e = source.enumerator();){
            while (e.moveNext()) {
                count = Math.addExact(count, 1L);
            }
        }
        return count;
    }

    public static <TSource> long longCount(IEnumerable<TSource> source, Predicate1<TSource> predicate) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (predicate == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.predicate);
        }
        long count = 0L;
        try (IEnumerator<TSource> e = source.enumerator();){
            while (e.moveNext()) {
                if (!predicate.apply(e.current())) continue;
                count = Math.addExact(count, 1L);
            }
        }
        return count;
    }
}

