/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.ICollection;
import com.bestvike.function.Func2;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.IIListProvider;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.LargeArrayBuilder;
import java.util.ArrayList;
import java.util.List;

final class CrossJoinIterator<TOuter, TInner, TResult>
extends Iterator<TResult>
implements IIListProvider<TResult> {
    private final IEnumerable<TOuter> outer;
    private final IEnumerable<TInner> inner;
    private final Func2<TOuter, TInner, TResult> resultSelector;
    private IEnumerator<TOuter> outerEnumerator;
    private IEnumerator<TInner> innerEnumerator;
    private TOuter item;

    CrossJoinIterator(IEnumerable<TOuter> outer, IEnumerable<TInner> inner, Func2<TOuter, TInner, TResult> resultSelector) {
        this.outer = outer;
        this.inner = inner;
        this.resultSelector = resultSelector;
    }

    @Override
    public Iterator<TResult> clone() {
        return new CrossJoinIterator<TOuter, TInner, TResult>(this.outer, this.inner, this.resultSelector);
    }

    @Override
    public boolean moveNext() {
        block5: while (true) {
            switch (this.state) {
                case 1: {
                    this.outerEnumerator = this.outer.enumerator();
                    this.state = 2;
                }
                case 2: {
                    if (this.outerEnumerator.moveNext()) {
                        this.item = this.outerEnumerator.current();
                        this.innerEnumerator = this.inner.enumerator();
                        this.state = 3;
                        continue block5;
                    }
                    this.close();
                    return false;
                }
                case 3: {
                    if (this.innerEnumerator.moveNext()) {
                        this.current = this.resultSelector.apply(this.item, this.innerEnumerator.current());
                        return true;
                    }
                    this.innerEnumerator.close();
                    this.innerEnumerator = null;
                    this.state = 2;
                    continue block5;
                }
            }
            break;
        }
        return false;
    }

    @Override
    public void close() {
        if (this.outerEnumerator != null) {
            this.outerEnumerator.close();
            this.outerEnumerator = null;
            this.item = null;
        }
        if (this.innerEnumerator != null) {
            this.innerEnumerator.close();
            this.innerEnumerator = null;
        }
        super.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TResult[] _toArray(Class<TResult> clazz) {
        int count = this._getCount(true);
        LargeArrayBuilder<TResult> builder = count == -1 ? new LargeArrayBuilder<TResult>() : new LargeArrayBuilder(count);
        try (IEnumerator<TOuter> outerEnumerator = this.outer.enumerator();){
            while (outerEnumerator.moveNext()) {
                IEnumerator<TInner> innerEnumerator;
                block23: {
                    TOuter item = outerEnumerator.current();
                    innerEnumerator = this.inner.enumerator();
                    Throwable throwable = null;
                    try {
                        while (innerEnumerator.moveNext()) {
                            builder.add(this.resultSelector.apply(item, innerEnumerator.current()));
                        }
                        if (innerEnumerator == null) continue;
                        if (throwable == null) break block23;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (innerEnumerator == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    innerEnumerator.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            innerEnumerator.close();
                            throw throwable3;
                        }
                    }
                    try {
                        innerEnumerator.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                innerEnumerator.close();
            }
            return builder.toArray(clazz);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object[] _toArray() {
        int count = this._getCount(true);
        LargeArrayBuilder<TResult> builder = count == -1 ? new LargeArrayBuilder<TResult>() : new LargeArrayBuilder(count);
        try (IEnumerator<TOuter> outerEnumerator = this.outer.enumerator();){
            while (outerEnumerator.moveNext()) {
                IEnumerator<TInner> innerEnumerator;
                block23: {
                    TOuter item = outerEnumerator.current();
                    innerEnumerator = this.inner.enumerator();
                    Throwable throwable = null;
                    try {
                        while (innerEnumerator.moveNext()) {
                            builder.add(this.resultSelector.apply(item, innerEnumerator.current()));
                        }
                        if (innerEnumerator == null) continue;
                        if (throwable == null) break block23;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (innerEnumerator == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    innerEnumerator.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            innerEnumerator.close();
                            throw throwable3;
                        }
                    }
                    try {
                        innerEnumerator.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                innerEnumerator.close();
            }
            return builder.toArray();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<TResult> _toList() {
        int count = this._getCount(true);
        ArrayList<TResult> list = count == -1 ? new ArrayList<TResult>() : new ArrayList(count);
        try (IEnumerator<TOuter> outerEnumerator = this.outer.enumerator();){
            while (outerEnumerator.moveNext()) {
                IEnumerator<TInner> innerEnumerator;
                block23: {
                    TOuter item = outerEnumerator.current();
                    innerEnumerator = this.inner.enumerator();
                    Throwable throwable = null;
                    try {
                        while (innerEnumerator.moveNext()) {
                            list.add(this.resultSelector.apply(item, innerEnumerator.current()));
                        }
                        if (innerEnumerator == null) continue;
                        if (throwable == null) break block23;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (innerEnumerator == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    innerEnumerator.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            innerEnumerator.close();
                            throw throwable3;
                        }
                    }
                    try {
                        innerEnumerator.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                innerEnumerator.close();
            }
            return list;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int _getCount(boolean onlyIfCheap) {
        if (onlyIfCheap) {
            if (!(this.outer instanceof ICollection)) return -1;
            if (!(this.inner instanceof ICollection)) return -1;
            int n = ((ICollection)this.outer)._getCount() * ((ICollection)this.inner)._getCount();
            return n;
        }
        int count = 0;
        try (IEnumerator<TOuter> outerEnumerator = this.outer.enumerator();){
            while (outerEnumerator.moveNext()) {
                IEnumerator<TInner> innerEnumerator;
                block24: {
                    TOuter item = outerEnumerator.current();
                    innerEnumerator = this.inner.enumerator();
                    Throwable throwable = null;
                    try {
                        while (innerEnumerator.moveNext()) {
                            this.resultSelector.apply(item, innerEnumerator.current());
                            count = Math.addExact(count, 1);
                        }
                        if (innerEnumerator == null) continue;
                        if (throwable == null) break block24;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (innerEnumerator == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    innerEnumerator.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            innerEnumerator.close();
                            throw throwable3;
                        }
                    }
                    try {
                        innerEnumerator.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                innerEnumerator.close();
            }
            return count;
        }
    }
}

