/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.DefaultIfEmptyIterator;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class DefaultIfEmpty {
    private DefaultIfEmpty() {
    }

    public static <TSource> IEnumerable<TSource> defaultIfEmpty(IEnumerable<TSource> source) {
        return DefaultIfEmpty.defaultIfEmpty(source, null);
    }

    public static <TSource> IEnumerable<TSource> defaultIfEmpty(IEnumerable<TSource> source, TSource defaultValue) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return new DefaultIfEmptyIterator<TSource>(source, defaultValue);
    }
}

