/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IEqualityComparer;
import com.bestvike.function.Func1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.DistinctByIterator;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class DistinctBy {
    private DistinctBy() {
    }

    public static <TSource, TKey> IEnumerable<TSource> distinctBy(IEnumerable<TSource> source, Func1<TSource, TKey> keySelector) {
        return DistinctBy.distinctBy(source, keySelector, null);
    }

    public static <TSource, TKey> IEnumerable<TSource> distinctBy(IEnumerable<TSource> source, Func1<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (keySelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.keySelector);
        }
        return new DistinctByIterator<TSource, TKey>(source, keySelector, comparer);
    }
}

