/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IEqualityComparer;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.IIListProvider;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.Set;
import java.util.List;

final class DistinctIterator<TSource>
extends Iterator<TSource>
implements IIListProvider<TSource> {
    private final IEnumerable<TSource> source;
    private final IEqualityComparer<TSource> comparer;
    private Set<TSource> set;
    private IEnumerator<TSource> enumerator;

    DistinctIterator(IEnumerable<TSource> source, IEqualityComparer<TSource> comparer) {
        assert (source != null);
        this.source = source;
        this.comparer = comparer;
    }

    @Override
    public Iterator<TSource> clone() {
        return new DistinctIterator<TSource>(this.source, this.comparer);
    }

    @Override
    public boolean moveNext() {
        switch (this.state) {
            case 1: {
                this.enumerator = this.source.enumerator();
                if (!this.enumerator.moveNext()) {
                    this.close();
                    return false;
                }
                TSource element = this.enumerator.current();
                this.set = new Set<TSource>(this.comparer);
                this.set.add(element);
                this.current = element;
                this.state = 2;
                return true;
            }
            case 2: {
                while (this.enumerator.moveNext()) {
                    TSource element = this.enumerator.current();
                    if (!this.set.add(element)) continue;
                    this.current = element;
                    return true;
                }
                this.close();
                return false;
            }
        }
        return false;
    }

    @Override
    public void close() {
        if (this.enumerator != null) {
            this.enumerator.close();
            this.enumerator = null;
            this.set = null;
        }
        super.close();
    }

    @Override
    public TSource[] _toArray(Class<TSource> clazz) {
        return this.fillSet().toArray(clazz);
    }

    @Override
    public Object[] _toArray() {
        return this.fillSet().toArray();
    }

    @Override
    public List<TSource> _toList() {
        return this.fillSet().toList();
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        return onlyIfCheap ? -1 : this.fillSet().getCount();
    }

    private Set<TSource> fillSet() {
        Set<TSource> set = new Set<TSource>(this.comparer);
        set.unionWith(this.source);
        return set;
    }
}

