/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IList;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.IPartition;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;
import com.bestvike.out;

public final class ElementAt {
    private ElementAt() {
    }

    public static <TSource> TSource elementAt(IEnumerable<TSource> source, int index) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (source instanceof IPartition) {
            IPartition partition = (IPartition)source;
            out<Boolean> foundRef = out.init();
            Object element = partition._tryGetElementAt(index, foundRef);
            if (((Boolean)foundRef.value).booleanValue()) {
                return (TSource)element;
            }
        } else {
            if (source instanceof IList) {
                IList list = (IList)source;
                return (TSource)list.get(index);
            }
            if (index >= 0) {
                try (IEnumerator<TSource> e = source.enumerator();){
                    while (e.moveNext()) {
                        if (index == 0) {
                            TSource TSource = e.current();
                            return TSource;
                        }
                        --index;
                    }
                }
            }
        }
        ThrowHelper.throwArgumentOutOfRangeException(ExceptionArgument.index);
        return null;
    }

    public static <TSource> TSource elementAtOrDefault(IEnumerable<TSource> source, int index) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (source instanceof IPartition) {
            IPartition partition = (IPartition)source;
            out<Boolean> foundRef = out.init();
            return (TSource)partition._tryGetElementAt(index, foundRef);
        }
        if (index >= 0) {
            if (source instanceof IList) {
                IList list = (IList)source;
                if (index < list._getCount()) {
                    return (TSource)list.get(index);
                }
            } else {
                try (IEnumerator<TSource> e = source.enumerator();){
                    while (e.moveNext()) {
                        if (index == 0) {
                            TSource TSource = e.current();
                            return TSource;
                        }
                        --index;
                    }
                }
            }
        }
        return null;
    }
}

