/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.adapter.enumerable.ArrayListEnumerable;
import com.bestvike.linq.adapter.enumerable.BooleanArrayEnumerable;
import com.bestvike.linq.adapter.enumerable.ByteArrayEnumerable;
import com.bestvike.linq.adapter.enumerable.CharEnumerable;
import com.bestvike.linq.adapter.enumerable.CharacterArrayEnumerable;
import com.bestvike.linq.adapter.enumerable.CollectionEnumerable;
import com.bestvike.linq.adapter.enumerable.DoubleArrayEnumerable;
import com.bestvike.linq.adapter.enumerable.EnumerationEnumerable;
import com.bestvike.linq.adapter.enumerable.EnumeratorEnumerable;
import com.bestvike.linq.adapter.enumerable.FloatArrayEnumerable;
import com.bestvike.linq.adapter.enumerable.GenericArrayEnumerable;
import com.bestvike.linq.adapter.enumerable.IntegerArrayEnumerable;
import com.bestvike.linq.adapter.enumerable.IterableEnumerable;
import com.bestvike.linq.adapter.enumerable.IteratorEnumerable;
import com.bestvike.linq.adapter.enumerable.LineEnumerable;
import com.bestvike.linq.adapter.enumerable.LinkedListEnumerable;
import com.bestvike.linq.adapter.enumerable.LongArrayEnumerable;
import com.bestvike.linq.adapter.enumerable.ShortArrayEnumerable;
import com.bestvike.linq.adapter.enumerable.SingletonEnumerable;
import com.bestvike.linq.adapter.enumerable.SpliteratorEnumerable;
import com.bestvike.linq.adapter.enumerable.StreamEnumerable;
import com.bestvike.linq.adapter.enumerable.WordEnumerable;
import com.bestvike.linq.enumerable.EmptyPartition;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.stream.Stream;

public final class Enumerable {
    private Enumerable() {
    }

    public static <TResult> IEnumerable<TResult> empty() {
        return EmptyPartition.instance();
    }

    public static <TSource> IEnumerable<TSource> singleton(TSource item) {
        return new SingletonEnumerable<TSource>(item);
    }

    public static <TSource> IEnumerable<TSource> ofNullable(TSource item) {
        return item == null ? Enumerable.empty() : Enumerable.singleton(item);
    }

    public static IEnumerable<Boolean> of(boolean[] source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return new BooleanArrayEnumerable(source);
    }

    public static IEnumerable<Byte> of(byte[] source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return new ByteArrayEnumerable(source);
    }

    public static IEnumerable<Short> of(short[] source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return new ShortArrayEnumerable(source);
    }

    public static IEnumerable<Integer> of(int[] source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return new IntegerArrayEnumerable(source);
    }

    public static IEnumerable<Long> of(long[] source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return new LongArrayEnumerable(source);
    }

    public static IEnumerable<Float> of(float[] source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return new FloatArrayEnumerable(source);
    }

    public static IEnumerable<Double> of(double[] source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return new DoubleArrayEnumerable(source);
    }

    public static IEnumerable<Character> of(char[] source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return new CharacterArrayEnumerable(source);
    }

    public static <TSource> IEnumerable<TSource> of(TSource[] source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return new GenericArrayEnumerable<TSource>(source);
    }

    public static <TSource> IEnumerable<TSource> of(List<TSource> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return source instanceof RandomAccess ? new ArrayListEnumerable<TSource>(source) : new LinkedListEnumerable<TSource>(source);
    }

    public static <TSource> IEnumerable<TSource> of(Collection<TSource> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return new CollectionEnumerable<TSource>(source);
    }

    public static <TSource> IEnumerable<TSource> of(IEnumerable<TSource> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return source;
    }

    public static <TSource> IEnumerable<TSource> of(IEnumerator<TSource> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return new EnumeratorEnumerable<TSource>(source);
    }

    public static <TSource> IEnumerable<TSource> of(Iterable<TSource> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return new IterableEnumerable<TSource>(source);
    }

    public static <TSource> IEnumerable<TSource> of(Iterator<TSource> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return new IteratorEnumerable<TSource>(source);
    }

    public static <TSource> IEnumerable<TSource> of(Stream<TSource> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return new StreamEnumerable<TSource>(source);
    }

    public static <TSource> IEnumerable<TSource> of(Spliterator<TSource> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return new SpliteratorEnumerable<TSource>(source);
    }

    public static <TSource> IEnumerable<TSource> of(Enumeration<TSource> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return new EnumerationEnumerable<TSource>(source);
    }

    public static <TKey, TValue> IEnumerable<Map.Entry<TKey, TValue>> of(Map<TKey, TValue> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return new CollectionEnumerable<Map.Entry<TKey, TValue>>(source.entrySet());
    }

    public static <TSource> IEnumerable<TSource> as(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof boolean[]) {
            return Enumerable.of((boolean[])source);
        }
        if (source instanceof byte[]) {
            return Enumerable.of((byte[])source);
        }
        if (source instanceof short[]) {
            return Enumerable.of((short[])source);
        }
        if (source instanceof int[]) {
            return Enumerable.of((int[])source);
        }
        if (source instanceof long[]) {
            return Enumerable.of((long[])source);
        }
        if (source instanceof float[]) {
            return Enumerable.of((float[])source);
        }
        if (source instanceof double[]) {
            return Enumerable.of((double[])source);
        }
        if (source instanceof char[]) {
            return Enumerable.of((char[])source);
        }
        if (source instanceof Object[]) {
            return Enumerable.of((Object[])source);
        }
        if (source instanceof List) {
            return Enumerable.of((List)source);
        }
        if (source instanceof Collection) {
            return Enumerable.of((Collection)source);
        }
        if (source instanceof IEnumerable) {
            return Enumerable.of((IEnumerable)source);
        }
        if (source instanceof Iterable) {
            return Enumerable.of((Iterable)source);
        }
        if (source instanceof Stream) {
            return Enumerable.of((Stream)source);
        }
        if (source instanceof IEnumerator) {
            return Enumerable.of((IEnumerator)source);
        }
        if (source instanceof Iterator) {
            return Enumerable.of((Iterator)source);
        }
        if (source instanceof Spliterator) {
            return Enumerable.of((Spliterator)source);
        }
        if (source instanceof Enumeration) {
            return Enumerable.of((Enumeration)source);
        }
        if (source instanceof Map) {
            return Enumerable.of((Map)source);
        }
        return null;
    }

    public static IEnumerable<Character> chars(CharSequence source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return new CharEnumerable(source);
    }

    public static IEnumerable<String> words(CharSequence source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return new WordEnumerable(source);
    }

    public static IEnumerable<String> lines(CharSequence source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return new LineEnumerable(source);
    }
}

