/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IList;
import com.bestvike.function.Func1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.EmptyPartition;
import com.bestvike.linq.enumerable.IPartition;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.LargeArrayBuilder;
import com.bestvike.linq.enumerable.SelectIPartitionIterator;
import com.bestvike.linq.util.ArrayUtils;
import com.bestvike.out;
import java.util.ArrayList;
import java.util.List;

final class EnumerablePartition<TSource>
extends Iterator<TSource>
implements IPartition<TSource> {
    private final IEnumerable<TSource> source;
    private final int minIndexInclusive;
    private final int maxIndexInclusive;
    private IEnumerator<TSource> enumerator;

    EnumerablePartition(IEnumerable<TSource> source, int minIndexInclusive, int maxIndexInclusive) {
        assert (source != null);
        assert (!(source instanceof IList)) : String.format("The caller needs to check for %s.", IList.class.getSimpleName());
        assert (minIndexInclusive >= 0);
        assert (maxIndexInclusive >= -1);
        assert (maxIndexInclusive == -1 || maxIndexInclusive - minIndexInclusive < Integer.MAX_VALUE) : String.format("%s will overflow!", "getLimit");
        assert (maxIndexInclusive == -1 || minIndexInclusive <= maxIndexInclusive);
        this.source = source;
        this.minIndexInclusive = minIndexInclusive;
        this.maxIndexInclusive = maxIndexInclusive;
    }

    private static <TSource> boolean skipBefore(int index, IEnumerator<TSource> en) {
        return EnumerablePartition.skipAndCount(index, en) == index;
    }

    private static <TSource> int skipAndCount(int index, IEnumerator<TSource> en) {
        assert (index >= 0);
        return (int)EnumerablePartition.skipAndCount((long)index, en);
    }

    private static <TSource> long skipAndCount(long index, IEnumerator<TSource> en) {
        assert (en != null);
        for (long i = 0L; i < index; ++i) {
            if (en.moveNext()) continue;
            return i;
        }
        return index;
    }

    private boolean hasLimit() {
        return this.maxIndexInclusive != -1;
    }

    private int getLimit() {
        return this.maxIndexInclusive + 1 - this.minIndexInclusive;
    }

    @Override
    public Iterator<TSource> clone() {
        return new EnumerablePartition<TSource>(this.source, this.minIndexInclusive, this.maxIndexInclusive);
    }

    @Override
    public void close() {
        if (this.enumerator != null) {
            this.enumerator.close();
            this.enumerator = null;
        }
        super.close();
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        if (onlyIfCheap) {
            return -1;
        }
        if (!this.hasLimit()) {
            return Math.max(this.source.count() - this.minIndexInclusive, 0);
        }
        try (IEnumerator<TSource> en = this.source.enumerator();){
            long count = EnumerablePartition.skipAndCount((long)this.maxIndexInclusive + 1L, en);
            assert (count != 0x80000000L || this.minIndexInclusive > 0) : "Our return value will be incorrect.";
            int n = Math.max((int)count - this.minIndexInclusive, 0);
            return n;
        }
    }

    @Override
    public boolean moveNext() {
        int taken = this.state - 3;
        if (taken < -2) {
            this.close();
            return false;
        }
        switch (this.state) {
            case 1: {
                this.enumerator = this.source.enumerator();
                this.state = 2;
            }
            case 2: {
                if (!this.skipBeforeFirst(this.enumerator)) break;
                this.state = 3;
            }
            default: {
                if (this.hasLimit() && taken >= this.getLimit() || !this.enumerator.moveNext()) break;
                if (this.hasLimit()) {
                    ++this.state;
                }
                this.current = this.enumerator.current();
                return true;
            }
        }
        this.close();
        return false;
    }

    @Override
    public <TResult> IEnumerable<TResult> _select(Func1<TSource, TResult> selector) {
        return new SelectIPartitionIterator<TSource, TResult>(this, selector);
    }

    @Override
    public IPartition<TSource> _skip(int count) {
        int minIndex = this.minIndexInclusive + count;
        if (!this.hasLimit()) {
            if (minIndex < 0) {
                return new EnumerablePartition<TSource>(this, count, -1);
            }
        } else if (Integer.compareUnsigned(minIndex, this.maxIndexInclusive) > 0) {
            return EmptyPartition.instance();
        }
        assert (minIndex >= 0) : String.format("We should have taken care of all cases when %s overflows.", "minIndex");
        return new EnumerablePartition<TSource>(this.source, minIndex, this.maxIndexInclusive);
    }

    @Override
    public IPartition<TSource> _take(int count) {
        int maxIndex = this.minIndexInclusive + count - 1;
        if (!this.hasLimit()) {
            if (maxIndex < 0) {
                return new EnumerablePartition<TSource>(this, 0, count - 1);
            }
        } else if (Integer.compareUnsigned(maxIndex, this.maxIndexInclusive) >= 0) {
            return this;
        }
        assert (maxIndex >= 0) : String.format("We should have taken care of all cases when %s overflows.", "maxIndex");
        return new EnumerablePartition<TSource>(this.source, this.minIndexInclusive, maxIndex);
    }

    @Override
    public TSource _tryGetElementAt(int index, out<Boolean> found) {
        if (!(index < 0 || this.hasLimit() && index >= this.getLimit())) {
            try (IEnumerator<TSource> en = this.source.enumerator();){
                assert (this.minIndexInclusive + index >= 0) : String.format("Adding %s caused %s to overflow.", "index", "minIndexInclusive");
                if (EnumerablePartition.skipBefore(this.minIndexInclusive + index, en) && en.moveNext()) {
                    found.value = true;
                    TSource TSource = en.current();
                    return TSource;
                }
            }
        }
        found.value = false;
        return null;
    }

    @Override
    public TSource _tryGetFirst(out<Boolean> found) {
        try (IEnumerator<TSource> en = this.source.enumerator();){
            if (this.skipBeforeFirst(en) && en.moveNext()) {
                found.value = true;
                TSource TSource = en.current();
                return TSource;
            }
        }
        found.value = false;
        return null;
    }

    @Override
    public TSource _tryGetLast(out<Boolean> found) {
        try (IEnumerator<TSource> en = this.source.enumerator();){
            if (this.skipBeforeFirst(en) && en.moveNext()) {
                TSource result;
                int remaining = this.getLimit() - 1;
                int comparand = this.hasLimit() ? 0 : Integer.MIN_VALUE;
                do {
                    result = en.current();
                } while (--remaining >= comparand && en.moveNext());
                found.value = true;
                TSource TSource = result;
                return TSource;
            }
        }
        found.value = false;
        return null;
    }

    @Override
    public TSource[] _toArray(Class<TSource> clazz) {
        try (IEnumerator<TSource> en = this.source.enumerator();){
            if (this.skipBeforeFirst(en) && en.moveNext()) {
                int remaining = this.getLimit() - 1;
                int comparand = this.hasLimit() ? 0 : Integer.MIN_VALUE;
                int maxCapacity = this.hasLimit() ? this.getLimit() : Integer.MAX_VALUE;
                LargeArrayBuilder<TSource> builder = new LargeArrayBuilder<TSource>(maxCapacity);
                do {
                    builder.add(en.current());
                } while (--remaining >= comparand && en.moveNext());
                T[] TArray = builder.toArray(clazz);
                return TArray;
            }
        }
        return ArrayUtils.empty(clazz);
    }

    @Override
    public Object[] _toArray() {
        try (IEnumerator<TSource> en = this.source.enumerator();){
            if (this.skipBeforeFirst(en) && en.moveNext()) {
                int remaining = this.getLimit() - 1;
                int comparand = this.hasLimit() ? 0 : Integer.MIN_VALUE;
                int maxCapacity = this.hasLimit() ? this.getLimit() : Integer.MAX_VALUE;
                LargeArrayBuilder<TSource> builder = new LargeArrayBuilder<TSource>(maxCapacity);
                do {
                    builder.add(en.current());
                } while (--remaining >= comparand && en.moveNext());
                Object[] objectArray = builder.toArray();
                return objectArray;
            }
        }
        return ArrayUtils.empty();
    }

    @Override
    public List<TSource> _toList() {
        ArrayList<TSource> list = new ArrayList<TSource>();
        try (IEnumerator<TSource> en = this.source.enumerator();){
            if (this.skipBeforeFirst(en) && en.moveNext()) {
                int remaining = this.getLimit() - 1;
                int comparand = this.hasLimit() ? 0 : Integer.MIN_VALUE;
                do {
                    list.add(en.current());
                } while (--remaining >= comparand && en.moveNext());
            }
        }
        return list;
    }

    private boolean skipBeforeFirst(IEnumerator<TSource> en) {
        return EnumerablePartition.skipBefore(this.minIndexInclusive, en);
    }
}

