/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.Comparer;
import com.bestvike.function.Func1;
import com.bestvike.linq.enumerable.AbstractEnumerableSorter;
import java.util.Arrays;
import java.util.Comparator;

final class EnumerableSorter<TElement, TKey>
extends AbstractEnumerableSorter<TElement> {
    private final Func1<TElement, TKey> keySelector;
    private final Comparator<TKey> comparer;
    private final boolean descending;
    private final AbstractEnumerableSorter<TElement> next;
    private Object[] keys;

    EnumerableSorter(Func1<TElement, TKey> keySelector, Comparator<TKey> comparer, boolean descending, AbstractEnumerableSorter<TElement> next) {
        this.keySelector = keySelector;
        this.comparer = comparer;
        this.descending = descending;
        this.next = next;
    }

    @Override
    protected void computeKeys(Object[] elements, int count) {
        this.keys = new Object[count];
        for (int i = 0; i < count; ++i) {
            this.keys[i] = this.keySelector.apply(elements[i]);
        }
        if (this.next == null) {
            return;
        }
        this.next.computeKeys(elements, count);
    }

    @Override
    protected int compareAnyKeys(int index1, int index2) {
        assert (this.keys != null);
        int c = this.comparer.compare(this.keys[index1], this.keys[index2]);
        if (c == 0) {
            if (this.next == null) {
                return index1 - index2;
            }
            return this.next.compareAnyKeys(index1, index2);
        }
        return this.descending != c > 0 ? 1 : -1;
    }

    private int compareKeys(int index1, int index2) {
        return index1 == index2 ? 0 : this.compareAnyKeys(index1, index2);
    }

    @Override
    protected void quickSort(Integer[] keys, int lo, int hi) {
        Arrays.sort(keys, lo, hi - lo + 1, Comparer.create(this::compareAnyKeys));
    }

    @Override
    protected void partialQuickSort(Integer[] map, int left, int right, int minIdx, int maxIdx) {
        do {
            int i = left;
            int j = right;
            int x = map[i + (j - i >> 1)];
            while (true) {
                if (i < map.length && this.compareKeys(x, map[i]) > 0) {
                    ++i;
                    continue;
                }
                while (j >= 0 && this.compareKeys(x, map[j]) < 0) {
                    --j;
                }
                if (i > j) break;
                if (i < j) {
                    int temp = map[i];
                    map[i] = map[j];
                    map[j] = temp;
                }
                if (++i > --j) break;
            }
            if (minIdx >= i) {
                left = i + 1;
            } else if (maxIdx <= j) {
                right = j - 1;
            }
            if (j - left <= right - i) {
                if (left < j) {
                    this.partialQuickSort(map, left, j, minIdx, maxIdx);
                }
                left = i;
                continue;
            }
            if (i < right) {
                this.partialQuickSort(map, i, right, minIdx, maxIdx);
            }
            right = j;
        } while (left < right);
    }

    @Override
    protected int quickSelect(Integer[] map, int right, int idx) {
        int left = 0;
        do {
            int i = left;
            int j = right;
            int x = map[i + (j - i >> 1)];
            while (true) {
                if (i < map.length && this.compareKeys(x, map[i]) > 0) {
                    ++i;
                    continue;
                }
                while (j >= 0 && this.compareKeys(x, map[j]) < 0) {
                    --j;
                }
                if (i > j) break;
                if (i < j) {
                    int temp = map[i];
                    map[i] = map[j];
                    map[j] = temp;
                }
                if (++i > --j) break;
            }
            if (i <= idx) {
                left = i + 1;
            } else {
                right = j - 1;
            }
            if (j - left <= right - i) {
                if (left < j) {
                    right = j;
                }
                left = i;
                continue;
            }
            if (i < right) {
                left = i;
            }
            right = j;
        } while (left < right);
        return map[idx];
    }

    @Override
    protected int min(Integer[] map, int count) {
        int index = 0;
        for (int i = 1; i < count; ++i) {
            if (this.compareKeys(map[i], map[index]) >= 0) continue;
            index = i;
        }
        return map[index];
    }
}

