/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IList;
import com.bestvike.function.Predicate1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.AbstractOrderedEnumerable;
import com.bestvike.linq.enumerable.IPartition;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;
import com.bestvike.out;

public final class First {
    private First() {
    }

    public static <TSource> TSource first(IEnumerable<TSource> source) {
        out<Boolean> foundRef = out.init();
        TSource first = First.tryGetFirst(source, foundRef);
        if (!((Boolean)foundRef.value).booleanValue()) {
            ThrowHelper.throwNoElementsException();
        }
        return first;
    }

    public static <TSource> TSource first(IEnumerable<TSource> source, Predicate1<TSource> predicate) {
        out<Boolean> foundRef = out.init();
        TSource first = First.tryGetFirst(source, predicate, foundRef);
        if (!((Boolean)foundRef.value).booleanValue()) {
            ThrowHelper.throwNoMatchException();
        }
        return first;
    }

    public static <TSource> TSource firstOrDefault(IEnumerable<TSource> source) {
        out<Boolean> foundRef = out.init();
        return First.tryGetFirst(source, foundRef);
    }

    public static <TSource> TSource firstOrDefault(IEnumerable<TSource> source, Predicate1<TSource> predicate) {
        out<Boolean> foundRef = out.init();
        return First.tryGetFirst(source, predicate, foundRef);
    }

    private static <TSource> TSource tryGetFirst(IEnumerable<TSource> source, out<Boolean> found) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (source instanceof IPartition) {
            IPartition partition = (IPartition)source;
            return (TSource)partition._tryGetFirst(found);
        }
        if (source instanceof IList) {
            IList list = (IList)source;
            if (list._getCount() > 0) {
                found.value = true;
                return (TSource)list.get(0);
            }
        } else {
            try (IEnumerator<TSource> e = source.enumerator();){
                if (e.moveNext()) {
                    found.value = true;
                    TSource TSource = e.current();
                    return TSource;
                }
            }
        }
        found.value = false;
        return null;
    }

    private static <TSource> TSource tryGetFirst(IEnumerable<TSource> source, Predicate1<TSource> predicate, out<Boolean> found) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (predicate == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.predicate);
        }
        if (source instanceof AbstractOrderedEnumerable) {
            AbstractOrderedEnumerable ordered = (AbstractOrderedEnumerable)source;
            return ordered._tryGetFirst(predicate, found);
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            while (e.moveNext()) {
                TSource element = e.current();
                if (!predicate.apply(element)) continue;
                found.value = true;
                TSource TSource = element;
                return TSource;
            }
        }
        found.value = false;
        return null;
    }
}

