/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IEqualityComparer;
import com.bestvike.function.Func1;
import com.bestvike.function.Func2;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.AbstractIterator;
import com.bestvike.linq.enumerable.Grouping;
import com.bestvike.linq.enumerable.Lookup;

final class FullJoinIterator<TOuter, TInner, TKey, TResult>
extends AbstractIterator<TResult> {
    private final IEnumerable<TOuter> outer;
    private final IEnumerable<TInner> inner;
    private final Func1<TOuter, TKey> outerKeySelector;
    private final Func1<TInner, TKey> innerKeySelector;
    private final TOuter defaultOuter;
    private final TInner defaultInner;
    private final Func2<TOuter, TInner, TResult> resultSelector;
    private final IEqualityComparer<TKey> comparer;
    private IEnumerator<TOuter> outerEnumerator;
    private IEnumerator<Grouping<TKey, TInner>> unfetchedGroupingEnumerator;
    private Lookup<TKey, TInner> lookup;
    private TOuter item;
    private Grouping<TKey, TInner> g;
    private int index;

    FullJoinIterator(IEnumerable<TOuter> outer, IEnumerable<TInner> inner, Func1<TOuter, TKey> outerKeySelector, Func1<TInner, TKey> innerKeySelector, TOuter defaultOuter, TInner defaultInner, Func2<TOuter, TInner, TResult> resultSelector, IEqualityComparer<TKey> comparer) {
        this.outer = outer;
        this.inner = inner;
        this.outerKeySelector = outerKeySelector;
        this.innerKeySelector = innerKeySelector;
        this.defaultOuter = defaultOuter;
        this.defaultInner = defaultInner;
        this.resultSelector = resultSelector;
        this.comparer = comparer;
    }

    @Override
    public AbstractIterator<TResult> clone() {
        return new FullJoinIterator<TOuter, TInner, TKey, TResult>(this.outer, this.inner, this.outerKeySelector, this.innerKeySelector, this.defaultOuter, this.defaultInner, this.resultSelector, this.comparer);
    }

    @Override
    public boolean moveNext() {
        block7: while (true) {
            switch (this.state) {
                case 1: {
                    this.outerEnumerator = this.outer.enumerator();
                    this.lookup = Lookup.createForFullJoin(this.inner, this.innerKeySelector, this.comparer);
                    this.state = 2;
                }
                case 2: {
                    if (this.outerEnumerator.moveNext()) {
                        this.item = this.outerEnumerator.current();
                        this.g = this.lookup.fetchGrouping(this.outerKeySelector.apply(this.item));
                        if (this.g == null) {
                            this.current = this.resultSelector.apply(this.item, this.defaultInner);
                            return true;
                        }
                        this.index = -1;
                        this.state = 4;
                        continue block7;
                    }
                    this.unfetchedGroupingEnumerator = this.lookup.unfetchedEnumerator();
                    this.state = 3;
                }
                case 3: {
                    if (this.unfetchedGroupingEnumerator.moveNext()) {
                        this.g = this.unfetchedGroupingEnumerator.current();
                        this.index = -1;
                        this.state = 5;
                        continue block7;
                    }
                    this.close();
                    return false;
                }
                case 4: {
                    ++this.index;
                    if (this.index < this.g._getCount()) {
                        this.current = this.resultSelector.apply(this.item, this.g.get(this.index));
                        return true;
                    }
                    this.state = 2;
                    continue block7;
                }
                case 5: {
                    ++this.index;
                    if (this.index < this.g._getCount()) {
                        this.current = this.resultSelector.apply(this.defaultOuter, this.g.get(this.index));
                        return true;
                    }
                    this.state = 3;
                    continue block7;
                }
            }
            break;
        }
        return false;
    }

    @Override
    public void close() {
        if (this.outerEnumerator != null) {
            this.outerEnumerator.close();
            this.outerEnumerator = null;
            this.lookup = null;
            this.item = null;
            this.g = null;
        }
        if (this.unfetchedGroupingEnumerator != null) {
            this.unfetchedGroupingEnumerator.close();
            this.unfetchedGroupingEnumerator = null;
        }
        super.close();
    }
}

