/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IEqualityComparer;
import com.bestvike.function.Func1;
import com.bestvike.function.Func2;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.IIListProvider;
import com.bestvike.linq.enumerable.Lookup;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;
import java.util.List;

final class GroupedResultEnumerable<TSource, TKey, TResult>
implements IIListProvider<TResult> {
    private final IEnumerable<TSource> source;
    private final Func1<TSource, TKey> keySelector;
    private final IEqualityComparer<TKey> comparer;
    private final Func2<TKey, IEnumerable<TSource>, TResult> resultSelector;

    GroupedResultEnumerable(IEnumerable<TSource> source, Func1<TSource, TKey> keySelector, Func2<TKey, IEnumerable<TSource>, TResult> resultSelector, IEqualityComparer<TKey> comparer) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (keySelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.keySelector);
        }
        if (resultSelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.resultSelector);
        }
        this.source = source;
        this.keySelector = keySelector;
        this.resultSelector = resultSelector;
        this.comparer = comparer;
    }

    @Override
    public IEnumerator<TResult> enumerator() {
        Lookup<TKey, TSource> lookup = Lookup.create(this.source, this.keySelector, this.comparer);
        return lookup.applyResultSelector(this.resultSelector).enumerator();
    }

    @Override
    public TResult[] _toArray(Class<TResult> clazz) {
        return Lookup.create(this.source, this.keySelector, this.comparer)._toArray(clazz, this.resultSelector);
    }

    @Override
    public Object[] _toArray() {
        return Lookup.create(this.source, this.keySelector, this.comparer)._toArray(this.resultSelector);
    }

    @Override
    public List<TResult> _toList() {
        return Lookup.create(this.source, this.keySelector, this.comparer)._toList(this.resultSelector);
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        return onlyIfCheap ? -1 : Lookup.create(this.source, this.keySelector, this.comparer).getCount();
    }
}

