/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;
import com.bestvike.linq.util.Strings;

public final class Joining {
    private Joining() {
    }

    public static <TSource> String joining(IEnumerable<TSource> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            if (!e.moveNext()) {
                String string = "";
                return string;
            }
            String text = String.valueOf(e.current());
            if (!e.moveNext()) {
                String string = text;
                return string;
            }
            StringBuilder sb = new StringBuilder(text);
            do {
                sb.append(e.current());
            } while (e.moveNext());
            String string = sb.toString();
            return string;
        }
    }

    public static <TSource> String joining(IEnumerable<TSource> source, CharSequence separator) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            if (!e.moveNext()) {
                String string = "";
                return string;
            }
            String text = String.valueOf(e.current());
            if (!e.moveNext()) {
                String string = text;
                return string;
            }
            StringBuilder sb = new StringBuilder(text);
            if (Strings.isNullOrEmpty(separator)) {
                do {
                    sb.append(e.current());
                } while (e.moveNext());
            } else {
                do {
                    sb.append(separator);
                    sb.append(e.current());
                } while (e.moveNext());
            }
            String string = sb.toString();
            return string;
        }
    }

    public static <TSource> String joining(IEnumerable<TSource> source, CharSequence separator, CharSequence prefix, CharSequence suffix) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        StringBuilder sb = new StringBuilder();
        if (!Strings.isNullOrEmpty(prefix)) {
            sb.append(prefix);
        }
        if (Strings.isNullOrEmpty(separator)) {
            try (IEnumerator<TSource> e = source.enumerator();){
                while (e.moveNext()) {
                    sb.append(e.current());
                }
            }
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            if (e.moveNext()) {
                sb.append(e.current());
                while (e.moveNext()) {
                    sb.append(separator);
                    sb.append(e.current());
                }
            }
        }
        if (!Strings.isNullOrEmpty(suffix)) {
            sb.append(suffix);
        }
        return sb.toString();
    }
}

