/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.ArrayBuilder;
import com.bestvike.linq.enumerable.CopyPosition;
import com.bestvike.linq.util.ArrayUtils;
import com.bestvike.out;
import com.bestvike.ref;

final class LargeArrayBuilder<T> {
    private static final int StartingCapacity = 4;
    private static final int ResizeLimit = 8;
    private final int maxCapacity;
    private Object[] first;
    private ArrayBuilder<Object[]> buffers = new ArrayBuilder();
    private Object[] current;
    private int index;
    private int count;

    LargeArrayBuilder() {
        this(Integer.MAX_VALUE);
    }

    LargeArrayBuilder(int maxCapacity) {
        assert (maxCapacity >= 0);
        this.current = ArrayUtils.empty();
        this.first = this.current;
        this.maxCapacity = maxCapacity;
    }

    public int getCount() {
        return this.count;
    }

    public void add(T item) {
        assert (this.maxCapacity > this.count);
        if (Integer.compareUnsigned(this.index, this.current.length) >= 0) {
            this.addWithBufferAllocation(item);
        } else {
            this.current[this.index++] = item;
        }
        ++this.count;
    }

    private void addWithBufferAllocation(T item) {
        this.allocateBuffer();
        this.current[this.index++] = item;
    }

    public void addRange(IEnumerable<T> items) {
        assert (items != null);
        try (IEnumerator<T> enumerator = items.enumerator();){
            ref<Object[]> destinationRef = ref.init(this.current);
            ref<Integer> indexRef = ref.init(this.index);
            while (enumerator.moveNext()) {
                T item = enumerator.current();
                if (Integer.compareUnsigned((Integer)indexRef.value, ((Object[])destinationRef.value).length) >= 0) {
                    this.addWithBufferAllocation(item, destinationRef, indexRef);
                } else {
                    ((Object[])destinationRef.value)[((Integer)indexRef.value).intValue()] = item;
                }
                ref<Integer> ref2 = indexRef;
                Integer n = (Integer)ref2.value;
                ref2.value = (Integer)ref2.value + 1;
                Integer n2 = ref2.value;
            }
            this.count += (Integer)indexRef.value - this.index;
            this.index = (Integer)indexRef.value;
        }
    }

    private void addWithBufferAllocation(T item, ref<Object[]> destination, ref<Integer> index) {
        this.count += (Integer)index.value - this.index;
        this.index = (Integer)index.value;
        this.allocateBuffer();
        destination.value = this.current;
        index.value = this.index;
        this.current[((Integer)index.value).intValue()] = item;
    }

    private void copyTo(Object[] array, int arrayIndex, int count) {
        assert (arrayIndex >= 0);
        assert (count >= 0 && count <= this.getCount());
        assert (array != null && array.length - arrayIndex >= count);
        int i = 0;
        while (count > 0) {
            Object[] buffer = this.getBuffer(i);
            int toCopy = Math.min(count, buffer.length);
            System.arraycopy(buffer, 0, array, arrayIndex, toCopy);
            count -= toCopy;
            arrayIndex += toCopy;
            ++i;
        }
    }

    public CopyPosition copyTo(CopyPosition position, Object[] array, int arrayIndex, int count) {
        assert (array != null);
        assert (arrayIndex >= 0);
        assert (count > 0 && count <= this.getCount());
        assert (array.length - arrayIndex >= count);
        int row = position.getRow();
        int column = position.getColumn();
        ref<Integer> arrayIndexRef = ref.init(arrayIndex);
        ref<Integer> countRef = ref.init(count);
        Object[] buffer = this.getBuffer(row);
        int copied = this.copyToCore(buffer, column, array, arrayIndexRef, countRef);
        if ((Integer)countRef.value == 0) {
            return new CopyPosition(row, column + copied).normalize(buffer.length);
        }
        do {
            buffer = this.getBuffer(++row);
            copied = this.copyToCore(buffer, 0, array, arrayIndexRef, countRef);
        } while ((Integer)countRef.value > 0);
        return new CopyPosition(row, copied).normalize(buffer.length);
    }

    private int copyToCore(Object[] sourceBuffer, int sourceIndex, Object[] array, ref<Integer> arrayIndex, ref<Integer> count) {
        assert (sourceBuffer.length > sourceIndex);
        int copyCount = Math.min(sourceBuffer.length - sourceIndex, (Integer)count.value);
        System.arraycopy(sourceBuffer, sourceIndex, array, (Integer)arrayIndex.value, copyCount);
        ref<Integer> ref2 = arrayIndex;
        ref2.value = (Integer)ref2.value + copyCount;
        ref2 = count;
        ref2.value = (Integer)ref2.value - copyCount;
        return copyCount;
    }

    public Object[] getBuffer(int index) {
        assert (index >= 0 && index < this.buffers.getCount() + 2);
        return index == 0 ? this.first : (index <= this.buffers.getCount() ? this.buffers.get(index - 1) : this.current);
    }

    public void slowAdd(T item) {
        this.add(item);
    }

    public T[] toArray(Class<T> clazz) {
        out<Object[]> arrayRef = out.init();
        if (this.tryMove(arrayRef)) {
            return ArrayUtils.toArray((Object[])arrayRef.value, clazz);
        }
        Object[] array = ArrayUtils.newInstance(clazz, this.count);
        this.copyTo(array, 0, this.count);
        return array;
    }

    public Object[] toArray() {
        out<Object[]> arrayRef = out.init();
        if (this.tryMove(arrayRef)) {
            return (Object[])arrayRef.value;
        }
        Object[] array = new Object[this.count];
        this.copyTo(array, 0, this.count);
        return array;
    }

    public boolean tryMove(out<Object[]> array) {
        array.value = this.first;
        return this.count == this.first.length;
    }

    private void allocateBuffer() {
        assert (Integer.compareUnsigned(this.maxCapacity, this.count) > 0);
        assert (this.index == this.current.length) : String.format("%s was called, but there's more space.", "allocateBuffer");
        if (Integer.compareUnsigned(this.count, 8) < 0) {
            assert (this.current == this.first && this.count == this.first.length);
            int nextCapacity = Math.min(this.count == 0 ? 4 : this.count * 2, this.maxCapacity);
            this.current = new Object[nextCapacity];
            System.arraycopy(this.first, 0, this.current, 0, this.count);
            this.first = this.current;
        } else {
            int nextCapacity;
            assert (this.maxCapacity > 8);
            assert (this.count == 8 ^ this.current != this.first);
            if (this.count == 8) {
                nextCapacity = 8;
            } else {
                assert (this.count >= 16);
                assert (this.count == this.current.length * 2);
                this.buffers.add(this.current);
                nextCapacity = Math.min(this.count, this.maxCapacity - this.count);
            }
            this.current = new Object[nextCapacity];
            this.index = 0;
        }
    }
}

