/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.function.Func1;
import com.bestvike.function.Predicate1;
import com.bestvike.linq.enumerable.AbstractIterator;

final class LoopIterator2<TSource>
extends AbstractIterator<TSource> {
    private final TSource seed;
    private final Predicate1<TSource> condition;
    private final Func1<TSource, TSource> next;

    LoopIterator2(TSource seed, Predicate1<TSource> condition, Func1<TSource, TSource> next) {
        this.seed = seed;
        this.condition = condition;
        this.next = next;
    }

    @Override
    public AbstractIterator<TSource> clone() {
        return new LoopIterator2<TSource>(this.seed, this.condition, this.next);
    }

    @Override
    public boolean moveNext() {
        switch (this.state) {
            case 1: {
                TSource item = this.seed;
                if (this.condition.apply(item)) {
                    this.current = item;
                    this.state = 2;
                    return true;
                }
                this.close();
                return false;
            }
            case 2: {
                TSource item = this.next.apply(this.current);
                if (this.condition.apply(item)) {
                    this.current = item;
                    return true;
                }
                this.close();
                return false;
            }
        }
        return false;
    }
}

