/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.debug.DebuggerDisplay;
import java.util.Objects;

@DebuggerDisplay(value="{debuggerDisplay(),nq}")
final class Marker {
    private final int count;
    private final int index;

    Marker(int count, int index) {
        assert (count >= 0);
        assert (index >= 0);
        this.count = count;
        this.index = index;
    }

    public int getCount() {
        return this.count;
    }

    public int getIndex() {
        return this.index;
    }

    private String debuggerDisplay() {
        return this.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof Marker)) return false;
        Marker that = (Marker)obj;
        if (!Objects.equals(this.count, that.count)) return false;
        if (!Objects.equals(this.index, that.index)) return false;
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.count;
        result = 31 * result + this.index;
        return result;
    }

    public String toString() {
        return String.format("index: %s, count: %s", this.index, this.count);
    }
}

